

<?php $__env->startSection('content'); ?>
    <div class="row clearfix">
        <div class="col-lg-12">
            <div class="card">
                <div class="header">
                    <h2><strong>All</strong> Blogs </h2>
                    <ul class="header-dropdown">
                        <li class="dropdown">
                            <a href="<?php echo e(route('blogs.create')); ?>" class="btn btn-primary btn-sm float-right">Add
                                Blog</a>
                        </li>
                    </ul>
                </div>
                <div class="mt-2">
                    <?php echo $__env->make('admin.layouts.partials.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover js-basic-example dataTable">
                            <thead>
                                <tr>
                                    <th>Image</th>
                                    <th>Name</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tfoot>
                                <tr>
                                    <th>Image</th>
                                    <th>Name</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </tfoot>
                            <tbody>
                                <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><img src="<?php echo e(asset('admin-assets/images/blogs')); ?>/<?php echo e($blog->feature_image); ?>"
                                                alt="" width="40"></td>
                                        <td><?php echo e($blog->title); ?></td>
                                        <td><?php if($blog->status == 'publish'): ?> <span class="badge badge-success">Published</span> <?php else: ?> <span class="badge badge-primary">Draft</span> <?php endif; ?></td>
                                        <td>
                                            <a class="btn btn-primary btn-sm"
                                                href="<?php echo e(route('blogs.edit', $blog->id)); ?>">Edit</a>

                                            <?php echo Form::open(['method' => 'DELETE', 'route' => ['blogs.destroy', $blog->id], 'style' => 'display:inline']); ?>

                                            <?php echo Form::submit('Delete', ['class' => 'btn btn-danger btn-sm']); ?>

                                            <?php echo Form::close(); ?>

                                            
                                            <a class="btn btn-info btn-sm"
                                                href="<?php echo e(route('blog.details', $blog->slug)); ?>">Preview</a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <div class="d-flex">
                            <?php echo $blogs->links('pagination::bootstrap-4'); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom-scripts'); ?>
    <script>
        $(".alert").delay(4000).slideUp(200, function() {
            $(this).alert('close');
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/coupuzzt/realtimebrief.com/resources/views/admin/pages/blogs/index.blade.php ENDPATH**/ ?>