
<?php $__env->startSection('meta-content'); ?>
 <?php
    $settings = \App\Models\GeneralSetting::find(1);
    ?>
<title><?php if($settings): ?><?php echo e($settings->site_title); ?><?php endif; ?></title>
<meta name="description" content="<?php if($settings): ?><?php echo e($settings->meta_description); ?><?php endif; ?>">
<meta name="title" content="<?php if($settings): ?><?php echo e($settings->meta_title); ?><?php endif; ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom-styles'); ?>
    <style>
        /*====================single store========*/

        .single_store {
            padding-top: 50px;
            /* background: #f6f8fc;  */
        }

        .single_store_container {
            display: flex;
            grid-gap: 30px;
            align-items: flex-start;
            justify-content: center;
            position: relative;
        }

        .side_bar {
            flex: 0 0 280px;
            display: flex;
            flex-direction: column;
            grid-gap: 30px;
        }

        .side_bar_items {
            background: var(--tg-teal);
            border-radius: 10px;
            box-shadow: 0 0 10px #0001;
            padding: 15px;
        }

        .side_bar_heading {
            font-size: 17px;
            display: flex;
            align-items: center;
            grid-gap: 10px;
            font-weight: 600;
            text-transform: capitalize;
            border-bottom: 2px solid #0001;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }

        [tg-theme=dark] .store-description {
            color: var(--tg-gray-three);
        }


        .coupons_container_main {
            flex: 1;
            display: flex;
            flex-direction: column;
            grid-gap: 30px;
        }

        .store_list_header {
            background: var(--tg-teal);
            border-radius: 10px;
            padding: 15px;
            box-shadow: 0 0 10px #0002;
            display: flex;
            grid-gap: 20px;
            align-items: center;
        }

        .store_list_header_img {
            height: 110px;
            flex: 0 0 120px;
            background: #fff;
            overflow: hidden;
            box-shadow: 0 0 10px #0002;
            border-radius: 12px;
        }


        .store_list_header_img .web_imagebox {
            height: 100%;
            width: 100%;
            /*border-radius: 50%;*/
            overflow: hidden;

        }

        .store_list_header_img .web_imagebox img {
            max-height: 100%;
            max-width: 100%;
        }

        .store_list_header_content {
            display: flex;
            flex-direction: column;
            grid-gap: 10px;
        }

        .store_list_header_content h2 {
            font-size: 21px;
            font-weight: 600;
            color: var(--tg-heading-font-color);
            /*text-transform: capitalize;*/
        }

        .store_breadcrumbs {
            display: flex;
            grid-gap: 7px;
            align-items: center;
            list-style: none;
            /*justify-content: center;*/
        }

        .store_breadcrumbs a {
            font-size: 14px;
            font-weight: 600;
            color: var(--tg-heading-font-color);
        }

        .store_breadcrumbs a.store_breadcrumbs_active {
            color: #F9A602;
            cursor: default;
        }

        .store_breadcrumbs i {
            font-size: 15px;
            font-weight: 600;
            color: var(--tg-heading-font-color);
        }

        .store_list_header_content p {
            font-size: 14px;
            font-weight: 600;
            color: var(--tg-heading-font-color);
            ;
            display: flex;
            align-items: center;
            grid-gap: 5px;
        }

        .store_list_header_content p i {
            font-size: 20px;
            color: #5ec963;
        }

        .coupons_container {
            display: grid;
            grid-template-columns: 1fr 1fr;
            grid-gap: 30px;
        }

        .coupon {
            background: var(--tg-teal);
            border-radius: 10px;
            box-shadow: 0 0 10px #0002;
            grid-gap: 15px;
            /* overflow: hidden; */
            flex-direction: column;
            display: flex;
            position: relative;
        }

        .ribbon2 {
            width: 33px;
            padding: 14px 0;
            position: absolute;
            top: -7px;
            right: 15px;
            font-size: 10px;
            color: #fff;
            text-align: center;
            border-top-left-radius: 3px;
            background: #74dd78;
        }

        .ribbon2:before {
            height: 0;
            width: 0;
            right: -6.5px;
            top: 0.1px;
            border-bottom: 6px solid #55a758;
            border-right: 6px solid transparent;
        }

        .ribbon2:before,
        .ribbon2:after {
            content: "";
            position: absolute;
        }

        .ribbon2:after {
            height: 0;
            width: 33px;
            bottom: -10.5px;
            left: 0;
            border-left: 10px solid #74dd78;
            border-right: 10px solid #74dd78;
            border-bottom: 10px solid transparent;
        }

        .ribbon2:before,
        .ribbon2:after {
            content: "";
            position: absolute;
        }

        .coupon_head {
            display: flex;
            grid-gap: 20px;
            padding: 15px 35px 0 20px;
        }

        .coupon_head_title {
            display: flex;
            flex-direction: column;
            flex: 1;
            grid-gap: 10px;
        }

        .coupon_badges {
            display: flex;
            justify-content: flex-end;
            align-items: center;
        }

        .uses {
            background: #00a7cb;
            color: #fff;
            font-size: 13px;
            font-weight: 500;
        }

        .coupon_badge {
            display: flex;
            align-items: center;
            grid-gap: 5px;
            border-radius: 5px;
            padding: 3px 20px;
            justify-content: center;
            box-shadow: inset 0 0 5px #0001;
            flex: 1;
            background: #ebffec;
        }



        .coupon_badge p {
            font-size: 13px;
            font-weight: 600;
            text-transform: capitalize;
            color: #3e8541;
            position: relative;
            top: 8px;
        }

        .coupon_badge i {
            color: #3e8541;
            font-size: 14px;
        }

        .coupons_img {
            height: 80px;
            width: 80px;
        }

        .coupons_img .web_imagebox {
            height: 100%;
            width: 100%;
        }

        .coupons_img .web_imagebox img {
            max-height: 100%;
            max-width: 100%;
        }

        .cut_icon {
            color: #000;
            font-size: 20px;
            left: -20px;
        }

        .coupon_content_title {
            font-size: 17px;
            font-weight: 600;
            color: var(--tg-heading-font-color);
            line-height: 1.3;
        }

        .coupon_content_about {
            font-size: 14px;
            font-weight: 500;
            display: -webkit-box;
            color: #0008;
            overflow: hidden;
            -webkit-box-orient: vertical;
        }

        .single_store_btn {
            /* margin-bottom: 15px; */
            margin-top: 0;
        }

        .coupon_content {
            display: flex;
            padding: 10px 15px;
            margin-bottom: 0px;
            align-items: center;
            border-top: 1px solid #f1f1f1;
            margin-top: auto;
        }

        .modal.in .modal-dialog {
            transform: translateY(-50%) !important;
            top: 50%;
        }

        .coupon_btn p {
            font-size: 15px;
            text-transform: capitalize;
            font-weight: 600;
            grid-gap: 5px;
        }

        .coupon_content_body p {
            font-size: 14px;
            font-weight: 500;
            color: #0008;
        }

        .coupon_content_badge {
            display: flex;
            justify-content: space-between;
            padding-bottom: 10px;
            padding: 10px 10px 10px 20px;
        }

        .coupon_content_badge p {
            display: flex;
            align-items: center;
            line-height: 1;
            grid-gap: 5px;
            font-size: 13px;
            font-weight: 500;
            text-transform: capitalize;
        }

        .show_coupon {
            cursor: pointer;
        }

        .single_store_btn {
            /* margin-bottom: 15px; */
            margin-top: 0;
        }

        .featured_blogs_coupon_btn {
            display: block;
            height: 40px;
            width: 180px;
            overflow: hidden;
            border-radius: 5px;
            margin-top: 10px;
            margin-left: auto;
        }



        .featured_blogs_coupon_btn p {
            height: 100%;
            text-align: center;
            line-height: 40px;
            font-size: 14px;
            text-transform: capitalize;
            font-weight: 500;
            text-indent: -5px;
        }

        .ls-list {
            padding: 0;
            margin: 0;
            list-style: none;
            display: grid;
            grid-template-columns: repeat(2, minmax(0, 1fr));
            grid-gap: 12px;
        }

        .ls-list li {
            padding: 5px;
        }

        .category-info-small {
            background-color: var(--tg-teal);
            padding: 7px;
            border-radius: 7px;
            box-shadow: 0 0 3px rgb(0 0 0 / 10%);
        }



        .icon-web {
            text-align: center;
            font-size: 20px;
            margin-bottom: 0px;
            color: var(--tg-heading-font-color);
            width: 35px;
            height: 35px;
            margin: auto;
            background: var(--tg-teal);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .c-name {
            width: 100%;
            -webkit-line-clamp: 1;
            display: -webkit-box;
            -webkit-box-orient: vertical;
            overflow: hidden;
            font-size: 14px;
            font-weight: 500;
            color: var(--tg-heading-font-color);
            text-overflow: ellipsis;
            text-align: center;
        }





        .featured_blogs_coupon_btn p i {
            padding-right: 5px;
            font-size: 16px;
            font-weight: 300;
        }

        .featured_blogs_coupon_btn.get_deal p:nth-child(1) {
            background: #883002;
        }

        .featured_blogs_coupon_btn p:nth-child(1) {
            background: #F9A602;
            box-shadow: inset 0 0 10px #0001;
            color: #fff;
        }

        .featured_blogs_coupon_btn p:nth-child(2) {
            background: #f6f8fc;
            box-shadow: inset 0 0 10px #ddd;
            color: #0009;
            font-size: 17px;
            font-weight: 600;
        }

        .codes {
            transition: 0.3s cubic-bezier(0, 0.43, 0.69, 1.65);
        }

        .featured_blogs_coupon_btn:not(.get_deal):hover .codes {
            margin-top: -60px;
        }

        .modal.in .modal-dialog {
            transform: translateY(-50%) !important;
            top: 50%;
        }

        .modal-open {
            overflow: hidden
        }

        .modal {
            position: fixed;
            top: 0;
            right: 0;
            bottom: 0;
            left: 0;
            z-index: 1050;
            display: none;
            overflow: hidden;
            -webkit-overflow-scrolling: touch;
            outline: 0
        }

        .modal.fade .modal-dialog {
            -webkit-transition: -webkit-transform .3s ease-out;
            -o-transition: -o-transform .3s ease-out;
            transition: transform .3s ease-out;
            -webkit-transform: translate(0, -25%);
            -ms-transform: translate(0, -25%);
            -o-transform: translate(0, -25%);
            transform: translate(0, -25%)
        }

        .modal.in .modal-dialog {
            -webkit-transform: translate(0, 0);
            -ms-transform: translate(0, 0);
            -o-transform: translate(0, 0);
            transform: translate(0, 0)
        }

        .modal-open .modal {
            overflow-x: hidden;
            overflow-y: auto
        }

        .modal-dialog {
            position: relative;
            width: auto;
            margin: 10px
        }

        .modal-content {
            position: relative;
            background-color: #fff;
            -webkit-background-clip: padding-box;
            background-clip: padding-box;
            border: 1px solid #999;
            border: 1px solid rgba(0, 0, 0, .2);
            border-radius: 6px;
            outline: 0;
            -webkit-box-shadow: 0 3px 9px rgba(0, 0, 0, .5);
            box-shadow: 0 3px 9px rgba(0, 0, 0, .5)
        }

        .modal-backdrop {
            position: fixed;
            top: 0;
            right: 0;
            bottom: 0;
            left: 0;
            z-index: 1040;
            background-color: #000
        }

        .modal-backdrop.fade {
            filter: alpha(opacity=0);
            opacity: 0
        }

        .modal-backdrop.in {
            filter: alpha(opacity=50);
            opacity: .5
        }

        .modal-header {
            padding: 15px;
            border-bottom: 1px solid #e5e5e5
        }

        .modal-header .close {
            margin-top: -2px
        }

        .modal-title {
            margin: 0;
            line-height: 1.42857143
        }

        .modal-body {
            position: relative;
            padding: 15px
        }

        .modal-footer {
            padding: 15px;
            text-align: right;
            border-top: 1px solid #e5e5e5
        }

        .modal-footer .btn+.btn {
            margin-bottom: 0;
            margin-left: 5px
        }

        .modal-footer .btn-group .btn+.btn {
            margin-left: -1px
        }

        .modal-footer .btn-block+.btn-block {
            margin-left: 0
        }

        .modal-scrollbar-measure {
            position: absolute;
            top: -9999px;
            width: 50px;
            height: 50px;
            overflow: scroll
        }

        @media (min-width:768px) {
            .modal-dialog {
                width: 600px;
                margin: 30px auto
            }

            .modal-content {
                -webkit-box-shadow: 0 5px 15px rgba(0, 0, 0, .5);
                box-shadow: 0 5px 15px rgba(0, 0, 0, .5)
            }

            .modal-sm {
                width: 300px
            }
        }

        @media (min-width:992px) {
            .modal-lg {
                width: 900px
            }
        }

        .modal-footer:after,
        .modal-footer:before,
        .modal-header:after,
        .modal-header:before {
            display: table;
            content: " "
        }

        .modal-footer:after,
        .modal-header:after {
            clear: both
        }

        .modal.in .modal-dialog {
            transform: translateY(-50%) !important;
            top: 50%;
        }

        .modal-content {
            overflow: hidden;
            border: 0;
        }

        .modal-header {
            padding: 0 !important;
        }

        .modal-title {
            background: #F9A602;
            display: inline-block;
            position: relative;
            left: 0px;
            border-radius: 0 0 5px 5px;
            box-shadow: -3px 3px 0px #0002;
            color: #fff;
            top: -10px;
            padding: 5px 30px;
        }

        .modal-title:before {
            position: absolute;
            content: '';
            height: 10px;
            width: 10px;
            background: #7fa513;
            top: 0;
            right: 100%;
            clip-path: polygon(100% 0, 0% 100%, 100% 100%);
        }

        .modal-content {
            overflow: inherit;
            border: 0;
            /*display: flex;*/
            border-radius: 10px;
        }

        .store_title_modal {
            /*display: flex;*/
            grid-gap: 20px;
            padding-bottom: 20px;
            align-items: center;
            margin-top: -10px;
            padding: 0 20px;
            padding-bottom: 15px;
        }

        .store_modal {
            font-size: 20px;
            font-weight: 600;
            color: #4d6603;
        }

        .modal_title_img {
            height: 80px;
            flex: 0 0 auto;
            width: 80px;
            /* border: 5px solid #fff; */
            box-shadow: 0 0 10px #0001;
            background: #fff;
            border-radius: 50%;
            overflow: hidden;
        }

        .modal_title_img .web_imagebox {
            height: 100%;
            width: 100%;
        }

        .modal_title_img .web_imagebox img {
            max-height: 100%;
            max-width: 100%;
            border-radius: 5px;
        }

        .close_modal {
            height: 30px;
            width: 30px;
            background: #F9A602 !important;
            opacity: 1;
            border-radius: 50%;
            position: absolute;
            top: -15px;
            right: -15px;
        }

        .close_modal:hover,
        .close_modal:focus {
            opacity: 1;
        }

        .close_modal span {
            font-size: 25px;
            font-weight: 600;
            text-shadow: none;
            color: #fff;
            position: relative;
            top: -10px;
            right: 1px;
        }

        .modal-body {
            /*display: flex;*/
            justify-content: space-between;
            align-items: flex-start;
            overflow: hidden;
            padding: 0 !important;
        }

        .modal_body_main {
            padding: 20px;
            display: flex;
            flex-direction: column;
            grid-gap: 10px;
            align-items: center;
        }

        .modal_body_main p {
            font-size: 14px;
            font-weight: 500;
            color: #0009;
            text-align: center;
        }

        .modal_code {
            padding: 8px 0;
            max-width: 200px;
            width: 100%;
            border: 2px dashed #F9A602;
            background: #f7ffdf;
            font-weight: 600;
            border-radius: 5px;
            cursor: pointer;
            display: flex;
            font-size: 15px;
            align-items: center;
            justify-content: center;
        }


        .visit_site {
            font-size: 14px;
            font-weight: 500;
            color: #ffffff;
            padding: 8px 15px;
            /* padding: 2px 5px; */
            display: inline-block;
            text-transform: capitalize;
            letter-spacing: 1px;
            border-radius: 10px 0;
            background: #87a72c;
            transition: 0.3s ease;
        }

        .visit_site i {
            font-size: 15px;
        }

        .visit_site:hover {
            border-radius: 5px;
            color: white;
        }

        .modal_body_sidebar {
            flex: 0 0 200px;
            background: #87a72c;
            box-shadow: 0 0 10px #0001;
            display: flex;
            justify-content: center;
            border-radius: 0 10px 10px 0;
            flex-direction: column;
        }

        .modal_badge {
            display: flex;
            align-items: flex-start;
            grid-gap: 10px;
            justify-content: flex-start;
            align-items: center;
            padding: 10px 20px;
            border-bottom: 1px solid #fff3;
        }

        .modal_badge:last-of-type {
            border: 0;
        }

        .modal_badge_content {
            display: flex;
            grid-gap: 2px;
            flex-direction: column;
        }

        .modal_badge_content_title {
            font-size: 14px;
            font-weight: 400;
            text-transform: capitalize;
            color: #fff;
        }

        .modal_badge_content_title~p {
            font-weight: 500;
            color: #fff9;
            font-size: 13px;
        }

        .modal_badge .stars i {
            font-size: 20px;
            color: #fff8;
        }

        .modal_badge .stars i:hover {
            color: #ffc107;
        }
        @media (max-width: 992px) {
                .single_store_container {
        flex-direction: column-reverse;
    }
    .coupons_container_main {
        width: 100%;
    }
    .side_bar {
        width: 100%;
        display: grid;
        grid-template-columns: repeat(3, 1fr);
    }
        .coupons_container_main {
        width: 100%;
    }
        .coupons_container {
        grid-template-columns: repeat(2, 1fr);
    }
}
@media (max-width: 550px) {
    .side_bar {
        grid-template-columns: repeat(1, 1fr);
    }
}

@media (max-width: 800px) {
    .side_bar {
        grid-template-columns: repeat(1, 1fr);
    }
        .coupons_container {
        grid-template-columns: repeat(1, 1fr);
    }
}

@media (max-width: 425px) {
    .store_list_header {
        display: block;
    }
        .store_list_header_img {
        width: 70px;
        float: left;
        height: 70px;
    }
    .store_list_header_content {
        display: inherit;
    }
    .store_list_header_content h2 {
        padding-left: 80px;
        margin-top: 0;
    }
        ul.store_breadcrumbs {
        padding-left: 10px;
        padding-top: 10px;
    }
    .store_list_header_content p {
        margin-top: 20px;
    }
       
}
@media (max-width: 400px) {
    ul.store_breadcrumbs {
        margin-top: 20px;
        padding-top: 0;
    }
    .store_list_header_content p {
        margin-top: 5px;
    }
}
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- breadcrumb-area -->
    <div class="breadcrumb-area">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-content">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo e(route('index')); ?>">Home</a></li>
                                <li class="breadcrumb-item" aria-current="page"><a href="javascript:;">Blogs</a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?php echo e($store->slug); ?></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb-area-end -->
    <section class="single_store">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="single_store_container">
                        <div class="side_bar">
                            <div class="side_bar_items">
                                <h2 class="side_bar_heading"><i class="fa fa-dot-circle-o"></i>About</h2>
                                <div class="store-description"><?php echo e($store->description); ?></div>
                            </div>

                            <div class="side_bar_items">
                                <h2 class="side_bar_heading"><i class="fa fa-dot-circle-o"></i> Popular Stores</h2>
                                <ul class="ls-list">
                                    <?php $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <a href="<?php echo e(route('store.profile', $row->slug)); ?>">
                                                <div class="category-info-small">

                                                    <img src ="<?php echo e(asset('admin-assets/images/stores')); ?>/<?php echo e($row->feature_image); ?>"
                                                        class="lazy shimmering">

                                                    <div class="c-name"><?php echo e($row->name); ?></div>
                                                </div>
                                            </a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </ul>
                            </div>
                        </div>
                        <div class="coupons_container_main">
                            <div class="store_list_header">
                                <div class="store_list_header_img">
                                    <a href="#" class="web_imagebox">
                                        <img class="lazy"
                                            src="<?php echo e(asset('admin-assets/images/stores')); ?>/<?php echo e($store->feature_image); ?>"
                                            style="">
                                    </a>
                                </div>
                                <div class="store_list_header_content">
                                    <h2> <?php echo e($store->name); ?> </h2>
                                    <ul class="store_breadcrumbs">
                                        <li><a href="#">Home</a></li>
                                        <li><i class="fa fa-angle-right"></i></li>
                                        <li><a class="store_breadcrumbs_active"
                                                href="javascript:void(0);"><?php echo e($store->slug); ?></a></li>
                                    </ul>
                                    <p><i class="fa fa-check-circle"></i>Every Code Is Hand Tested By Us.</p>
                                </div>
                            </div>

                            <div class="coupons_container">
                                <?php $__currentLoopData = $coupons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="coupon cpn-filter" data-coupon-id="2512" data-sort-type="code">
                                        <div class="coupon_head">
                                            <div class="coupons_img">
                                                <a href="javascript:void(0)" class="web_imagebox show_coupon" data-id="2512"
                                                    data-clipboard-text="CART5"> <img class="lazy"
                                                        src="<?php echo e(asset('admin-assets/images/stores')); ?>/<?php echo e($store->feature_image); ?>"
                                                        title="<?php echo e($store->name); ?>" style="">
                                                </a>
                                            </div>
                                            <span class="ribbon2"><?php echo e($row->type); ?></span>
                                            <div class="coupon_head_title">
                                                <h2 class="coupon_content_title show_coupon" data-id="2512"
                                                    data-clipboard-text="CART5"><?php echo e($row->title); ?></h2>
                                                <div class="coupon_discription">
                                                    <p class="coupon_content_about"><?php echo e($row->description); ?></p>
                                                    <!-- <a href="#" class="read_more">Read more <i class="fa fa-chevron-right"></i></a> -->
                                                </div>
                                            </div>
                                        </div>

                                        <div class="coupon_content">
                                            <div class="coupon_badges">
                                                <div class="coupon_badge uses">
                                                    <i class="fa fa-user"></i>
                                                    <p>Uses (<?php echo e($row->total_use); ?>)</p>
                                                </div>
                                            </div>

                                            <?php if($row->code != null): ?>
                                                <a href="<?php echo e($row->url); ?>" target="_blank" id="coupon-button"
                                                    data-title="<?php echo e($row->title); ?>" data-des="<?php echo e($row->description); ?>"
                                                    data-code="<?php echo e($row->code); ?>" data-url="<?php echo e($row->url); ?>"
                                                    data-coupon_id="<?php echo e($row->id); ?>"
                                                    data-img="<?php echo e(asset('admin-assets/images/stores')); ?>/<?php echo e($store->feature_image); ?>"
                                                    class="featured_blogs_coupon_btn show_coupon single_store_btn ">
                                                    <div class="codes">
                                                        <p><i class="fa fa-coupon" aria-hidden="true"></i>Reveal Code</p>
                                                        <p>**<?php echo e($row->code); ?></p>
                                                    </div>
                                                </a>
                                            <?php else: ?>
                                                <a href="<?php echo e($row->url); ?>" target="_blank" id="coupon-button"
                                                    data-title="<?php echo e($row->title); ?>" data-des="<?php echo e($row->description); ?>"
                                                    data-code="<?php echo e($row->code); ?>" data-url="<?php echo e($row->url); ?>"
                                                    data-coupon_id="<?php echo e($row->id); ?>"
                                                    data-img="<?php echo e(asset('admin-assets/images/stores')); ?>/<?php echo e($store->feature_image); ?>"
                                                    class="featured_blogs_coupon_btn single_store_btn get_deal">
                                                    <div class="codes">
                                                        <p><i class="fa fa-arrow-right" aria-hidden="true"></i>Get deal
                                                        </p>
                                                    </div>
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <div class="modal" id="couponModal">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal_main">
                    <div class="modal-header">
                        <center>
                            <h5 class="modal-title" id="exampleModalLabel"></h5>
                            <div class="store_title_modal">
                                <div class="modal_title_img">
                                    <a href="#" class="web_imagebox">
                                        <img class="img-responsive lazy modal-img" src="" style="">
                                    </a>
                                </div>
                                <div class="modal_title_content">
                                    <h2 class="store_modal modal_title"></h2>
                                    <div class="code-desc modal-desc">

                                    </div>
                                </div>
                            </div>
                            <button type="button" class="close close_modal" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                        </center>
                    </div>
                    <div class="modal-body">
                        <div class="modal_body_main">
                            <!--<p> Get Potted website has been opened in a new tab / window. Simply copy and paste the code CART5 and enter it at the checkout.</p>-->
                            <div class="modal_code pccopybtn code_text" id="code_text">

                            </div>
                            <a href="javascript:;" id="btn" class="visit_site" data-clipboard-action="copy"
                                data-clipboard-target="#code_text">Copy Code<i class=" fa fa-arrow-right"></i></a>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom-scripts'); ?>
    <script src="<?php echo e(asset('user-assets/js/clipboard.min.js')); ?>" type="text/javascript"></script>
    <script src="<?php echo e(asset('user-assets/js/custom.js')); ?>" type="text/javascript"></script>
    <script>
        var btn = document.getElementById('btn');
        var clipboard = new ClipboardJS(btn);

        clipboard.on('success', function(e) {
            console.info('Action:', e.action);
            console.info('Text:', e.text);
            console.info('Trigger:', e.trigger);
        });

        clipboard.on('error', function(e) {
            console.info('Action:', e.action);
            console.info('Text:', e.text);
            console.info('Trigger:', e.trigger);
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\realtimebrief\resources\views/user/pages/store-profile.blade.php ENDPATH**/ ?>