
<?php $__env->startSection('custom-styles'); ?>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/izitoast/dist/css/iziToast.min.css">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta-content'); ?>
    <title><?php echo e($blog->title); ?></title>
    <meta name="description" content="<?php echo e($blog->meta_description); ?>">
    <meta name="title" content="<?php echo e($blog->meta_title); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- breadcrumb-area -->
    <div class="breadcrumb-area">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-content">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo e(route('index')); ?>">Home</a></li>
                                <li class="breadcrumb-item" aria-current="page"><a href="javascript:;">Blogs</a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?php echo e($blog->slug); ?></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb-area-end -->
    <article class="post type-post single-post py-4 lg:py-6 xl:py-9">
        <div class="container max-w-xl">
            <div class="post-header">
                <div class="panel vstack gap-4 md:gap-6 xl:gap-8 text-center">
                    <div
                        class="panel vstack items-center max-w-400px sm:max-w-500px xl:max-w-md mx-auto gap-2 md:gap-3">
                        <h1 class="h4 sm:h2 lg:h1 xl:display-6"><?php echo e($blog->title); ?></h1>
                        <?php echo $shareComponent; ?>

                    </div>
                    <figure class="featured-image m-0">
                        <figure
                            class="featured-image m-0 ratio ratio-2x1 rounded uc-transition-toggle overflow-hidden bg-gray-25 dark:bg-gray-800">
                            <img class="media-cover image uc-transition-scale-up uc-transition-opaque"
                                src="<?php echo e(asset('admin-assets/images/blogs')); ?>/<?php echo e($blog->feature_image); ?>"
                                data-src="<?php echo e(asset('admin-assets/images/blogs')); ?>/<?php echo e($blog->feature_image); ?>"
                                alt="<?php echo e($blog->title); ?>"
                                data-uc-img="loading: lazy">
                        </figure>
                    </figure>
                </div>
            </div>
        </div>
        <div class="panel position-relative mt-4 lg:mt-6 xl:mt-9">
            <div class="container">
                <div class="content-wrap row child-col-12 lg:child-cols g-4 lg:g-6">
                    <div class="lg:col-8 uc-first-column">
                        <div class="max-w-lg">
                            <div class="post-content panel fs-6 md:fs-5" data-uc-lightbox="animation: scale">
                                <?php echo $blog->description; ?>

                            </div>
                            
                            
                            
                            <div id="blog-comment" class="panel border-top pt-2 mt-8 xl:mt-9">
                                <h4 class="h5 xl:h4 mb-5 xl:mb-6"><?php echo e($comment_count); ?>

                                    <?php echo e(str('comment')->plural($comment_count)); ?> </h4>

                                <div class="spacer-half"></div>

                                <ol>
                                    <?php $__currentLoopData = $comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li  id="<?php echo e($comment->id); ?>">
                                        <div class="avatar">
                                            <?php if($comment->user->image): ?>
                                                                <img src="<?php echo e(asset('admin-assets/images/users')); ?>/<?php echo e($comment->user->image); ?>"
                                                                    alt="img">
                                                            <?php else: ?>
                                                                <img src="<?php echo e(asset('user-assets/images/avatar.png')); ?>"
                                                                    alt="img">
                                                            <?php endif; ?>
                                        </div>
                                        <div class="comment-info">
                                            <span class="c_name"><?php echo e($comment->user->name); ?></span>
                                            <span class="c_date id-color"> <?php echo e($comment->updated_at->toFormattedDateString()); ?> <i
                                                class="flaticon-history"></i>
                                            <?php echo e($comment->updated_at->diffForHumans()); ?></span>
                                            <span class="c_reply"><a href="#">Reply</a></span>
                                            <div class="clearfix"></div>
                                        </div>

                                        <div class="comment"><?php echo e($comment->comment); ?></div>
                                        <?php if(Auth::id()): ?>
                                        <li><a href="javascript:" id="like_comment_btn"
                                                data-comment_id="<?php echo e($comment->id); ?>"><i
                                                    class="fa fa-heart"></i> <?php
                                                        $likes = \App\Models\CommentLikeByUser::where(
                                                            'comment_id',
                                                            $comment->id,
                                                        )->count();
                                                        $like = \App\Models\CommentLikeByUser::where(
                                                            [
                                                                'comment_id' =>
                                                                    $comment->id,
                                                                'user_id' => \Auth::id(),
                                                            ],
                                                        )->first();
                                                    ?>

                                                <?php if($like): ?>
                                                    Unlike
                                                <?php else: ?>
                                                    Like
                                                <?php endif; ?>
                                                <?php if($likes): ?>
                                                    (<?php echo e($likes); ?>)
                                                <?php endif; ?>
                                            </a>
                                        </li>
                                        <li><a href="javascript:;" class="reply_btn"><i
                                                    class="fa fa-reply"></i> Reply</a></li>
                                        <li class="cancelli" style="display:none"><a
                                                href="javascript:;" class="cancel_btn"> <i
                                                    class="fa fa-times"></i> Cancel</a></li>
                                        <?php if(Auth::id() == $comment->user->id): ?>
                                            <li><a href="javascript:;" id="dlt_comment_btn"
                                                    data-comment_id="<?php echo e($comment->id); ?>"><i
                                                        class="fa fa-trash"></i> Delete</a></li>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <li><a href="<?php echo e(route('login')); ?>" id=""
                                                data-comment_id="<?php echo e($comment->id); ?>"><i
                                                    class="fa fa-heart"></i> <?php
                                                        $likes = \App\Models\CommentLikeByUser::where(
                                                            'comment_id',
                                                            $comment->id,
                                                        )->count();
                                                        $like = \App\Models\CommentLikeByUser::where(
                                                            [
                                                                'comment_id' =>
                                                                    $comment->id,
                                                                'user_id' => \Auth::id(),
                                                            ],
                                                        )->first();
                                                    ?>

                                                <?php if($like): ?>
                                                    Unlike
                                                <?php else: ?>
                                                    Like
                                                <?php endif; ?>
                                                <?php if($likes): ?>
                                                    (<?php echo e($likes); ?>)
                                                <?php endif; ?>
                                            </a>
                                        </li>
                                        <li><a href="<?php echo e(route('login')); ?>" class=""><i
                                                    class="fa fa-reply"></i> Reply</a></li>
                                    <?php endif; ?>
                                        <ol>
                                            
                                                            <li>
                                                                <div class="comments-box">
                                                                    <div class="comments-avatar">
                                                                        <?php
                                                                            $user = $reply->user()->first();
                                                                        ?>
                                                                        <?php if($user->image): ?>
                                                                            <img src="<?php echo e(asset('admin-assets/images/users')); ?>/<?php echo e($user->image); ?>"
                                                                                alt="img">
                                                                        <?php else: ?>
                                                                            <img src="<?php echo e(asset('user-assets/images/avatar.png')); ?>"
                                                                                alt="img">
                                                                        <?php endif; ?>
                                                                    </div>
                                                                    <div class="comments-text">
                                                                        <div class="avatar-name">

                                                                            <h6 class="name"><?php echo e($user->name); ?></h6>
                                                                            <span class="date">
                                                                                <i class="flaticon-calendar"></i>
                                                                                <?php echo e($reply->updated_at->toFormattedDateString()); ?>

                                                                                <i class="flaticon-history"></i>
                                                                                <?php echo e($reply->updated_at->diffForHumans()); ?>

                                                                            </span>
                                                                        </div>
                                                                        <p><?php echo e($reply->reply); ?>

                                                                        <ul class="list-wrap" style="">
                                                                            
                                                                        </ul>

                                                                        </p>

                                                                    </div>
                                                                </div>
                                                            </li>
                                                        
                                            <?php $__currentLoopData = $comment->reply; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reply): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li>
                                                <div class="avatar">
                                                    <?php
                                                    $user = $reply->user()->first();
                                                ?>
                                                <?php if($user->image): ?>
                                                    <img src="<?php echo e(asset('admin-assets/images/users')); ?>/<?php echo e($user->image); ?>"
                                                        alt="img">
                                                <?php else: ?>
                                                    <img src="<?php echo e(asset('user-assets/images/avatar.png')); ?>"
                                                        alt="img">
                                                <?php endif; ?>
                                                </div>
                                                <div class="comment-info">
                                                    <span class="c_name"><?php echo e($user->name); ?></span>
                                                    <span class="c_date id-color"><?php echo e($reply->updated_at->toFormattedDateString()); ?>

                                                        <i class="flaticon-history"></i>
                                                        <?php echo e($reply->updated_at->diffForHumans()); ?></span>
                                                    <span class="c_reply"><a href="#">Reply</a></span>
                                                    <div class="clearfix"></div>
                                                </div>
                                                <div class="comment"><?php echo e($reply->reply); ?></div>
                                                <?php if(Auth::id()): ?>
                                                    <li><a href="javascript:"
                                                            id="like_reply_btn"
                                                            data-reply_id="<?php echo e($reply->id); ?>"><i
                                                                class="fa fa-heart"></i>
                                                            <?php
                                                                $likes = \App\Models\ReplyLikeByUser::where(
                                                                    'reply_id',
                                                                    $reply->id,
                                                                )->count();
                                                                $like = \App\Models\ReplyLikeByUser::where(
                                                                    [
                                                                        'reply_id' =>
                                                                            $reply->id,
                                                                        'user_id' => \Auth::id(),
                                                                    ],
                                                                )->first();
                                                            ?>
                                                            <?php if($like): ?>
                                                                Unlike
                                                            <?php else: ?>
                                                                Like
                                                            <?php endif; ?>
                                                            <?php if($likes): ?>
                                                                (<?php echo e($likes); ?>)
                                                            <?php endif; ?>
                                                        </a></li>
                                                    <?php if(Auth::id() == $user->id): ?>
                                                        <li><a href="javascript:;"
                                                                id="dlt_reply_btn"
                                                                data-reply_id="<?php echo e($reply->id); ?>"><i
                                                                    class="fa fa-trash"></i>
                                                                Delete</a></li>
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <li><a href="<?php echo e(route('login')); ?>"
                                                            id=""
                                                            data-reply_id="<?php echo e($reply->id); ?>"><i
                                                                class="fa fa-heart"></i>
                                                            <?php
                                                                $likes = \App\Models\ReplyLikeByUser::where(
                                                                    'reply_id',
                                                                    $reply->id,
                                                                )->count();
                                                                $like = \App\Models\ReplyLikeByUser::where(
                                                                    [
                                                                        'reply_id' =>
                                                                            $reply->id,
                                                                        'user_id' => \Auth::id(),
                                                                    ],
                                                                )->first();
                                                            ?>
                                                            <?php if($like): ?>
                                                                Unlike
                                                            <?php else: ?>
                                                                Like
                                                            <?php endif; ?>
                                                            <?php if($likes): ?>
                                                                (<?php echo e($likes); ?>)
                                                            <?php endif; ?>
                                                        </a></li>
                                                <?php endif; ?>
                                            </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ol>
                                    </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ol>

                                <div class="spacer-single"></div>

                                <div id="comment-form-wrapper" class="panel pt-2 mt-8 xl:mt-9">
                                    <h4 class="h5 xl:h4 mb-5 xl:mb-6">Leave a Comment</h4>
                                    <div class="comment_form_holder">
                                        <?php if(auth()->guard()->check()): ?>
                                        <form class="vstack gap-2" id="comment_form">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" class="userid" name="user_id" value="<?php echo e(Auth::id()); ?>">
                                            <input type="hidden" class="blogid" name="blog_id" value="<?php echo e($blog->id); ?>">
                                            <input
                                                class="form-control form-control-sm h-40px w-full fs-6 bg-white dark:bg-opacity-0 dark:text-white dark:border-gray-300 dark:border-opacity-30"
                                                type="text" placeholder="First name" required>
                                            <input
                                                class="form-control form-control-sm h-40px w-full fs-6 bg-white dark:bg-opacity-0 dark:text-white dark:border-gray-300 dark:border-opacity-30"
                                                type="text" placeholder="Last name" required>
                                            <input
                                                class="form-control form-control-sm h-40px w-full fs-6 bg-white dark:bg-opacity-0 dark:text-white dark:border-gray-300 dark:border-opacity-30"
                                                type="email" placeholder="Your email" required>
                                            <textarea
                                                class="form-control h-250px w-full fs-6 bg-white dark:bg-opacity-0 dark:text-white dark:border-gray-300 dark:border-opacity-30"
                                                type="text" placeholder="Your comment" required name="comment"> </textarea>
                                            <button class="btn btn-primary btn-sm mt-1" type="button" id="comment_form_btn">Send</button>
                                        </form>
                                        <?php else: ?>
                                        <form class="vstack gap-2" action="<?php echo e(route('login')); ?>" class="comment-form" method="post">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" class="userid" name="user_id" value="<?php echo e(Auth::id()); ?>">
                                            <input type="hidden" class="blogid" name="blog_id" value="<?php echo e($blog->id); ?>">
                                            <input
                                                class="form-control form-control-sm h-40px w-full fs-6 bg-white dark:bg-opacity-0 dark:text-white dark:border-gray-300 dark:border-opacity-30"
                                                type="text" placeholder="Email" name="email" required>
                                            <input
                                                class="form-control form-control-sm h-40px w-full fs-6 bg-white dark:bg-opacity-0 dark:text-white dark:border-gray-300 dark:border-opacity-30"
                                                type="text" placeholder="Password" name="password" required>
                                            
                                            <button class="btn btn-primary btn-sm mt-1" type="submit">Send</button>
                                            <div class="row mt-1">
                                                <div class="col-md-12">
    
                                                    <p style="text-align:center"><?php echo e(__('OR')); ?></p>
    
                                                </div>
                                            </div>
                                            <div class="row mb-1">
                                                <div class="col-md-12">
                                                    <a href="<?php echo e(url('auth/google')); ?>" class="btn btn-default"
                                                        style="width: 100%;font-size:0.7rem;background:#fff;color:#183354; border:1px solid; border-color:#183354">
                                                        <svg aria-hidden="true" class="native svg-icon iconGoogle" width="18"
                                                            height="18" viewBox="0 0 18 18">
                                                            <path fill="#4285F4"
                                                                d="M16.51 8H8.98v3h4.3c-.18 1-.74 1.48-1.6 2.04v2.01h2.6a7.8 7.8 0 0 0 2.38-5.88c0-.57-.05-.66-.15-1.18Z">
                                                            </path>
                                                            <path fill="#34A853"
                                                                d="M8.98 17c2.16 0 3.97-.72 5.3-1.94l-2.6-2a4.8 4.8 0 0 1-7.18-2.54H1.83v2.07A8 8 0 0 0 8.98 17Z">
                                                            </path>
                                                            <path fill="#FBBC05"
                                                                d="M4.5 10.52a4.8 4.8 0 0 1 0-3.04V5.41H1.83a8 8 0 0 0 0 7.18l2.67-2.07Z">
                                                            </path>
                                                            <path fill="#EA4335"
                                                                d="M8.98 4.18c1.17 0 2.23.4 3.06 1.2l2.3-2.3A8 8 0 0 0 1.83 5.4L4.5 7.49a4.77 4.77 0 0 1 4.48-3.3Z">
                                                            </path>
                                                        </svg>
                                                        Log in with Google
                                                    </a>
                                                </div>
                                            </div>
                                            <a href="<?php echo e(route('register')); ?>" class="sign_up_modal_btn">Don't have an
                                                account? Signup</a>
                                        </form>
                                        <?php endif; ?>
                                        <?php if(auth()->guard()->guest()): ?>
            
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="lg:col-4">
                        <div class="sidebar-wrap panel vstack gap-2" data-uc-sticky="end: true;">
                            <div class="right-sidebar">
                                <div class="recent-widget widget">
                                    <h2 class="widget-title">Recent Posts</h2>
                                    <div class="recent-post-widget clearfix">
                                        <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="show-featured clearfix">
                                            <div class="post-img">
                                                <a
                                                    href="#">
                                                    <img width="1200" height="700"
                                                        src="<?php echo e(asset('admin-assets/images/blogs')); ?>/<?php echo e($row->feature_image); ?>"
                                                        class="attachment-full size-full wp-post-image" alt=""
                                                        decoding="async"
                                                        srcset="<?php echo e(asset('admin-assets/images/blogs')); ?>/<?php echo e($row->feature_image); ?>"
                                                        sizes="(max-width: 1200px) 100vw, 1200px"> </a>
                                            </div>
                                            <div class="post-item">
                                                <div class="post-desc">
                                                    <div class="rt-site-mega">
                                                        <span class="author-post">
                                                            <?php echo e($row->updated_at->toFormattedDateString()); ?> </span><span class="date-post">
                                                            By <a
                                                                href="#">Admin</a>
                                                        </span>
                                                    </div>
                                                    <a
                                                        href="<?php echo e(route('blog.details', $row->slug)); ?>">
                                                        <?php echo e($row->title); ?> </a>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                                
                                <section id="media_image-1" class="widget widget_media_image"><img width="600" height="700" src="https://reactheme.com/news5/news-magazine/wp-content/uploads/sites/26/2025/04/add__image.png" class="image wp-image-10098 attachment-full size-full" alt="" decoding="async" srcset="https://reactheme.com/news5/news-magazine/wp-content/uploads/sites/26/2025/04/add__image.png 600w, https://reactheme.com/news5/news-magazine/wp-content/uploads/sites/26/2025/04/add__image-257x300.png 257w" sizes="(max-width: 600px) 100vw, 600px"></section>
                                <div class="recent-widget widget newsletter">
                                    <h4 class="widget-title">Subscribe To Our Newsletter</h4>
                                    <p>No spam, notifications only about new products, updates.</p>
                                    <form action="#" class="newsletter-form">
                                        <input type="email" placeholder="Your Email">
                                        <button class="btn btn-primary btn-sm mt-1" type="submit">Sign Up</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </article>
   
<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom-scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/izitoast/dist/js/iziToast.min.js"></script>
    <script>
       
        $("#comment_form_btn").click(function(e) {
            e.preventDefault();
            let form = $('#comment_form')[0];
            let data = new FormData(form);

            $.ajax({
                url: "<?php echo e(route('comment.store')); ?>",
                type: "POST",
                data: data,
                dataType: "JSON",
                processData: false,
                contentType: false,

                success: function(response) {

                    if (response.errors) {
                        var errorMsg = '';
                        $.each(response.errors, function(field, errors) {
                            $.each(errors, function(index, error) {
                                errorMsg += error + '<br>';
                            });
                        });
                        iziToast.error({
                            message: 'Comment Failed',
                            position: 'topRight'
                        });

                    } else {
                        iziToast.success({
                            message: response.success,
                            position: 'topRight'

                        });

                        $("#comments-section").load(location.href + " #comments-section");

                    }

                },
                error: function(xhr, status, error) {

                    iziToast.error({
                        message: 'An error occurred: ' + error,
                        position: 'topRight'
                    });
                }

            });

        });

        $(document).on('click', '.reply_btn', function() {
            var comment_id = $(this).data('comment_id');
            var comment_id = $(this).data('user_id');
            // var html = ``;
            $(this).css('display', 'none');
            $(this).closest('.comments-text').find('.reply-section').css('display', 'block');
            $(this).closest('.comments-text').find('.cancelli').css('display', 'block');

        });

        $(document).on('click', '.cancel_btn', function() {
            var comment_id = $(this).data('comment_id');
            var comment_id = $(this).data('user_id');
            // var html = ``;
            $(this).closest('.comments-text').find('.cancelli').css('display', 'none');
            $(this).closest('.comments-text').find('.reply-section').css('display', 'none');
            $(this).closest('.comments-text').find('.reply_btn').css('display', 'block');

        });

        $(".reply_form_btn").click(function(e) {
            e.preventDefault();
            let form = $(this).closest('.comments-text').find('.reply_form')[0];
            let data = new FormData(form);

            $.ajax({
                url: "<?php echo e(route('reply.store')); ?>",
                type: "POST",
                data: data,
                dataType: "JSON",
                processData: false,
                contentType: false,

                success: function(response) {

                    if (response.errors) {
                        var errorMsg = '';
                        $.each(response.errors, function(field, errors) {
                            $.each(errors, function(index, error) {
                                errorMsg += error + '<br>';
                            });
                        });
                        iziToast.error({
                            message: 'Comment Failed',
                            position: 'topRight'
                        });

                    } else {
                        iziToast.success({
                            message: response.success,
                            position: 'topRight'

                        });

                        $("#comments-section").load(location.href + " #comments-section");

                    }

                },
                error: function(xhr, status, error) {

                    iziToast.error({
                        message: 'An error occurred: ' + error,
                        position: 'topRight'
                    });
                }

            });

        });

        $(document).on('click', '#like_comment_btn', function(e) {
            e.preventDefault();
            // let form = $(this).closest('.comments-text').find('.reply_form')[0];
            // let data = new FormData(form);
            var comment_id = $(this).data('comment_id');
            console.log(comment_id);
            $.ajax({
                url: "<?php echo e(route('comment.like')); ?>",
                type: "GET",
                data: {
                    comment_id: comment_id
                },
                dataType: "JSON",

                success: function(response) {

                    if (response.errors) {
                        var errorMsg = '';
                        $.each(response.errors, function(field, errors) {
                            $.each(errors, function(index, error) {
                                errorMsg += error + '<br>';
                            });
                        });
                        iziToast.error({
                            message: response.error,
                            position: 'topRight'
                        });

                    } else {
                        iziToast.success({
                            message: response.success,
                            position: 'topRight'

                        });

                        $("#comments-section").load(location.href + " #comments-section");

                    }

                },
                error: function(xhr, status, error) {

                    iziToast.error({
                        message: 'An error occurred: ' + error,
                        position: 'topRight'
                    });
                }

            });

        });

        $(document).on('click', '#like_reply_btn', function(e) {
            e.preventDefault();
            // let form = $(this).closest('.comments-text').find('.reply_form')[0];
            // let data = new FormData(form);
            var reply_id = $(this).data('reply_id');
            console.log(reply_id);
            $.ajax({
                url: "<?php echo e(route('reply.like')); ?>",
                type: "GET",
                data: {
                    reply_id: reply_id
                },
                dataType: "JSON",

                success: function(response) {

                    if (response.errors) {
                        var errorMsg = '';
                        $.each(response.errors, function(field, errors) {
                            $.each(errors, function(index, error) {
                                errorMsg += error + '<br>';
                            });
                        });
                        iziToast.error({
                            message: response.error,
                            position: 'topRight'
                        });

                    } else {
                        iziToast.success({
                            message: response.success,
                            position: 'topRight'

                        });

                        $("#comments-section").load(location.href + " #comments-section");

                    }

                },
                error: function(xhr, status, error) {

                    iziToast.error({
                        message: 'An error occurred: ' + error,
                        position: 'topRight'
                    });
                }

            });

        });

        $(document).on('click', '#dlt_comment_btn', function(e) {
            e.preventDefault();
            // let form = $(this).closest('.comments-text').find('.reply_form')[0];
            // let data = new FormData(form);
            var comment_id = $(this).data('comment_id');
            console.log(comment_id);
            $.ajax({
                url: "<?php echo e(route('comment.delete')); ?>",
                type: "GET",
                data: {
                    comment_id: comment_id
                },
                dataType: "JSON",

                success: function(response) {

                    if (response.errors) {
                        var errorMsg = '';
                        $.each(response.errors, function(field, errors) {
                            $.each(errors, function(index, error) {
                                errorMsg += error + '<br>';
                            });
                        });
                        iziToast.error({
                            message: response.error,
                            position: 'topRight'
                        });

                    } else {
                        iziToast.success({
                            message: response.success,
                            position: 'topRight'

                        });

                        $("#comments-section").load(location.href + " #comments-section");

                    }

                },
                error: function(xhr, status, error) {

                    iziToast.error({
                        message: 'An error occurred: ' + error,
                        position: 'topRight'
                    });
                }

            });

        });

        $(document).on('click', '#dlt_reply_btn', function(e) {
            e.preventDefault();
            // let form = $(this).closest('.comments-text').find('.reply_form')[0];
            // let data = new FormData(form);
            var reply_id = $(this).data('reply_id');

            $.ajax({
                url: "<?php echo e(route('reply.delete')); ?>",
                type: "GET",
                data: {
                    reply_id: reply_id
                },
                dataType: "JSON",

                success: function(response) {

                    if (response.errors) {
                        var errorMsg = '';
                        $.each(response.errors, function(field, errors) {
                            $.each(errors, function(index, error) {
                                errorMsg += error + '<br>';
                            });
                        });
                        iziToast.error({
                            message: response.error,
                            position: 'topRight'
                        });

                    } else {
                        iziToast.success({
                            message: response.success,
                            position: 'topRight'

                        });

                        $("#comments-section").load(location.href + " #comments-section");

                    }

                },
                error: function(xhr, status, error) {

                    iziToast.error({
                        message: 'An error occurred: ' + error,
                        position: 'topRight'
                    });
                }

            });

        });

        $(document).on('click', '#save_btn', function(e) {
            e.preventDefault();

            var blog_id = $(this).data('id');
            console.log(blog_id);
            $.ajax({
                url: "<?php echo e(route('blog.save')); ?>",
                type: "GET",
                data: {
                    blog_id: blog_id
                },
                dataType: "JSON",

                success: function(response) {

                    if (response.errors) {
                        var errorMsg = '';
                        $.each(response.errors, function(field, errors) {
                            $.each(errors, function(index, error) {
                                errorMsg += error + '<br>';
                            });
                        });
                        iziToast.error({
                            message: response.error,
                            position: 'topRight'
                        });

                    } else {
                        iziToast.success({
                            message: response.success,
                            position: 'topRight'

                        });

                        $("#save-section").load(location.href + " #save-section");

                    }

                },
                error: function(xhr, status, error) {

                    iziToast.error({
                        message: 'An error occurred: ' + error,
                        position: 'topRight'
                    });
                }

            });

        });

        
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\realtimebrief\resources\views/user/pages/blog-details.blade.php ENDPATH**/ ?>