
<?php $__env->startSection('custom-styles'); ?>
    <!-- Bootstrap Select Css -->
    <link href="<?php echo e(asset('admin-assets/css/bootstrap-select.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12">
            <div class="card">
                <div class="header">
                    <h2><strong>Add </strong> new Coupon</h2>

                </div>
                <div class="mt-2">
                    <?php echo $__env->make('admin.layouts.partials.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="body">
                    <?php if(count($errors) > 0): ?>
                        <div class="alert alert-danger">
                            <strong>Whoops!</strong> There were some problems with your input.<br><br>
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <form method="POST" action="<?php echo e(route('coupons.update', $coupon->id)); ?>" autocomplete="off"
                        enctype="multipart/form-data">
                        <?php echo method_field('patch'); ?>
                        <?php echo csrf_field(); ?>
                        <label for="name">Name</label>
                        <div class="form-group">
                            <input type="text" id="name" class="form-control" placeholder="Enter Coupon Title"
                                name="title" value="<?php echo e($coupon->title); ?>" required>
                            <?php if($errors->has('title')): ?>
                                <span class="text-danger"><?php echo e($errors->first('title')); ?></span>
                            <?php endif; ?>
                        </div>
                        <label class="form-label">Stores</label>
                        <div class="form-group">
                            <select class="form-control show-tick" name="store_id">
                                <option value="<?php echo e($coupon->store_id); ?>"><?php echo e($coupon->store->name); ?></option>
                                <option value="">--select Store--</option>
                                <?php $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $store): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($key); ?>"><?php echo e($store); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="row">
                            <div class="col-6">
                                <label class="form-label">Type</label>
                                <div class="form-group">
                                    <select class="form-control show-tick" name="type">
                                        <option value="<?php echo e($coupon->type); ?>"><?php echo e($coupon->type); ?></option>
                                        <option value="">--select Type--</option>
                                        <option value="code">Code</option>
                                        <option value="deal">Deal</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-6">
                                <label for="total_use">Total Use</label>
                               <div class="form-group">
                                <input type="text" class="form-control" id="total_use" name="total_use"
                                placeholder="Enter Total Use" value="<?php echo e($coupon->total_use); ?>">
                               </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <label for="url">Url</label>
                                <div class="form-group">
                                    <input type="text" id="url" class="form-control" placeholder="Enter Coupon Url"
                                        name="url" value="<?php echo e($coupon->url); ?>">
                                    <?php if($errors->has('url')): ?>
                                        <span class="text-danger"><?php echo e($errors->first('url')); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Code</label>
                                <div class="form-group">
                                <input type="text" class="form-control" name="code" value="<?php echo e($coupon->code); ?>">

                                </div>
                            </div>

                        </div>
                        <label for="description">Description</label>
                        <div class="form-group">
                            <textarea id="description" class="form-control" name="description" placeholder="Entere Coupon Description"><?php echo e($coupon->description); ?></textarea>
                            <?php if($errors->has('description')): ?>
                                <span class="text-danger"><?php echo e($errors->first('description')); ?></span>
                            <?php endif; ?>
                        </div>
                        <div class="col-6">
                            <label class="form-label">Start Date</label>
                            <div class="form-group">
                                <input type="date" class="form-control datepicker" name="start_date"
                                value="<?php echo e($coupon->start_date); ?>" />
                            </div>
                        </div>
                        <div class="col-6">
                            <label class="form-label">End Date</label>
                            <div class="form-group">
                                <input type="date" class="form-control datepicker" name="end_date"
                                value="<?php echo e($coupon->end_date); ?>" />
                            </div>
                        </div>
                        <div class="col-6">
                            <label class="form-label">Status</label>
                            <div class="form-group">
                                <select name="status" class="form-control">
                                    <option value="<?php echo e($coupon->status); ?>">
                                        <?php if($coupon->status == 0): ?>
                                            Active
                                        <?php else: ?>
                                            De-Active
                                        <?php endif; ?>
                                    </option>
                                    <option value="">--Select Status--</option>
                                    <option value="0">Active</option>
                                    <option value="1">De-Active</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="checkbox">
                                <input id="is_exclusive" type="checkbox" name="is_exclusive" value="yes">
                                <label for="is_exclusive">Is Exclusive?</label>
    
                            </div>
                        </div>

                        <button type="submit" class="btn btn-raised btn-primary  waves-effect">Save</button>
                        <a href="<?php echo e(route('coupons.index')); ?>" class="btn btn-default">Back</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dealqmki/getupdatednews.com/resources/views/admin/pages/coupons/edit.blade.php ENDPATH**/ ?>