
<?php $__env->startSection('custom-styles'); ?>
    <style>
        .table thead th:first-child {
            background: #0179c8 !important;
            color: white
        }

        .table thead th {
            background: #fff !important;
            color: black
        }

        .table thead th {
            border-right: solid 1px #cccccc;
        }

        .table tbody tr:nth-child(even) {
            background: #d4edfe;
        }

        .table tbody tr:nth-child(odd) {
            background: #FFF;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta-content'); ?>
 <?php
    $settings = \App\Models\GeneralSetting::find(1);
    ?>
<title><?php if($settings): ?><?php echo e($settings->site_title); ?><?php endif; ?></title>
<meta name="description" content="<?php if($settings): ?><?php echo e($settings->meta_description); ?><?php endif; ?>">
<meta name="title" content="<?php if($settings): ?><?php echo e($settings->meta_title); ?><?php endif; ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- breadcrumb-area -->
    <div class="breadcrumb-area">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-content">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo e(route('index')); ?>">Home</a></li>
                                <li class="breadcrumb-item" aria-current="page"><a href="javascript:;">Gold Rates</a></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb-area-end -->
    <div id="latest_news" class="latest-news section panel">
        <div class="section-outer panel py-4 lg:py-6">
            <div class="container max-w-xl">
                <div class="section-inner">
                    <div class="content-wrap row child-cols-12 g-4 lg:g-6" data-uc-grid>
                        <div class="md:col-9">
                            <section class="blog-details-area pt-60 pb-60">
                                <div class="container">
                                    <div class="author-inner-wrap">
                                        <div class="row justify-content-center">
                                            <div class="col-70">
                                                <div class="section-title-wrap mb-30">
                                                    <div class="section-title">
                                                        <h2 class="title">Gold Rate Per Gram (USD, AED, PKR, INR)</h2>
                                                    </div>
                                                    <div class="section-title-line"></div>
                                                </div>
                                                <div class="table-responsive">
                                                    <table class="table table-hover table-responsive">
                                                        <thead>
                                                            <tr>
                                                                <th scope="col">Currency</th>
                                                                <th scope="col">TYPE</th>
                                                                <th scope="col">24K</th>
                                                                <th scope="col">22K</th>
                                                                <th scope="col">21K</th>
                                                                <th scope="col">18K</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php $__currentLoopData = $goldrates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <tr>
                                                                    <th scope="row"><?php echo e(\Str::upper($rate->currency_code)); ?></th>
                                                                    <th><?php echo e($rate->unit_type); ?></th>
                                                                    <td><?php echo e(number_format($rate->ounce_gold_rate * $rate->karat24_rate, 2, '. ', ',')); ?>

                                                                    </td>
                                                                    <td><?php echo e(number_format($rate->ounce_gold_rate * $rate->karat22_rate, 2, '. ', ',')); ?>

                                                                    </td>
                                                                    <td><?php echo e(number_format($rate->ounce_gold_rate * $rate->karat21_rate, 2, '. ', ',')); ?>

                                                                    </td>
                                                                    <td><?php echo e(number_format($rate->ounce_gold_rate * $rate->karat18_rate, 2, '. ', ',')); ?>

                                                                    </td>
                                                                </tr>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                                <div class="section-title-wrap mt-30 mb-30">
                                                    <div class="section-title">
                                                        <h2 class="title">Gold Rate Per 1Tola (USD, AED, PKR, INR)</h2>
                                                    </div>
                                                    <div class="section-title-line"></div>
                                                </div>
                                                <div class="table-responsive">
                                                    <table class="table table-hover table-responsive">
                                                        <thead>
                                                            <tr>
                                                                <th scope="col">Currency</th>
                                                                <th scope="col">TYPE</th>
                                                                <th scope="col">24K</th>
                                                                <th scope="col">22K</th>
                                                                <th scope="col">21K</th>
                                                                <th scope="col">18K</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php $__currentLoopData = $goldrates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <tr>
                                                                    <th scope="row"><?php echo e(\Str::upper($rate->currency_code)); ?></th>
                                                                    <th>1 Tola</th>
                                                                    <td><?php echo e(number_format($rate->ounce_gold_rate * $rate->karat24_rate * 11.7, 2, '. ', ',')); ?>

                                                                    </td>
                                                                    <td><?php echo e(number_format($rate->ounce_gold_rate * $rate->karat22_rate * 11.7, 2, '. ', ',')); ?>

                                                                    </td>
                                                                    <td><?php echo e(number_format($rate->ounce_gold_rate * $rate->karat21_rate * 11.7, 2, '. ', ',')); ?>

                                                                    </td>
                                                                    <td><?php echo e(number_format($rate->ounce_gold_rate * $rate->karat18_rate * 11.7, 2, '. ', ',')); ?>

                                                                    </td>
                                                                </tr>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </section>
                        </div>
                        <div class="md:col-3">
                            <div class="sidebar-wrap panel vstack gap-2 pb-2" data-uc-sticky="end: .content-wrap; offset: 150; media: @m;">
                                <div class="widget ad-widget vstack gap-2 text-center p-2 border">
                                    <div class="widgt-content">
                                        <a class="cstack max-w-300px mx-auto text-none" href="https://themeforest.net/user/reacthemes/portfolio" target="_blank" rel="nofollow">
                                            <img class="d-block dark:d-none" src="../assets/images/common/ad-slot-aside.jpg" alt="Ad slot">
                                            <img class="d-none dark:d-block" src="../assets/images/common/ad-slot-aside-2.jpg" alt="Ad slot">
                                        </a>
                                    </div>
                                </div>
                                <!-- TradingView Widget BEGIN -->
                                    <div class="tradingview-widget-container">
                                        <div class="tradingview-widget-container__widget"></div>
                                        <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/" rel="noopener nofollow" target="_blank"><span class="blue-text">Track all markets on TradingView</span></a></div>
                                        <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-timeline.js" async>
                                        {
                                        "displayMode": "regular",
                                        "feedMode": "all_symbols",
                                        "colorTheme": "dark",
                                        "isTransparent": false,
                                        "locale": "en",
                                        "width": 300,
                                        "height": 500
                                    }
                                        </script>
                                    </div>
                                    <!-- TradingView Widget END -->
                                <div class="widget social-widget vstack gap-2 text-center p-2 border">
                                    <div class="widgt-title">
                                        <h4 class="fs-7 ft-tertiary text-uppercase m-0">Follow @News5</h4>
                                    </div>
                                    <div class="widgt-content">
                                        <form class="vstack gap-1">
                                            <input class="form-control form-control-sm fs-6 fw-medium h-40px w-full bg-white dark:bg-gray-800 dark:bg-gray-800 dark:border-white dark:border-opacity-15 dark:border-opacity-15" type="email" placeholder="Your email" required="">
                                            <button class="btn btn-sm btn-primary" type="submit">Sign up</button>
                                        </form>
                                        <ul class="nav-x justify-center gap-1 mt-3">
                                            <li>
                                                <a href="#fb" class="cstack w-32px h-32px border rounded-circle hover:text-black dark:hover:text-white hover:scale-110 transition-all duration-150"><i class="icon icon-1 unicon-logo-facebook"></i></a>
                                            </li>
                                            <li>
                                                <a href="#x" class="cstack w-32px h-32px border rounded-circle hover:text-black dark:hover:text-white hover:scale-110 transition-all duration-150"><i class="icon icon-1 unicon-logo-x-filled"></i></a>
                                            </li>
                                            <li>
                                                <a href="#in" class="cstack w-32px h-32px border rounded-circle hover:text-black dark:hover:text-white hover:scale-110 transition-all duration-150"><i class="icon icon-1 unicon-logo-instagram"></i></a>
                                            </li>
                                            <li>
                                                <a href="#yt" class="cstack w-32px h-32px border rounded-circle hover:text-black dark:hover:text-white hover:scale-110 transition-all duration-150"><i class="icon icon-1 unicon-logo-youtube"></i></a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom-scripts'); ?>
    <script type="text/javascript" src="//cdnjs.cloudflare.com/ajax/libs/jquery/2.0.3/jquery.js"></script>
    <script defer type="text/javascript">
        (function() {
            var t = document.getElementsByTagName('script')[0];
            var s = document.createElement('script');
            s.async = true;
            s.src =
                'https://widget.nfusionsolutions.com/custom/monex/script/chart/1/a0fa8f6f-0b7b-4d1a-bb3f-045d29d8aee5/2572dba0-aff5-45e6-a242-01a24b36cbfa?symbols=';
            t.parentNode.insertBefore(s, t);
        })();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\realtimebrief\resources\views/user/pages/gold.blade.php ENDPATH**/ ?>