
<?php $__env->startSection('custom-styles'); ?>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/izitoast/dist/css/iziToast.min.css">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta-content'); ?>
    <title><?php echo e($blog->title); ?></title>
    <meta name="description" content="<?php echo e($blog->meta_description); ?>">
    <meta name="title" content="<?php echo e($blog->meta_title); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- breadcrumb-area -->
    <div class="breadcrumb-area">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-content">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo e(route('index')); ?>">Home</a></li>
                                <li class="breadcrumb-item" aria-current="page"><a href="javascript:;">Blogs</a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?php echo e($blog->slug); ?></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb-area-end -->

    <!-- blog-details-area -->
    <section class="blog-details-area pt-60 pb-60">
        <div class="container">
            <div class="author-inner-wrap">
                <div class="row justify-content-center">
                    <div class="col-70">
                        <div class="blog-details-wrap">
                            <div class="blog-details-content mb-50">
                                <div class="blog-details-content-top">
                                    <a href="javascript:;" class="post-tag"><?php echo e($blog->category->name); ?></a>
                                    <h2 class="title"><?php echo e($blog->title); ?></h2>
                                    <div class="bd-content-inner">
                                        <div class="blog-post-meta">
                                            <ul class="list-wrap">
                                                <li><i class="flaticon-user"></i>by<a href="javascript:;">Admin</a></li>
                                                <li><i
                                                        class="flaticon-calendar"></i><?php echo e($blog->updated_at->toFormattedDateString()); ?>

                                                </li>
                                                <li><i class="flaticon-history"></i><?php echo e($blog->updated_at->diffForHumans()); ?>

                                                </li>

                                                <div id="save-section">
                                                    <?php
                                                        $blogsave = \App\Models\BlogSavedByUser::where(['user_id' => \Auth::id(), 'blog_id' => $blog->id])->first();
                                                    ?>
                                                    <?php if(!$blogsave): ?>
                                                    <li class="wishlist"><i class="flaticon-wishlist"></i> <a href="jaascript:;"
                                                        id="save_btn" data-id="<?php echo e($blog->id); ?>"> Wishlist</a></li>
                                                        <?php else: ?>
                                                <li class="bookmark"><i class="flaticon-bookmark"></i>
                                                    <a href="jaascript:;" id="save_btn" data-id="<?php echo e($blog->id); ?>">
                                                        Saved</a></li>
                                                        <?php endif; ?>
                                                </div>
                                            </ul>
                                        </div>
                                        <div class="blog-details-social">

                                            <?php echo $shareComponent; ?>

                                        </div>
                                    </div>
                                </div>
                                <div class="blog-details-thumb">
                                    <img src="<?php echo e(asset('admin-assets/images/blogs')); ?>/<?php echo e($blog->feature_image); ?>"
                                        alt="">
                                </div>
                                <?php echo $blog->description; ?>

                            </div>
                            


                            <div id="comments-section">
                                <div class="comments-wrap">
                                    <h3 class="comments-wrap-title"><?php echo e($comment_count); ?>

                                        <?php echo e(str('comment')->plural($comment_count)); ?> </h3>
                                    <div class="latest-comments">
                                        <ul class="list-wrap">
                                            <?php $__currentLoopData = $comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li id="<?php echo e($comment->id); ?>">
                                                    <div class="comments-box">
                                                        <div class="comments-avatar">
                                                            <?php if($comment->user->image): ?>
                                                                <img src="<?php echo e(asset('admin-assets/images/users')); ?>/<?php echo e($comment->user->image); ?>"
                                                                    alt="img">
                                                            <?php else: ?>
                                                                <img src="<?php echo e(asset('user-assets/images/avatar.png')); ?>"
                                                                    alt="img">
                                                            <?php endif; ?>
                                                        </div>
                                                        <div class="comments-text">
                                                            <div class="avatar-name">
                                                                <h6 class="name"><?php echo e($comment->user->name); ?></h6>
                                                                <span class="date"> <i class="flaticon-calendar"></i>
                                                                    <?php echo e($comment->updated_at->toFormattedDateString()); ?> <i
                                                                        class="flaticon-history"></i>
                                                                    <?php echo e($comment->updated_at->diffForHumans()); ?></span>
                                                            </div>
                                                            <p><?php echo e($comment->comment); ?>

                                                            <ul class="list-wrap"
                                                                style="display: flex;
                                                                    align-items: center;
                                                                    gap: 12px;">
                                                                <?php if(Auth::id()): ?>
                                                                    <li><a href="javascript:" id="like_comment_btn"
                                                                            data-comment_id="<?php echo e($comment->id); ?>"><i
                                                                                class="fa fa-heart"></i> <?php
                                                                                    $likes = \App\Models\CommentLikeByUser::where(
                                                                                        'comment_id',
                                                                                        $comment->id,
                                                                                    )->count();
                                                                                    $like = \App\Models\CommentLikeByUser::where(
                                                                                        [
                                                                                            'comment_id' =>
                                                                                                $comment->id,
                                                                                            'user_id' => \Auth::id(),
                                                                                        ],
                                                                                    )->first();
                                                                                ?>

                                                                            <?php if($like): ?>
                                                                                Unlike
                                                                            <?php else: ?>
                                                                                Like
                                                                            <?php endif; ?>
                                                                            <?php if($likes): ?>
                                                                                (<?php echo e($likes); ?>)
                                                                            <?php endif; ?>
                                                                        </a>
                                                                    </li>
                                                                    <li><a href="javascript:;" class="reply_btn"><i
                                                                                class="fa fa-reply"></i> Reply</a></li>
                                                                    <li class="cancelli" style="display:none"><a
                                                                            href="javascript:;" class="cancel_btn"> <i
                                                                                class="fa fa-times"></i> Cancel</a></li>
                                                                    <?php if(Auth::id() == $comment->user->id): ?>
                                                                        <li><a href="javascript:;" id="dlt_comment_btn"
                                                                                data-comment_id="<?php echo e($comment->id); ?>"><i
                                                                                    class="fa fa-trash"></i> Delete</a></li>
                                                                    <?php endif; ?>
                                                                <?php else: ?>
                                                                    <li><a href="<?php echo e(route('login')); ?>" id=""
                                                                            data-comment_id="<?php echo e($comment->id); ?>"><i
                                                                                class="fa fa-heart"></i> <?php
                                                                                    $likes = \App\Models\CommentLikeByUser::where(
                                                                                        'comment_id',
                                                                                        $comment->id,
                                                                                    )->count();
                                                                                    $like = \App\Models\CommentLikeByUser::where(
                                                                                        [
                                                                                            'comment_id' =>
                                                                                                $comment->id,
                                                                                            'user_id' => \Auth::id(),
                                                                                        ],
                                                                                    )->first();
                                                                                ?>

                                                                            <?php if($like): ?>
                                                                                Unlike
                                                                            <?php else: ?>
                                                                                Like
                                                                            <?php endif; ?>
                                                                            <?php if($likes): ?>
                                                                                (<?php echo e($likes); ?>)
                                                                            <?php endif; ?>
                                                                        </a>
                                                                    </li>
                                                                    <li><a href="<?php echo e(route('login')); ?>" class=""><i
                                                                                class="fa fa-reply"></i> Reply</a></li>
                                                                <?php endif; ?>
                                                            </ul>

                                                            </p>
                                                            
                                                            <div class="reply-section" style="display: none">
                                                                <form class="comment-form reply_form" id=""
                                                                    method="post">
                                                                    <?php echo csrf_field(); ?>
                                                                    <input type="hidden" class="userid" name="user_id"
                                                                        value="<?php echo e(Auth::id()); ?>">
                                                                    <input type="hidden" class="commentid"
                                                                        name="comment_id" value="<?php echo e($comment->id); ?>">
                                                                    <div class="form-grp">
                                                                        <textarea name="reply" placeholder="Reply" class="reply"></textarea>
                                                                    </div>
                                                                    <button type="submit"
                                                                        class="reply-btn reply_form_btn"
                                                                        id="">Post
                                                                        Reply</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <ul class="children">
                                                        <?php $__currentLoopData = $comment->reply; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reply): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li>
                                                                <div class="comments-box">
                                                                    <div class="comments-avatar">
                                                                        <?php
                                                                            $user = $reply->user()->first();
                                                                        ?>
                                                                        <?php if($user->image): ?>
                                                                            <img src="<?php echo e(asset('admin-assets/images/users')); ?>/<?php echo e($user->image); ?>"
                                                                                alt="img">
                                                                        <?php else: ?>
                                                                            <img src="<?php echo e(asset('user-assets/images/avatar.png')); ?>"
                                                                                alt="img">
                                                                        <?php endif; ?>
                                                                    </div>
                                                                    <div class="comments-text">
                                                                        <div class="avatar-name">

                                                                            <h6 class="name"><?php echo e($user->name); ?></h6>
                                                                            <span class="date">
                                                                                <i class="flaticon-calendar"></i>
                                                                                <?php echo e($reply->updated_at->toFormattedDateString()); ?>

                                                                                <i class="flaticon-history"></i>
                                                                                <?php echo e($reply->updated_at->diffForHumans()); ?>

                                                                            </span>
                                                                        </div>
                                                                        <p><?php echo e($reply->reply); ?>

                                                                        <ul class="list-wrap" style="">
                                                                            <?php if(Auth::id()): ?>
                                                                                <li><a href="javascript:"
                                                                                        id="like_reply_btn"
                                                                                        data-reply_id="<?php echo e($reply->id); ?>"><i
                                                                                            class="fa fa-heart"></i>
                                                                                        <?php
                                                                                            $likes = \App\Models\ReplyLikeByUser::where(
                                                                                                'reply_id',
                                                                                                $reply->id,
                                                                                            )->count();
                                                                                            $like = \App\Models\ReplyLikeByUser::where(
                                                                                                [
                                                                                                    'reply_id' =>
                                                                                                        $reply->id,
                                                                                                    'user_id' => \Auth::id(),
                                                                                                ],
                                                                                            )->first();
                                                                                        ?>
                                                                                        <?php if($like): ?>
                                                                                            Unlike
                                                                                        <?php else: ?>
                                                                                            Like
                                                                                        <?php endif; ?>
                                                                                        <?php if($likes): ?>
                                                                                            (<?php echo e($likes); ?>)
                                                                                        <?php endif; ?>
                                                                                    </a></li>
                                                                                <?php if(Auth::id() == $user->id): ?>
                                                                                    <li><a href="javascript:;"
                                                                                            id="dlt_reply_btn"
                                                                                            data-reply_id="<?php echo e($reply->id); ?>"><i
                                                                                                class="fa fa-trash"></i>
                                                                                            Delete</a></li>
                                                                                <?php endif; ?>
                                                                            <?php else: ?>
                                                                                <li><a href="<?php echo e(route('login')); ?>"
                                                                                        id=""
                                                                                        data-reply_id="<?php echo e($reply->id); ?>"><i
                                                                                            class="fa fa-heart"></i>
                                                                                        <?php
                                                                                            $likes = \App\Models\ReplyLikeByUser::where(
                                                                                                'reply_id',
                                                                                                $reply->id,
                                                                                            )->count();
                                                                                            $like = \App\Models\ReplyLikeByUser::where(
                                                                                                [
                                                                                                    'reply_id' =>
                                                                                                        $reply->id,
                                                                                                    'user_id' => \Auth::id(),
                                                                                                ],
                                                                                            )->first();
                                                                                        ?>
                                                                                        <?php if($like): ?>
                                                                                            Unlike
                                                                                        <?php else: ?>
                                                                                            Like
                                                                                        <?php endif; ?>
                                                                                        <?php if($likes): ?>
                                                                                            (<?php echo e($likes); ?>)
                                                                                        <?php endif; ?>
                                                                                    </a></li>
                                                                            <?php endif; ?>
                                                                        </ul>

                                                                        </p>

                                                                    </div>
                                                                </div>
                                                            </li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                    </ul>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <?php if(auth()->guard()->check()): ?>
                                <div class="comment-respond">
                                    <h3 class="comment-reply-title">Post a comment</h3>
                                    <form class="comment-form" id="comment_form" method="post">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" class="userid" name="user_id" value="<?php echo e(Auth::id()); ?>">
                                        <input type="hidden" class="blogid" name="blog_id" value="<?php echo e($blog->id); ?>">
                                        <p class="comment-notes">Your email address will not be published. Required fields are
                                            marked *</p>
                                        <div class="form-grp">
                                            <textarea name="comment" placeholder="Comment" class="comment"></textarea>
                                        </div>

                                        <button type="submit" class="btn btn-two" id="comment_form_btn">Post
                                            Comment</button>
                                    </form>
                                </div>
                            <?php else: ?>
                                <div class="comment-respond">
                                    <h3 class="comment-reply-title">Post a comment</h3>
                                    <form action="<?php echo e(route('login')); ?>" class="comment-form" method="post">
                                        <?php echo csrf_field(); ?>
                                        <p class="comment-notes">Your email address required to publish comment.</p>

                                        <div class="row">

                                            <div class="col-md-6">
                                                <div class="form-grp">
                                                    <input type="email" placeholder="Email" name="email">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-grp">
                                                    <input type="password" placeholder="Password" name="password">
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <button type="submit" class="btn btn-two" style="width:100%">Login</button>
                                        <div class="row mt-1">
                                            <div class="col-md-12">

                                                <p style="text-align:center"><?php echo e(__('OR')); ?></p>

                                            </div>
                                        </div>
                                        <div class="row mb-1">
                                            <div class="col-md-12">
                                                <a href="<?php echo e(url('auth/google')); ?>" class="btn btn-default"
                                                    style="width: 100%;font-size:0.7rem;background:#fff;color:#183354; border:1px solid; border-color:#183354">
                                                    <svg aria-hidden="true" class="native svg-icon iconGoogle" width="18"
                                                        height="18" viewBox="0 0 18 18">
                                                        <path fill="#4285F4"
                                                            d="M16.51 8H8.98v3h4.3c-.18 1-.74 1.48-1.6 2.04v2.01h2.6a7.8 7.8 0 0 0 2.38-5.88c0-.57-.05-.66-.15-1.18Z">
                                                        </path>
                                                        <path fill="#34A853"
                                                            d="M8.98 17c2.16 0 3.97-.72 5.3-1.94l-2.6-2a4.8 4.8 0 0 1-7.18-2.54H1.83v2.07A8 8 0 0 0 8.98 17Z">
                                                        </path>
                                                        <path fill="#FBBC05"
                                                            d="M4.5 10.52a4.8 4.8 0 0 1 0-3.04V5.41H1.83a8 8 0 0 0 0 7.18l2.67-2.07Z">
                                                        </path>
                                                        <path fill="#EA4335"
                                                            d="M8.98 4.18c1.17 0 2.23.4 3.06 1.2l2.3-2.3A8 8 0 0 0 1.83 5.4L4.5 7.49a4.77 4.77 0 0 1 4.48-3.3Z">
                                                        </path>
                                                    </svg>
                                                    Log in with Google
                                                </a>
                                            </div>
                                        </div>
                                        <a href="<?php echo e(route('register')); ?>" class="sign_up_modal_btn">Don't have an
                                            account? Signup</a>
                                    </form>
                                </div>
                            <?php endif; ?>
                            <?php if(auth()->guard()->guest()): ?>

                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-30">
                        <div class="sidebar-wrap">
                            <div class="sidebar-widget">
                                <div class="sidebar-search">
                                    <form action="#">
                                        <input type="text" placeholder="Search . . .">
                                        <button type="submit"><i class="flaticon-search"></i></button>
                                    </form>
                                </div>
                            </div>
                            <div class="sidebar-widget sidebar-widget-two">
                                <div class="widget-title mb-30">
                                    <h6 class="title">Hot Categories</h6>
                                    <div class="section-title-line"></div>
                                </div>
                                <div class="sidebar-categories">
                                    <ul class="list-wrap">
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li>
                                                <a href="<?php echo e(route('blogs.category', $row->slug)); ?>"
                                                    data-background="<?php echo e(asset('admin-assets/images/categories')); ?>/<?php echo e($row->feature_image); ?>">
                                                    <span class="post-tag post-tag-three"><?php echo e($row->name); ?></span>
                                                    <span class="right-arrow">
                                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"
                                                            fill="none">
                                                            <path
                                                                d="M1.72308 16L0 14.2769L11.8154 2.46154H1.23077V0H16V14.7692H13.5385V4.18462L1.72308 16Z"
                                                                fill="currentcolor"></path>
                                                            <path
                                                                d="M1.72308 16L0 14.2769L11.8154 2.46154H1.23077V0H16V14.7692H13.5385V4.18462L1.72308 16Z"
                                                                fill="currentcolor"></path>
                                                        </svg>
                                                    </span>
                                                </a>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            </div>

                            <div class="sidebar-widget sidebar-widget-two">
                                <div class="widget-title mb-30">
                                    <h6 class="title">Recent News</h6>
                                    <div class="section-title-line"></div>
                                </div>
                                <div class="hot-post-wrap">
                                    <?php
                                        $blog = $blogs->shift();
                                    ?>
                                    <?php if($blog): ?>
                                        <div class="hot-post-item">
                                            <div class="hot-post-thumb">
                                                <a href="<?php echo e(route('blog.details', $blog->slug)); ?>"><img
                                                        src="<?php echo e(asset('admin-assets/images/blogs')); ?>/<?php echo e($blog->feature_image); ?>"
                                                        alt=""></a>
                                            </div>
                                            <div class="hot-post-content">
                                                <a href="javascript:;" class="post-tag"><?php echo e($blog->category->name); ?></a>
                                                <h4 class="post-title"><a
                                                        href="<?php echo e(route('blog.details', $blog->slug)); ?>"><?php echo e($blog->title); ?></a>
                                                </h4>
                                                <div class="blog-post-meta">
                                                    <ul class="list-wrap">
                                                        <li><i
                                                                class="flaticon-calendar"></i><?php echo e($blog->updated_at->toFormattedDateString()); ?>

                                                        </li>
                                                        <li><i
                                                                class="flaticon-history"></i><?php echo e($blog->updated_at->diffForHumans()); ?>

                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="hot-post-item">
                                            <div class="hot-post-content">
                                                <a href="javascript:;" class="post-tag"><?php echo e($row->category->name); ?></a>
                                                <h4 class="post-title"><a
                                                        href="<?php echo e(route('blog.details', $row->slug)); ?>"><?php echo e($row->title); ?></a>
                                                </h4>
                                                <div class="blog-post-meta">
                                                    <ul class="list-wrap">
                                                        <li><i
                                                                class="flaticon-calendar"></i><?php echo e($row->updated_at->toFormattedDateString()); ?>

                                                        </li>
                                                        <li><i
                                                                class="flaticon-history"></i><?php echo e($row->updated_at->diffForHumans()); ?>

                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <div class="sidebar-widget sidebar-widget-two">
                                <div class="sidebar-newsletter">
                                    <div class="icon"><i class="flaticon-envelope"></i></div>
                                    <h4 class="title">Daily Newsletter</h4>
                                    <p>Get all the top stories from Blogs to keep track.</p>
                                    <div class="sidebar-newsletter-form-two" id="subscribeform">
                                        <form method="post" id="subscribe_form">
                                            <?php echo csrf_field(); ?>
                                            <div class="form-grp">
                                                <input type="text" placeholder="Enter your e-mail" name="email">
                                                <button type="submit" class="btn" id="subscribe_form_btn">Subscribe
                                                    Now</button>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" class="form-check-input" id="checkbox">
                                                <label for="checkbox">I agree to the terms & conditions</label>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- blog-details-area-end -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom-scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/izitoast/dist/js/iziToast.min.js"></script>
    <script>
       
        $("#comment_form_btn").click(function(e) {
            e.preventDefault();
            let form = $('#comment_form')[0];
            let data = new FormData(form);

            $.ajax({
                url: "<?php echo e(route('comment.store')); ?>",
                type: "POST",
                data: data,
                dataType: "JSON",
                processData: false,
                contentType: false,

                success: function(response) {

                    if (response.errors) {
                        var errorMsg = '';
                        $.each(response.errors, function(field, errors) {
                            $.each(errors, function(index, error) {
                                errorMsg += error + '<br>';
                            });
                        });
                        iziToast.error({
                            message: 'Comment Failed',
                            position: 'topRight'
                        });

                    } else {
                        iziToast.success({
                            message: response.success,
                            position: 'topRight'

                        });

                        $("#comments-section").load(location.href + " #comments-section");

                    }

                },
                error: function(xhr, status, error) {

                    iziToast.error({
                        message: 'An error occurred: ' + error,
                        position: 'topRight'
                    });
                }

            });

        });

        $(document).on('click', '.reply_btn', function() {
            var comment_id = $(this).data('comment_id');
            var comment_id = $(this).data('user_id');
            // var html = ``;
            $(this).css('display', 'none');
            $(this).closest('.comments-text').find('.reply-section').css('display', 'block');
            $(this).closest('.comments-text').find('.cancelli').css('display', 'block');

        });

        $(document).on('click', '.cancel_btn', function() {
            var comment_id = $(this).data('comment_id');
            var comment_id = $(this).data('user_id');
            // var html = ``;
            $(this).closest('.comments-text').find('.cancelli').css('display', 'none');
            $(this).closest('.comments-text').find('.reply-section').css('display', 'none');
            $(this).closest('.comments-text').find('.reply_btn').css('display', 'block');

        });

        $(".reply_form_btn").click(function(e) {
            e.preventDefault();
            let form = $(this).closest('.comments-text').find('.reply_form')[0];
            let data = new FormData(form);

            $.ajax({
                url: "<?php echo e(route('reply.store')); ?>",
                type: "POST",
                data: data,
                dataType: "JSON",
                processData: false,
                contentType: false,

                success: function(response) {

                    if (response.errors) {
                        var errorMsg = '';
                        $.each(response.errors, function(field, errors) {
                            $.each(errors, function(index, error) {
                                errorMsg += error + '<br>';
                            });
                        });
                        iziToast.error({
                            message: 'Comment Failed',
                            position: 'topRight'
                        });

                    } else {
                        iziToast.success({
                            message: response.success,
                            position: 'topRight'

                        });

                        $("#comments-section").load(location.href + " #comments-section");

                    }

                },
                error: function(xhr, status, error) {

                    iziToast.error({
                        message: 'An error occurred: ' + error,
                        position: 'topRight'
                    });
                }

            });

        });

        $(document).on('click', '#like_comment_btn', function(e) {
            e.preventDefault();
            // let form = $(this).closest('.comments-text').find('.reply_form')[0];
            // let data = new FormData(form);
            var comment_id = $(this).data('comment_id');
            console.log(comment_id);
            $.ajax({
                url: "<?php echo e(route('comment.like')); ?>",
                type: "GET",
                data: {
                    comment_id: comment_id
                },
                dataType: "JSON",

                success: function(response) {

                    if (response.errors) {
                        var errorMsg = '';
                        $.each(response.errors, function(field, errors) {
                            $.each(errors, function(index, error) {
                                errorMsg += error + '<br>';
                            });
                        });
                        iziToast.error({
                            message: response.error,
                            position: 'topRight'
                        });

                    } else {
                        iziToast.success({
                            message: response.success,
                            position: 'topRight'

                        });

                        $("#comments-section").load(location.href + " #comments-section");

                    }

                },
                error: function(xhr, status, error) {

                    iziToast.error({
                        message: 'An error occurred: ' + error,
                        position: 'topRight'
                    });
                }

            });

        });

        $(document).on('click', '#like_reply_btn', function(e) {
            e.preventDefault();
            // let form = $(this).closest('.comments-text').find('.reply_form')[0];
            // let data = new FormData(form);
            var reply_id = $(this).data('reply_id');
            console.log(reply_id);
            $.ajax({
                url: "<?php echo e(route('reply.like')); ?>",
                type: "GET",
                data: {
                    reply_id: reply_id
                },
                dataType: "JSON",

                success: function(response) {

                    if (response.errors) {
                        var errorMsg = '';
                        $.each(response.errors, function(field, errors) {
                            $.each(errors, function(index, error) {
                                errorMsg += error + '<br>';
                            });
                        });
                        iziToast.error({
                            message: response.error,
                            position: 'topRight'
                        });

                    } else {
                        iziToast.success({
                            message: response.success,
                            position: 'topRight'

                        });

                        $("#comments-section").load(location.href + " #comments-section");

                    }

                },
                error: function(xhr, status, error) {

                    iziToast.error({
                        message: 'An error occurred: ' + error,
                        position: 'topRight'
                    });
                }

            });

        });

        $(document).on('click', '#dlt_comment_btn', function(e) {
            e.preventDefault();
            // let form = $(this).closest('.comments-text').find('.reply_form')[0];
            // let data = new FormData(form);
            var comment_id = $(this).data('comment_id');
            console.log(comment_id);
            $.ajax({
                url: "<?php echo e(route('comment.delete')); ?>",
                type: "GET",
                data: {
                    comment_id: comment_id
                },
                dataType: "JSON",

                success: function(response) {

                    if (response.errors) {
                        var errorMsg = '';
                        $.each(response.errors, function(field, errors) {
                            $.each(errors, function(index, error) {
                                errorMsg += error + '<br>';
                            });
                        });
                        iziToast.error({
                            message: response.error,
                            position: 'topRight'
                        });

                    } else {
                        iziToast.success({
                            message: response.success,
                            position: 'topRight'

                        });

                        $("#comments-section").load(location.href + " #comments-section");

                    }

                },
                error: function(xhr, status, error) {

                    iziToast.error({
                        message: 'An error occurred: ' + error,
                        position: 'topRight'
                    });
                }

            });

        });

        $(document).on('click', '#dlt_reply_btn', function(e) {
            e.preventDefault();
            // let form = $(this).closest('.comments-text').find('.reply_form')[0];
            // let data = new FormData(form);
            var reply_id = $(this).data('reply_id');

            $.ajax({
                url: "<?php echo e(route('reply.delete')); ?>",
                type: "GET",
                data: {
                    reply_id: reply_id
                },
                dataType: "JSON",

                success: function(response) {

                    if (response.errors) {
                        var errorMsg = '';
                        $.each(response.errors, function(field, errors) {
                            $.each(errors, function(index, error) {
                                errorMsg += error + '<br>';
                            });
                        });
                        iziToast.error({
                            message: response.error,
                            position: 'topRight'
                        });

                    } else {
                        iziToast.success({
                            message: response.success,
                            position: 'topRight'

                        });

                        $("#comments-section").load(location.href + " #comments-section");

                    }

                },
                error: function(xhr, status, error) {

                    iziToast.error({
                        message: 'An error occurred: ' + error,
                        position: 'topRight'
                    });
                }

            });

        });

        $(document).on('click', '#save_btn', function(e) {
            e.preventDefault();

            var blog_id = $(this).data('id');
            console.log(blog_id);
            $.ajax({
                url: "<?php echo e(route('blog.save')); ?>",
                type: "GET",
                data: {
                    blog_id: blog_id
                },
                dataType: "JSON",

                success: function(response) {

                    if (response.errors) {
                        var errorMsg = '';
                        $.each(response.errors, function(field, errors) {
                            $.each(errors, function(index, error) {
                                errorMsg += error + '<br>';
                            });
                        });
                        iziToast.error({
                            message: response.error,
                            position: 'topRight'
                        });

                    } else {
                        iziToast.success({
                            message: response.success,
                            position: 'topRight'

                        });

                        $("#save-section").load(location.href + " #save-section");

                    }

                },
                error: function(xhr, status, error) {

                    iziToast.error({
                        message: 'An error occurred: ' + error,
                        position: 'topRight'
                    });
                }

            });

        });

        
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\realtimebrief\resources\views/user/pages/blog-details.blade.php ENDPATH**/ ?>