@extends('user.layouts.app')
@section('meta-content')
 @php
    $settings = \App\Models\GeneralSetting::find(1);
    @endphp
<title>@if($settings){{$settings->site_title}}@endif</title>
<meta name="description" content="@if($settings){{$settings->meta_description}}@endif">
<meta name="title" content="@if($settings){{$settings->meta_title}}@endif">
@endsection
@section('custom-styles')
<style>
    .str_list_item {
    display: grid
;
    grid-template-columns: repeat(auto-fill, minmax(130px, 1fr));
    grid-gap: 15px;
}

.store_slide {
    border-radius: 10px;
    padding: 10px;
    width: 100%;
    background-color: #fff;
    box-shadow: 0 0 10px #0001;
}
.store_slide_img {
    height: 50px;
    width: 70px;
    margin: 0 auto;
    background-color: #fff;
    padding: 0 10px;
}
.store_slide_img .web_imagebox {
    height: 100%;
    width: 100%;
}

.web_imagebox {
    display: block;
    min-height: 20px;
    width: 100%;
    overflow: hidden;
    position: relative;
}
.store_slide_img .web_imagebox img {
    max-height: 100%;
    max-width: 100%;
}
.store_slide_name {
    font-weight: 600;
    padding-top: 10px;
    color: #000;
    line-height: 1;
    text-align: center;
    text-transform: capitalize;
    font-size: 15px;
    overflow: hidden;
    white-space: nowrap;
    text-overflow: ellipsis;
}
</style>
@endsection
@section('content')
    <!-- breadcrumb-area -->
    <div class="breadcrumb-area">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-content">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{ route('index') }}">Home</a></li>
                                <li class="breadcrumb-item" aria-current="page"><a href="javascript:;">Stores</a></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb-area-end -->
    <section class="categories-area">
        <div class="container">
            
            <div class="str_list_item ">
                @foreach($stores as $row)
                
                    <a href="{{ route('store.profile', $row->slug) }}" class="store_slide">
                        <div class="store_slide_img">
                           <div class="web_imagebox">
                              <img class="lazy" src="{{ asset('admin-assets/images/stores') }}/{{ $row->feature_image }}" style="">
                           </div>
                        </div>
                        <p class="store_slide_name">{{ $row->name }}</p>
                    </a>
                @endforeach
            </div>
            <div class="clearfix" style="margin-top:30px">
                @php
                $query = \App\Models\QuerySetting::find(1);
            @endphp
            @if ($query->storepage_stores == 'paginate()')
                {{ $stores->links('pagination::bootstrap-4') }}
            @endif
           
        </div>
        
    </section>
@endsection
