@extends('user.layouts.app')
@section('meta-content')
 @php
    $settings = \App\Models\GeneralSetting::find(1);
    @endphp
<title>@if($settings){{$settings->site_title}}@endif</title>
<meta name="description" content="@if($settings){{$settings->meta_description}}@endif">
<meta name="title" content="@if($settings){{$settings->meta_title}}@endif">
@endsection
@section('custom-styles')
    <style>
        .sidebar-wrap.no-sticky {
    position: inherit;
}

.sidebar-wrap {
    margin-left: 40px;
    position: sticky;
    top: 100px;
}
.sidebar-tab .nav-tabs {
    border: none;
    border-radius: 10px;
    overflow: hidden;
    display: inline-flex
;
    margin-bottom: 30px;
}
.sidebar-tab .nav-tabs .nav-link.active {
    background: var(--tg-primary-color);
    color: var(--tg-white);
}
.sidebar-tab .nav-tabs .nav-link {
    border: none;
    /* padding: 18px 35px; */
    color: var(--tg-secondary-color);
    font-weight: 800;
    font-size: 18px;
    background: var(--tg-gray-three);
    line-height: 1;
    font-family: var(--tg-heading-font-color);
    border-radius: 0;
}
.sidebar-widget-two:last-child {
    margin-bottom: 0;
}

.sidebar-widget:last-child {
    margin-bottom: 0;
}
.sidebar-widget-two {
    margin-bottom: 50px;
}
.sidebar-widget {
    margin-bottom: 25px;
}
.author-inner-wrap .row .col-30 {
    width: 30.3%;
    flex: 0 0 auto;
}
    </style>
@endsection
@section('content')
    <!-- breadcrumb-area -->
    <div class="breadcrumb-area">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-content">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('index')}}">Home</a></li>
                                <li class="breadcrumb-item" aria-current="page"><a href="javascript:;">Prayer Times</a></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb-area-end -->
    <!-- blog-details-area -->
    <div id="latest_news" class="latest-news section panel">
        <div class="section-outer panel py-4 lg:py-6">
            <div class="container max-w-xl">
                <div class="section-inner">
                    <div class="content-wrap row child-cols-12 g-4 lg:g-6" data-uc-grid>
                        <div class="md:col-9">
                            <section class="blog-details-area pt-60 pb-60">
                                <div class="container">
                                    <div class="author-inner-wrap">
                                        <div class="row justify-content-center">
                                            <div class="col-70">
                                                <div class="section-title-wrap mb-30">
                                                    <div class="section-title">
                                                        <h2 class="title">Prayer Times</h2>
                                                    </div>
                                                    <div class="section-title-line"></div>
                                                </div>
                                                <div class="sidebar-wrap no-sticky">
                                                    <div class="sidebar-tab">
                                                        <ul class="nav nav-tabs" id="myTab" role="tablist">

                                                            <li class="nav-item" role="presentation">
                                                                <button class="nav-link active" id="latest-tab" data-bs-toggle="tab"
                                                                    data-bs-target="#uae-tab-pane" type="button" role="tab"
                                                                    aria-controls="uae-tab-pane" aria-selected="false">UAE</button>
                                                            </li>
                                                            <li class="nav-item" role="presentation">
                                                                <button class="nav-link " id="latest-tab" data-bs-toggle="tab"
                                                                    data-bs-target="#khi-tab-pane" type="button" role="tab"
                                                                    aria-controls="khi-tab-pane" aria-selected="false">Karachi</button>
                                                            </li>
                                                            <li class="nav-item" role="presentation">
                                                                <button class="nav-link " id="featured-tab" data-bs-toggle="tab"
                                                                    data-bs-target="#gcc-tab-pane" type="button" role="tab"
                                                                    aria-controls="gcc-tab-pane" aria-selected="true">GCC Countries</button>
                                                            </li>
                                                            <li class="nav-item" role="presentation">
                                                                <button class="nav-link " id="featured-tab" data-bs-toggle="tab"
                                                                    data-bs-target="#europe-tab-pane" type="button" role="tab"
                                                                    aria-controls="europe-tab-pane" aria-selected="true">Europe</button>
                                                            </li>
                                                            <li class="nav-item" role="presentation">
                                                                <button class="nav-link " id="featured-tab" data-bs-toggle="tab"
                                                                    data-bs-target="#usa-tab-pane" type="button" role="tab"
                                                                    aria-controls="usa-tab-pane" aria-selected="true">America</button>
                                                            </li>
                                                            <li class="nav-item" role="presentation">
                                                                <button class="nav-link " id="featured-tab" data-bs-toggle="tab"
                                                                    data-bs-target="#asia-tab-pane" type="button" role="tab"
                                                                    aria-controls="asia-tab-pane" aria-selected="true">Asia</button>
                                                            </li>
                                                        </ul>
                                                        <div class="tab-content" id="myTabContent">
                                                            <div class="tab-pane fade" id="khi-tab-pane" role="tabpanel"
                                                                aria-labelledby="latest-tab" tabindex="0">
                                                                <div class="sidebar-widget sidebar-widget-two">
                                                                    <div class="row">
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Karachi</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/1174872/hanfi/3/0/18.0/18.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Islamabad</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/1176615/hanfi/3/0/18.0/18.0">
                                                                            </iframe>
                                                                        </div>
                                                                    </div>

                                                                </div>
                                                            </div>
                                                            <div class="tab-pane fade active show" id="uae-tab-pane" role="tabpanel"
                                                                aria-labelledby="latest-tab" tabindex="0">
                                                                <div class="sidebar-widget sidebar-widget-two">
                                                                    <div class="row">
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Dubai</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd; width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/292223/shafi/4/0/18.5/19.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Abu Dhabi</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/47784890/shafi/4/0/18.5/19.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Sharjah</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/47789024/shafi/4/0/18.5/19.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Ajman</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/292932/shafi/4/0/18.5/19.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Ras Al Khaimah</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/47784985/shafi/4/0/18.5/19.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Um Al Quwain</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/47789409/shafi/4/0/18.5/19.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Fujairah</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/47786526/shafi/4/0/18.5/19.0">
                                                                            </iframe>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="tab-pane fade" id="gcc-tab-pane" role="tabpanel"
                                                                aria-labelledby="gcc-tab" tabindex="0">
                                                                <div class="sidebar-widget sidebar-widget-two">
                                                                    <div class="row">
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Manama</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd; width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/290340/shafi/4/0/18.5/19.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Qatar</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd; width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/290030/shafi/4/0/18.5/19.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Kuwait</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd; width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/44242700/shafi/4/0/18.5/19.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Oman</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd; width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/45440445/shafi/4/0/18.5/19.0">
                                                                            </iframe>

                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Suadia Arabia</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd; width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/46546062/shafi/4/0/18.5/19.0">
                                                                            </iframe>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="tab-pane fade" id="europe-tab-pane" role="tabpanel"
                                                                aria-labelledby="latest-tab" tabindex="0">
                                                                <div class="sidebar-widget sidebar-widget-two">
                                                                    <div class="row">
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">London</h2>
                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/2643743/shafi/1/0/18.0/17.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Paris</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/2988507/shafi/8/0/12.0/12.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Berlin</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/2950159/shafi/1/0/18.0/17.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Amsterdam</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/2759794/shafi/1/0/18.0/17.0">
                                                                            </iframe>
                                                                        </div>

                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="tab-pane fade" id="usa-tab-pane" role="tabpanel"
                                                                aria-labelledby="latest-tab" tabindex="0">
                                                                <div class="sidebar-widget sidebar-widget-two">
                                                                    <div class="row">
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Washington</h2>
                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/4740148/shafi/5/0/15.0/15.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">New York</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/5128581/shafi/5/0/15.0/15.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Los Angeles</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/5368361/shafi/5/0/15.0/15.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Chicago</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/4887398/shafi/5/0/15.0/15.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Toronto</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/6167865/shafi/5/0/15.0/15.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Ottawa</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/6094817/shafi/5/0/15.0/15.0">
                                                                            </iframe>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="tab-pane fade" id="asia-tab-pane" role="tabpanel"
                                                                aria-labelledby="latest-tab" tabindex="0">
                                                                <div class="sidebar-widget sidebar-widget-two">
                                                                    <div class="row">
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Tokyo</h2>
                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/1850147/shafi/1/0/18.0/17.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Beijing</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/1816670/shafi/1/0/18.0/17.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Singapore</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/1880251/shafi/9/0/20.0/18.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Bangkok</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/1609350/shafi/1/0/18.0/17.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">New Delhi</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/1261481/shafi/3/0/18.0/18.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Bengaluru</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/1277333/shafi/3/0/18.0/18.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Mumbai</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/1275339/shafi/3/0/18.0/18.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Chennai</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/1264527/shafi/3/0/18.0/18.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Dhaka</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/1185241/shafi/3/0/18.0/18.0">
                                                                            </iframe>
                                                                        </div>
                                                                        <div class="col-30">
                                                                            <h2 class="text-center">Colombo</h2>

                                                                            <iframe id="iframe" title="prayerWidget" class="widget-m-top"
                                                                                style=" height: 358px; border: 1px solid #ddd;width:100%"
                                                                                scrolling="no"
                                                                                src="https://www.islamicfinder.org/prayer-widget/1248991/shafi/1/0/18.0/17.0">
                                                                            </iframe>
                                                                        </div>

                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-lg-12">
                                                        <div class="section-title-wrap mb-30 mt-30">
                                                            <div class="section-title">
                                                                <h2 class="title">Introduction to Islam</h2>
                                                            </div>
                                                            <div class="section-title-line"></div>
                                                        </div>
                                                        <div class="blog-details-wrap">
                                                            <div class="blog-details-content">
                                                                <div class="blog-details-content-top">
                                                                    <a href="javascript:;" class="post-tag">Fundamentals of Islam</a>

                                                                    <div class="blog-details-inner-content">
                                                                        <ul class="list-wrap">
                                                                            <li><i class="fas fa-check"></i>Brief overview of Islam as a
                                                                                monotheistic
                                                                                Abrahamic religion.</li>
                                                                            <li><i class="fas fa-check"></i>Mention the significance of the Quran
                                                                                as
                                                                                the holy book and the Prophet Muhammad as the final messenger.</li>
                                                                        </ul>
                                                                    </div>
                                                                    <h2 class="title mt-30">Five Pillars of Islam</h2>
                                                                    <hr>
                                                                    <h5>1. Shahada (Declaration of Faith)</h5>
                                                                    <p>Explanation of the declaration of faith ("There is no god but Allah, and
                                                                        Muhammad
                                                                        is
                                                                        his messenger").</p>
                                                                    <h5>2. Salah (Prayer)</h5>
                                                                    <p>Overview of the five daily prayers.
                                                                        Importance of prayer in Islam.</p>
                                                                    <h5>3. Zakat (Charity)</h5>
                                                                    <p>Definition and significance of giving charity.
                                                                        How zakat supports the community and those in need.</p>
                                                                    <h5>4. Sawm (Fasting)</h5>
                                                                    <p>Explanation of Ramadan and fasting during this month.
                                                                        Spiritual benefits of fasting.</p>
                                                                    <h5>5. Hajj (Pilgrimage)</h5>
                                                                    <p>Description of the annual pilgrimage to Mecca.
                                                                        Importance of Hajj in a Muslim's life.</p>

                                                                    <h2 class="title mt-30">Beliefs in Islam</h2>
                                                                    <hr>
                                                                    <h5>1. Tawhid (Oneness of God)</h5>
                                                                    <p>Concept of monotheism in Islam. <br>
                                                                        Attributes of Allah.</p>
                                                                    <h5>2. Prophethood</h5>
                                                                    <p>Belief in all prophets including Adam, Noah, Abraham, Moses, Jesus, and
                                                                        Muhammad. <br> Muhammad as the final messenger.
                                                                    </p>
                                                                    <h5>3. Angels and the Hereafter</h5>
                                                                    <p>Belief in angels and their roles. <br>
                                                                        Concept of the afterlife, heaven (Jannah), and hell (Jahannam).</p>
                                                                    <h2 class="title mt-30">Moral and Ethical Principles</h2>
                                                                    <hr>

                                                                    <div class="blog-details-inner-content">
                                                                        <ul class="list-wrap">
                                                                            <li><i class="fas fa-check"></i>Emphasis on justice, kindness, compassion, and respect.</li>
                                                                            <li><i class="fas fa-check"></i>Importance of honesty, humility, and integrity in Islamic teachings.</li>
                                                                        </ul>
                                                                    </div>

                                                                    <h2 class="title mt-30">Islamic Law (Sharia)</h2>
                                                                    <hr>

                                                                    <div class="blog-details-inner-content">
                                                                        <ul class="list-wrap">
                                                                            <li><i class="fas fa-check"></i>Overview of Sharia as a moral and legal framework derived from the Quran and Hadith.</li>
                                                                            <li><i class="fas fa-check"></i>Brief explanation of its application in personal and social life.</li>
                                                                        </ul>
                                                                    </div>
                                                                </div>


                                                            </div>

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-12">

                                                    </div>
                                                </div>
                                            </div>
                                            
                                        </div>
                                    </div>
                                </div>
                            </section>
                        </div>
                        <div class="md:col-3">
                            <div class="sidebar-wrap panel vstack gap-2 pb-2" data-uc-sticky="end: .content-wrap; offset: 150; media: @m;">
                                <div class="widget ad-widget vstack gap-2 text-center p-2 border">
                                    <div class="widgt-content">
                                        <a class="cstack max-w-300px mx-auto text-none" href="https://themeforest.net/user/reacthemes/portfolio" target="_blank" rel="nofollow">
                                            <img class="d-block dark:d-none" src="../assets/images/common/ad-slot-aside.jpg" alt="Ad slot">
                                            <img class="d-none dark:d-block" src="../assets/images/common/ad-slot-aside-2.jpg" alt="Ad slot">
                                        </a>
                                    </div>
                                </div>
                                <!-- TradingView Widget BEGIN -->
                                    <div class="tradingview-widget-container">
                                        <div class="tradingview-widget-container__widget"></div>
                                        <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/" rel="noopener nofollow" target="_blank"><span class="blue-text">Track all markets on TradingView</span></a></div>
                                        <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-timeline.js" async>
                                        {
                                        "displayMode": "regular",
                                        "feedMode": "all_symbols",
                                        "colorTheme": "dark",
                                        "isTransparent": false,
                                        "locale": "en",
                                        "width": 300,
                                        "height": 500
                                    }
                                        </script>
                                    </div>
                                    <!-- TradingView Widget END -->
                                <div class="widget social-widget vstack gap-2 text-center p-2 border">
                                    <div class="widgt-title">
                                        <h4 class="fs-7 ft-tertiary text-uppercase m-0">Follow @News5</h4>
                                    </div>
                                    <div class="widgt-content">
                                        <form class="vstack gap-1">
                                            <input class="form-control form-control-sm fs-6 fw-medium h-40px w-full bg-white dark:bg-gray-800 dark:bg-gray-800 dark:border-white dark:border-opacity-15 dark:border-opacity-15" type="email" placeholder="Your email" required="">
                                            <button class="btn btn-sm btn-primary" type="submit">Sign up</button>
                                        </form>
                                        <ul class="nav-x justify-center gap-1 mt-3">
                                            <li>
                                                <a href="#fb" class="cstack w-32px h-32px border rounded-circle hover:text-black dark:hover:text-white hover:scale-110 transition-all duration-150"><i class="icon icon-1 unicon-logo-facebook"></i></a>
                                            </li>
                                            <li>
                                                <a href="#x" class="cstack w-32px h-32px border rounded-circle hover:text-black dark:hover:text-white hover:scale-110 transition-all duration-150"><i class="icon icon-1 unicon-logo-x-filled"></i></a>
                                            </li>
                                            <li>
                                                <a href="#in" class="cstack w-32px h-32px border rounded-circle hover:text-black dark:hover:text-white hover:scale-110 transition-all duration-150"><i class="icon icon-1 unicon-logo-instagram"></i></a>
                                            </li>
                                            <li>
                                                <a href="#yt" class="cstack w-32px h-32px border rounded-circle hover:text-black dark:hover:text-white hover:scale-110 transition-all duration-150"><i class="icon icon-1 unicon-logo-youtube"></i></a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- blog-details-area-end -->
@endsection
