@extends('user.layouts.app')
@section('meta-content')
 @php
    $settings = \App\Models\GeneralSetting::find(1);
    @endphp
<title>@if($settings){{$settings->site_title}}@endif</title>
<meta name="description" content="@if($settings){{$settings->meta_description}}@endif">
<meta name="title" content="@if($settings){{$settings->meta_title}}@endif">
@endsection
@section('content')

 <!-- Section start -->
 <div class="section panel overflow-hidden swiper-parent border-top">
    <div class="section-outer panel py-2 lg:py-4 dark:text-white">
        <div class="container max-w-xl">
            <div class="section-inner panel vstack gap-2">
                <div class="block-layout carousel-layout vstack gap-2 lg:gap-3 panel">
                    <div class="block-content panel">
                        <div class="swiper" data-uc-swiper="items: 1; gap: 16; dots: .dot-nav; next: .nav-next; prev: .nav-prev; disable-class: d-none;" data-uc-swiper-s="items: 3; gap: 24;" data-uc-swiper-l="items: 4; gap: 24;">
                            <div class="swiper-wrapper">
                                @foreach ($popularblogs as $row)
                                <div class="swiper-slide">
                                    <div>
                                        <article class="post type-post panel uc-transition-toggle gap-2">
                                            <div class="row child-cols g-2" data-uc-grid>
                                                <div class="col-auto">
                                                    <div class="post-media panel overflow-hidden max-w-64px min-w-64px">
                                                        <div class="featured-image bg-gray-25 dark:bg-gray-800 ratio ratio-1x1">
                                                            <img class="media-cover image uc-transition-scale-up uc-transition-opaque" src="{{ asset('admin-assets/images/blogs') }}/{{ $row->feature_image }}" data-src="{{ asset('admin-assets/images/blogs') }}/{{ $row->feature_image }}" alt="Hidden Gems: Underrated Travel Destinations Around the World" data-uc-img="loading: lazy">
                                                        </div>
                                                        <a href="{{route('blog.details',$row->slug)}}" class="position-cover"></a>
                                                    </div>
                                                </div>
                                                <div>
                                                    <div class="post-header panel vstack justify-between gap-1">
                                                        <h3 class="post-title h6 m-0 text-truncate-2">
                                                            <a class="text-none hover:text-primary duration-150" href="{{route('blog.details',$row->slug)}}">{{ $row->title }}</a>
                                                        </h3>
                                                    </div>
                                                </div>
                                            </div>
                                        </article>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                        <div class="swiper-nav nav-prev position-absolute top-50 start-0 translate-middle btn btn-alt-primary text-black rounded-circle p-0 border shadow-xs w-32px h-32px z-1">
                            <i class="icon-1 unicon-chevron-left"></i>
                        </div>
                        <div class="swiper-nav nav-next position-absolute top-50 start-100 translate-middle btn btn-alt-primary text-black rounded-circle p-0 border shadow-xs w-32px h-32px z-1">
                            <i class="icon-1 unicon-chevron-right"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Section end -->

<!-- Section start -->

<div class="section panel mb-4 lg:mb-6">
    <div class="section-outer panel">
        <div class="container max-w-xl">
            <div class="section-inner panel vstack gap-4">
                <div class="section-content">
                    <div class="row child-col-12 lg:child-cols g-4 lg:g-6 col-match">
                        <div class="lg:col-9">
                            <div class="block-layout slider-layout swiper-parent uc-dark">
                                <div class="block-content panel uc-visible-toggle">
                                    <div class="swiper" data-uc-swiper="items: 1; active: 1; gap: 4; prev: .nav-prev; next: .nav-next; autoplay: 6000; parallax: true; fade: true; effect: fade; disable-class: d-none;">
                                        <div class="swiper-wrapper">
                                            @php
                                            $popularblog = $popularblogs->shift();
                                        @endphp
                                        @if($popularblog)
                                            <div class="swiper-slide">
                                                <article class="post type-post panel uc-transition-toggle vstack gap-2 lg:gap-3 h-100 overflow-hidden uc-dark">
                                                    <div class="post-media panel overflow-hidden h-100">
                                                        <div class="featured-image bg-gray-25 dark:bg-gray-800 h-100 d-none md:d-block">
                                                            <canvas class="h-100 w-100"></canvas>
                                                            <img class="media-cover image uc-transition-scale-up uc-transition-opaque" src="{{ asset('admin-assets/images/blogs') }}/{{ $popularblog->feature_image }}" data-src="{{ asset('admin-assets/images/blogs') }}/{{ $popularblog->feature_image }}" alt="Solo Travel: Some Tips and Destinations for the Adventurous Explorer" data-uc-img="loading: lazy">
                                                        </div>
                                                        <div class="featured-image bg-gray-25 dark:bg-gray-800 ratio ratio-16x9 d-block md:d-none">
                                                            <img class="media-cover image uc-transition-scale-up uc-transition-opaque" src="{{ asset('admin-assets/images/blogs') }}/{{ $popularblog->feature_image }}" data-src="{{ asset('admin-assets/images/blogs') }}/{{ $popularblog->feature_image }}" alt="Solo Travel: Some Tips and Destinations for the Adventurous Explorer" data-uc-img="loading: lazy">
                                                        </div>
                                                    </div>
                                                    <div class="position-cover bg-gradient-to-t from-black to-transparent opacity-90"></div>
                                                    <div class="post-header panel vstack justify-end items-start gap-1 p-2 sm:p-4 position-cover text-white" data-swiper-parallax-y="-24">
                                                        <div class="post-date hstack gap-narrow fs-7 text-gray-900 dark:text-white text-opacity-60 d-none md:d-flex">
                                                            <span>{{ $popularblog->updated_at->toFormattedDateString() }}</span>
                                                        </div>
                                                        <h3 class="post-title h5 lg:h4 xl:h3 m-0 max-w-600px text-white text-truncate-2">
                                                            <a class="text-none text-white" href="{{route('blog.details', $popularblog->slug)}}">{{$popularblog->title}}</a>
                                                        </h3>
                                                        <div>
                                                            <div class="post-meta panel hstack justify-between fs-7 text-white text-opacity-60 mt-1">
                                                                <div class="meta">
                                                                    <div class="hstack gap-2">
                                                                        <div>
                                                                            <div class="post-author hstack gap-1">
                                                                                
                                                                                <a href="page-author.html" class="text-black dark:text-white text-none fw-bold">Admin</a>
                                                                            </div>
                                                                        </div>
                                                                        
                                                                    </div>
                                                                </div>
                                                                <div class="actions">
                                                                    <div class="hstack gap-1"></div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </article>
                                            </div>
                                        @endif    
                                        </div>
                                    </div>
                                    <div class="swiper-nav nav-prev position-absolute top-50 start-0 translate-middle-y btn btn-alt-primary text-black rounded-circle p-0 mx-2 border-0 shadow-xs w-32px h-32px z-1 uc-hidden-hover">
                                        <i class="icon-1 unicon-chevron-left"></i>
                                    </div>
                                    <div class="swiper-nav nav-next position-absolute top-50 end-0 translate-middle-y btn btn-alt-primary text-black rounded-circle p-0 mx-2 border-0 shadow-xs w-32px h-32px z-1 uc-hidden-hover">
                                        <i class="icon-1 unicon-chevron-right"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="lg:col-3">
                            <div class="panel cstack gap-2 h-100">
                                <div>
                                    <div class="widget ad-widget vstack gap-2">
                                        <!-- TradingView Widget BEGIN -->
<div class="tradingview-widget-container">
    <div class="tradingview-widget-container__widget"></div>
    <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/" rel="noopener nofollow" target="_blank"><span class="blue-text">Track all markets on TradingView</span></a></div>
    <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-timeline.js" async>
    {
    "displayMode": "regular",
    "feedMode": "all_symbols",
    "colorTheme": "dark",
    "isTransparent": false,
    "locale": "en",
    "width": 300,
    "height": 500
  }
    </script>
  </div>
  <!-- TradingView Widget END -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Section end -->

<!-- Section start -->
<div class="section panel overflow-hidden">
    <div class="section-outer panel">
        <div class="container max-w-xl">
            <div class="section-inner">
                <div class="row child-cols-12 lg:child-cols g-4 lg:g-6 col-match" data-uc-grid>
                    <div class="lg:col-8">
                        <div class="block-layout grid-layout vstack gap-2 lg:gap-3 panel overflow-hidden">
                            <div class="block-header panel pt-1 border-top">
                                <h2 class="h6 ft-tertiary fw-bold ls-0 text-uppercase m-0 text-black dark:text-white">
                                    <a class="hstack d-inline-flex gap-0 text-none hover:text-primary duration-150" href="blog-category.html">
                                        <span>Latest</span>
                                        <i class="icon-1 fw-bold unicon-chevron-right"></i>
                                    </a>
                                </h2>
                            </div>
                            <div class="block-content">
                                <div class="panel row child-cols-12 md:child-cols g-2 lg:g-4 col-match sep-y" data-uc-grid>
                                    <div class="col-12 md:col-6 order-0 md:order-1">
                                    @php
                                        $blog = $blogs->shift();
                                    @endphp
                                    @if($blog)
                                        <div>
                                            <article class="post type-post panel uc-transition-toggle vstack gap-2 lg:gap-3 h-100 overflow-hidden uc-dark">
                                                <div class="post-media panel overflow-hidden h-100">
                                                    <div class="featured-image bg-gray-25 dark:bg-gray-800 h-100 d-none md:d-block">
                                                        <canvas class="h-100 w-100"></canvas>
                                                        <img class="media-cover image uc-transition-scale-up uc-transition-opaque" src="{{ asset('admin-assets/images/blogs') }}/{{ $blog->feature_image }}" data-src="{{ asset('admin-assets/images/blogs') }}/{{ $blog->feature_image }}" alt="The Importance of Sleep: Tips for Better Rest and Recovery" data-uc-img="loading: lazy">
                                                    </div>
                                                    <div class="featured-image bg-gray-25 dark:bg-gray-800 ratio ratio-16x9 d-block md:d-none">
                                                        <img class="media-cover image uc-transition-scale-up uc-transition-opaque" src="{{ asset('admin-assets/images/blogs') }}/{{ $blog->feature_image }}" data-src="{{ asset('admin-assets/images/blogs') }}/{{ $blog->feature_image }}" alt="The Importance of Sleep: Tips for Better Rest and Recovery" data-uc-img="loading: lazy">
                                                    </div>
                                                </div>
                                                <div class="position-cover bg-gradient-to-t from-black to-transparent opacity-90"></div>
                                                <div class="post-header panel vstack justify-end items-start gap-1 p-2 sm:p-4 position-cover text-white">
                                                    <div class="post-date hstack gap-narrow fs-7 text-gray-900 dark:text-white text-opacity-60 d-none md:d-flex">
                                                        <span>{{ $blog->updated_at->toFormattedDateString() }}</span>
                                                    </div>
                                                    <h3 class="post-title h5 lg:h4 m-0 max-w-600px text-white text-truncate-2">
                                                        <a class="text-none text-white" href="{{ route('blog.details', $blog->slug) }}">{{ $blog->title }}</a>
                                                    </h3>
                                                    <div>
                                                        <div class="post-meta panel hstack justify-between fs-7 text-white text-opacity-60 mt-1">
                                                            <div class="meta">
                                                                <div class="hstack gap-2">
                                                                    <div>
                                                                        <div class="post-author hstack gap-1">
                                                                            
                                                                            <a href="page-author.html" class="text-black dark:text-white text-none fw-bold">Admin</a>
                                                                        </div>
                                                                    </div>
                                                                    <div>
                                                                        <a href="javascript:;" class="post-comments text-none hstack gap-narrow">
                                                                            {{ $blog->category->name }}
                                                                        </a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="actions">
                                                                <div class="hstack gap-1"></div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </article>
                                        </div>
                                    @endif    
                                    </div>
                                    <div class="order-1 md:order-0">
                                        <div class="row child-cols-12 g-2 lg:g-4 sep-x" data-uc-grid>
                                            @foreach ($blogs as $row)
                                            <div>
                                                <article class="post type-post panel uc-transition-toggle">
                                                    <div class="row child-cols g-2 lg:g-3" data-uc-grid>
                                                        <div>
                                                            <div class="post-header panel vstack justify-between gap-1">
                                                                <h3 class="post-title h6 m-0 text-truncate-2">
                                                                    <a class="text-none hover:text-primary duration-150" href="{{route('blog.details',$row->slug)}}">{{$row->title}}</a>
                                                                </h3>
                                                                <div class="post-date hstack gap-narrow fs-7 text-gray-900 dark:text-white text-opacity-60 d-none md:d-flex">
                                                                    <span>{{ $blog->updated_at->toFormattedDateString() }}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-auto">
                                                            <div class="post-media panel overflow-hidden max-w-72px min-w-72px">
                                                                <div class="featured-image bg-gray-25 dark:bg-gray-800 ratio ratio-1x1">
                                                                    <img class="media-cover image uc-transition-scale-up uc-transition-opaque" src="{{ asset('admin-assets/images/blogs') }}/{{ $row->feature_image }}" data-src="{{ asset('admin-assets/images/blogs') }}/{{ $row->feature_image }}" alt="The Future of Sustainable Living: Driving Eco-Friendly Lifestyles" data-uc-img="loading: lazy">
                                                                </div>
                                                                <a href="{{ route('blog.details', $row->slug) }}" class="position-cover"></a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </article>
                                            </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="lg:col-4">
                        <div class="block-layout grid-layout vstack gap-2 lg:gap-3 panel overflow-hidden">
                            <div class="block-header panel pt-1 border-top">
                                <h2 class="h6 ft-tertiary fw-bold ls-0 text-uppercase m-0 text-black dark:text-white">
                                    <a class="hstack d-inline-flex gap-0 text-none hover:text-primary duration-150" href="blog-category.html">
                                        <span>Popular</span>
                                        <i class="icon-1 fw-bold unicon-chevron-right"></i>
                                    </a>
                                </h2>
                            </div>
                            <div class="block-content">
                                <div class="row child-cols-12 g-2 lg:g-4 sep-x" data-uc-grid>
                                    @foreach($popblogs as $row)
                                    <div>
                                        <article class="post type-post panel uc-transition-toggle">
                                            <div class="row child-cols g-2 lg:g-3" data-uc-grid>
                                                <div>
                                                    <div class="post-header panel vstack justify-between gap-1">
                                                        <h3 class="post-title h6 m-0 text-truncate-2">
                                                            <a class="text-none hover:text-primary duration-150" href="{{route('blog.details',$row->slug)}}">{{$row->title}}</a>
                                                        </h3>
                                                        <div class="post-date hstack gap-narrow fs-7 text-gray-900 dark:text-white text-opacity-60 d-none md:d-flex">
                                                            <span>{{ $blog->updated_at->toFormattedDateString() }}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-auto">
                                                    <div class="post-media panel overflow-hidden max-w-72px min-w-72px">
                                                        <div class="featured-image bg-gray-25 dark:bg-gray-800 ratio ratio-1x1">
                                                            <img class="media-cover image uc-transition-scale-up uc-transition-opaque" src="{{ asset('admin-assets/images/blogs') }}/{{ $row->feature_image }}" data-src="{{ asset('admin-assets/images/blogs') }}/{{ $row->feature_image }}" alt="The Future of Sustainable Living: Driving Eco-Friendly Lifestyles" data-uc-img="loading: lazy">
                                                        </div>
                                                        <a href="{{ route('blog.details', $row->slug) }}" class="position-cover"></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </article>
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Section end -->


<!-- Section start -->
<div class="section panel overflow-hidden">
    <div class="section-outer panel py-4 lg:py-6 dark:text-white">
        <div class="container max-w-xl">
            <div class="section-inner">
                <div class="row child-cols-12 lg:child-cols g-4 lg:g-6 col-match" data-uc-grid>
                    @foreach($category_blogs as $category)
                    @php
                        $categblogs = \App\Models\Blog::where('category_id', $category->id)->where('status', 'publish')->latest()->inRandomOrder()->limit(4)->get();
                    @endphp
                    <div class="lg:col-4">
                        <div class="block-layout list-layout vstack gap-2 lg:gap-3 panel overflow-hidden">
                            <div class="block-header panel pt-1 border-top">
                                <h2 class="h6 ft-tertiary fw-bold ls-0 text-uppercase m-0 text-black dark:text-white">
                                    <a class="hstack d-inline-flex gap-0 text-none hover:text-primary duration-150" href="blog-category.html">
                                        <span>{{$category->name}}</span>
                                        <i class="icon-1 fw-bold unicon-chevron-right"></i>
                                    </a>
                                </h2>
                            </div>
                            <div class="block-content">
                                <div class="row child-cols-12 g-2 lg:g-4 sep-x" data-uc-grid>
                                    @php
                                        $chblog = $categblogs->shift();
                                    @endphp
                                    @if($chblog)
                                    <div>
                                        <article class="post type-post panel uc-transition-toggle vstack gap-2 lg:gap-3 overflow-hidden uc-dark">
                                            <div class="post-media panel overflow-hidden">
                                                <div class="featured-image bg-gray-25 dark:bg-gray-800 ratio ratio-4x3">
                                                    <img class="media-cover image uc-transition-scale-up uc-transition-opaque" src="{{ asset('admin-assets/images/blogs') }}/{{ $chblog->feature_image }}" data-src="{{ asset('admin-assets/images/blogs') }}/{{ $chblog->feature_image }}" alt="The Rise of AI-Powered Personal Assistants: How They Manage" data-uc-img="loading: lazy">
                                                </div>
                                            </div>
                                            <div class="position-cover bg-gradient-to-t from-black to-transparent opacity-90"></div>
                                            <div class="post-header panel vstack justify-start items-start flex-column-reverse gap-1 p-2 position-cover text-white">
                                                <div class="post-meta panel hstack justify-between fs-7 text-white text-opacity-60 mt-1">
                                                    <div class="meta">
                                                        <div class="hstack gap-2">
                                                            <div>
                                                                <div class="post-author hstack gap-1">
                                                                    
                                                                    <a href="" class="text-black dark:text-white text-none fw-bold">Admin</a>
                                                                </div>
                                                            </div>
                                                            <div>
                                                                <a href="#post_comment" class="post-comments text-none hstack gap-narrow">
                                                                    <i class="icon-narrow unicon-chat"></i>
                                                                    <span>{{$category->name}}</span>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="actions">
                                                        <div class="hstack gap-1"></div>
                                                    </div>
                                                </div>
                                                <h3 class="post-title h6 lg:h5 m-0 m-0 max-w-600px text-white text-truncate-2">
                                                    <a class="text-none text-white" href="{{ route('blog.details', $chblog->slug) }}">{{$chblog->title}}</a>
                                                </h3>
                                                <div class="post-date hstack gap-narrow fs-7 text-gray-900 dark:text-white text-opacity-60 d-none md:d-flex">
                                                    <span>{{ $chblog->updated_at->toFormattedDateString() }}</span>
                                                </div>
                                            </div>
                                            <a href="{{ route('blog.details', $chblog->slug) }}" class="position-cover"></a>
                                        </article>
                                    </div>
                                    @endif
                                    @foreach($categblogs as $cblog)
                                    <div>
                                        <article class="post type-post panel uc-transition-toggle">
                                            <div class="row child-cols g-2 lg:g-3" data-uc-grid>
                                                <div>
                                                    <div class="post-header panel vstack justify-between gap-1">
                                                        <h3 class="post-title h6 m-0 text-truncate-2">
                                                            <a class="text-none hover:text-primary duration-150" href="{{route('blog.details',$cblog->slug)}}">{{$cblog->title}}</a>
                                                        </h3>
                                                        <div class="post-date hstack gap-narrow fs-7 text-gray-900 dark:text-white text-opacity-60 d-none md:d-flex">
                                                            <span>{{ $cblog->updated_at->toFormattedDateString() }}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-auto">
                                                    <div class="post-media panel overflow-hidden max-w-72px min-w-72px">
                                                        <div class="featured-image bg-gray-25 dark:bg-gray-800 ratio ratio-1x1">
                                                            <img class="media-cover image uc-transition-scale-up uc-transition-opaque" src="{{ asset('admin-assets/images/blogs') }}/{{ $cblog->feature_image }}" data-src="{{ asset('admin-assets/images/blogs') }}/{{ $cblog->feature_image }}" alt="The Future of Sustainable Living: Driving Eco-Friendly Lifestyles" data-uc-img="loading: lazy">
                                                        </div>
                                                        <a href="{{ route('blog.details', $cblog->slug) }}" class="position-cover"></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </article>
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                    @endforeach
                    <div class="lg:col-4">
                        <!-- TradingView Widget BEGIN -->
<div class="tradingview-widget-container">
    <div class="tradingview-widget-container__widget"></div>
    <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/" rel="noopener nofollow" target="_blank"><span class="blue-text">Track all markets on TradingView</span></a></div>
    <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-hotlists.js" async>
    {
    "exchange": "US",
    "colorTheme": "dark",
    "dateRange": "12M",
    "showChart": true,
    "locale": "en",
    "largeChartUrl": "",
    "isTransparent": false,
    "showSymbolLogo": false,
    "showFloatingTooltip": false,
    "plotLineColorGrowing": "rgba(41, 98, 255, 1)",
    "plotLineColorFalling": "rgba(41, 98, 255, 1)",
    "gridLineColor": "rgba(240, 243, 250, 0)",
    "scaleFontColor": "#DBDBDB",
    "belowLineFillColorGrowing": "rgba(41, 98, 255, 0.12)",
    "belowLineFillColorFalling": "rgba(41, 98, 255, 0.12)",
    "belowLineFillColorGrowingBottom": "rgba(41, 98, 255, 0)",
    "belowLineFillColorFallingBottom": "rgba(41, 98, 255, 0)",
    "symbolActiveColor": "rgba(41, 98, 255, 0.12)",
    "width": 400,
    "height": 500
  }
    </script>
  </div>
  <!-- TradingView Widget END -->
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

 
@endsection
@section('custom-scripts')
    <script src="https://cdn.jsdelivr.net/npm/izitoast/dist/js/iziToast.min.js"></script>

    <script>

        $("#subscribe_form_btn").click(function(e) {
            e.preventDefault();
            let form = $('#subscribe_form')[0];
            let data = new FormData(form);

            $.ajax({
                url: "{{ route('subscriber.store') }}",
                type: "POST",
                data: data,
                dataType: "JSON",
                processData: false,
                contentType: false,

                success: function(response) {

                    if (response.errors) {
                        var errorMsg = '';
                        $.each(response.errors, function(field, errors) {
                            $.each(errors, function(index, error) {
                                errorMsg += error + '<br>';
                            });
                        });
                        iziToast.error({
                            message: 'Subscription Failed',
                            position: 'topRight'
                        });

                    } else {
                        iziToast.success({
                            message: response.success,
                            position: 'topRight'

                        });

                        $("#subscribe_form").load(location.href + " #subscribe_form");

                    }

                },
                error: function(xhr, status, error) {

                    iziToast.error({
                        message: 'An error occurred: ' + error,
                        position: 'topRight'
                    });
                }

            });

        });
       
    </script>
@endsection
