@extends('user.layouts.app')
@section('meta-content')
 @php
    $settings = \App\Models\GeneralSetting::find(1);
    @endphp
<title>@if($settings){{$settings->site_title}}@endif</title>
<meta name="description" content="@if($settings){{$settings->meta_description}}@endif">
<meta name="title" content="@if($settings){{$settings->meta_title}}@endif">
@endsection
@section('custom-styles')
@endsection
@section('content')
    <!-- breadcrumb-area -->
    <div class="breadcrumb-area">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-content">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('index')}}">Home</a></li>
                                <li class="breadcrumb-item" aria-current="page"><a href="javasript">Forex & Crypto</a></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb-area-end -->
    <div id="latest_news" class="latest-news section panel">
        <div class="section-outer panel py-4 lg:py-6">
            <div class="container max-w-xl">
                <div class="section-inner">
                    <div class="content-wrap row child-cols-12 g-4 lg:g-6" data-uc-grid>
                        <div class="md:col-9">
                            <!-- TradingView Widget BEGIN -->
                            <div class="tradingview-widget-container">
                                <div class="tradingview-widget-container__widget"></div>
                                <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/" rel="noopener nofollow"
                                        target="_blank"><span class="blue-text">Track all markets on TradingView</span></a></div>
                                <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-ticker-tape.js" async>
                                    {
                                        "symbols": [{
                                                "proName": "FOREXCOM:SPXUSD",
                                                "title": "S&P 500 Index"
                                            },
                                            {
                                                "proName": "FOREXCOM:NSXUSD",
                                                "title": "US 100 Cash CFD"
                                            },
                                            {
                                                "proName": "FX_IDC:EURUSD",
                                                "title": "EUR to USD"
                                            },
                                            {
                                                "proName": "BITSTAMP:BTCUSD",
                                                "title": "Bitcoin"
                                            },
                                            {
                                                "proName": "BITSTAMP:ETHUSD",
                                                "title": "Ethereum"
                                            }
                                        ],
                                        "showSymbolLogo": true,
                                        "isTransparent": false,
                                        "displayMode": "compact",
                                        "colorTheme": "dark",
                                        "locale": "en"
                                    }
                                </script>
                            </div>
                            <!-- TradingView Widget END -->

                            <section class="blog-details-area pt-60 pb-60">
                                <div class="container">
                                    <div class="author-inner-wrap">
                                        <div class="row justify-content-center">
                                            <div class="col-70">
                                                <div class="section-title-wrap mb-30">
                                                    <div class="section-title">
                                                        <h2 class="title">Forex Cross Rates</h2>
                                                    </div>
                                                    <div class="section-title-line"></div>
                                                </div>
                                                <!-- TradingView Widget BEGIN -->
                                                <div class="tradingview-widget-container">
                                                    <div class="tradingview-widget-container__widget"></div>
                                                    <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/"
                                                            rel="noopener nofollow" target="_blank"><span class="blue-text">Track all markets on
                                                                TradingView</span></a></div>
                                                    <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-forex-cross-rates.js"
                                                        async>
                                                        {
                                                            "width": "100%",
                                                            "height": "50%",
                                                            "currencies": [
                                                                "EUR",
                                                                "USD",
                                                                "JPY",
                                                                "GBP",
                                                                "CHF",
                                                                "AUD",
                                                                "CAD",
                                                                "NZD",
                                                                "CNY",
                                                                "TRY",
                                                                "SEK",
                                                                "NOK",
                                                                "DKK",
                                                                "ZAR",
                                                                "HKD",
                                                                "SGD",
                                                                "THB",
                                                                "MXN",
                                                                "IDR",
                                                                "KRW",
                                                                "PLN",
                                                                "ISK",
                                                                "KWD",
                                                                "PHP",
                                                                "MYR",
                                                                "INR",
                                                                "TWD",
                                                                "SAR",
                                                                "AED",
                                                                "RUB",
                                                                "ILS",
                                                                "ARS",
                                                                "CLP",
                                                                "COP",
                                                                "PEN",
                                                                "UYU"
                                                            ],
                                                            "isTransparent": false,
                                                            "colorTheme": "dark",
                                                            "locale": "en"
                                                        }
                                                    </script>
                                                </div>
                                                <!-- TradingView Widget END -->
                                                <div class="section-title-wrap mb-30">
                                                    <div class="section-title">
                                                        <h2 class="title">Crypto Rates</h2>
                                                    </div>
                                                    <div class="section-title-line"></div>
                                                </div>
                                                <!-- TradingView Widget BEGIN -->
<div class="tradingview-widget-container">
    <div class="tradingview-widget-container__widget"></div>
    <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/" rel="noopener nofollow" target="_blank"><span class="blue-text">Track all markets on TradingView</span></a></div>
    <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-screener.js" async>
    {
    "defaultColumn": "overview",
    "screener_type": "crypto_mkt",
    "displayCurrency": "USD",
    "colorTheme": "dark",
    "isTransparent": false,
    "locale": "en",
    "width": "100%",
    "height": "80%"
  }
    </script>
  </div>
  <!-- TradingView Widget END -->
                                            </div>
                                            
                                        </div>
                                    </div>
                                </div>
                            </section>
                        </div>
                        <div class="md:col-3">
                            <div class="sidebar-wrap panel vstack gap-2 pb-2" data-uc-sticky="end: .content-wrap; offset: 150; media: @m;">
                                <div class="widget ad-widget vstack gap-2 text-center p-2 border">
                                    <div class="widgt-content">
                                        <a class="cstack max-w-300px mx-auto text-none" href="https://themeforest.net/user/reacthemes/portfolio" target="_blank" rel="nofollow">
                                            <img class="d-block dark:d-none" src="../assets/images/common/ad-slot-aside.jpg" alt="Ad slot">
                                            <img class="d-none dark:d-block" src="../assets/images/common/ad-slot-aside-2.jpg" alt="Ad slot">
                                        </a>
                                    </div>
                                </div>
                                <!-- TradingView Widget BEGIN -->
                                    <div class="tradingview-widget-container">
                                        <div class="tradingview-widget-container__widget"></div>
                                        <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/" rel="noopener nofollow" target="_blank"><span class="blue-text">Track all markets on TradingView</span></a></div>
                                        <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-timeline.js" async>
                                        {
                                        "displayMode": "regular",
                                        "feedMode": "all_symbols",
                                        "colorTheme": "dark",
                                        "isTransparent": false,
                                        "locale": "en",
                                        "width": 300,
                                        "height": 500
                                    }
                                        </script>
                                    </div>
                                    <!-- TradingView Widget END -->
                                <div class="widget social-widget vstack gap-2 text-center p-2 border">
                                    <div class="widgt-title">
                                        <h4 class="fs-7 ft-tertiary text-uppercase m-0">Follow @News5</h4>
                                    </div>
                                    <div class="widgt-content">
                                        <form class="vstack gap-1">
                                            <input class="form-control form-control-sm fs-6 fw-medium h-40px w-full bg-white dark:bg-gray-800 dark:bg-gray-800 dark:border-white dark:border-opacity-15 dark:border-opacity-15" type="email" placeholder="Your email" required="">
                                            <button class="btn btn-sm btn-primary" type="submit">Sign up</button>
                                        </form>
                                        <ul class="nav-x justify-center gap-1 mt-3">
                                            <li>
                                                <a href="#fb" class="cstack w-32px h-32px border rounded-circle hover:text-black dark:hover:text-white hover:scale-110 transition-all duration-150"><i class="icon icon-1 unicon-logo-facebook"></i></a>
                                            </li>
                                            <li>
                                                <a href="#x" class="cstack w-32px h-32px border rounded-circle hover:text-black dark:hover:text-white hover:scale-110 transition-all duration-150"><i class="icon icon-1 unicon-logo-x-filled"></i></a>
                                            </li>
                                            <li>
                                                <a href="#in" class="cstack w-32px h-32px border rounded-circle hover:text-black dark:hover:text-white hover:scale-110 transition-all duration-150"><i class="icon icon-1 unicon-logo-instagram"></i></a>
                                            </li>
                                            <li>
                                                <a href="#yt" class="cstack w-32px h-32px border rounded-circle hover:text-black dark:hover:text-white hover:scale-110 transition-all duration-150"><i class="icon icon-1 unicon-logo-youtube"></i></a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
@endsection
@section('custom-scripts')
@endsection
