<!doctype html>
<html class="no-js" lang="en">
    @php
    $settings = \App\Models\GeneralSetting::find(1);
    @endphp
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
     <title>@if($settings){{$settings->site_title}}@endif</title>
     <meta name="description" content="@if($settings){{$settings->meta_description}}@endif">
    <meta name="title" content="@if($settings){{$settings->meta_title}}@endif">
    <meta name="viewport" content="width=device-width, initial-scale=1">

     <link rel="shortcut icon" type="image/x-admin-icon" href="@if($settings){{ asset('admin-assets/images/logos') }}/{{$settings->favicon}}@endif">
    <!-- Place favicon.ico in the root directory -->

    <!-- CSS here -->
    @include('user.includes.styles')
    @yield('custom-styles')
</head>

<body>

    <!-- Dark/Light-toggle -->
    <div class="darkmode-trigger">
        <label class="modeSwitch">
            <input type="checkbox">
            <span class="icon"></span>
        </label>
    </div>
    <!-- Dark/Light-toggle-end -->

    <!-- Scroll-top -->
    <button class="scroll-top scroll-to-target" data-target="html">
        <i class="fas fa-angle-up"></i>
    </button>
    <!-- Scroll-top-end-->

    <!-- header-area -->
    <header>
        <div id="header-fixed-height"></div>
        <div class="header-top-wrap">
            <div class="container-fluid p-0">
                <div class="row align-items-center">
                    <div class="col-md-6">
                        <div class="header-top-menu">
                            <ul class="list-wrap">
                                <li><a href="{{route('gold.rates')}}">Gold</a></li>
                                <li><a href="{{route('forex.crypto')}}">Forex/Crypto</a></li>
                                <li><a href="{{route('prayer.times')}}">Prayer Timings</a></li>
                                <li><a href="{{route('frontend-stores')}}">Brands</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="header-top-social d-none d-md-flex">
                            <h5 class="title">Follow Us:</h5>
                            <ul class="list-wrap">
                                @php
                                $socials = \App\Models\SocialMedia::all();
                            @endphp
                            @if ($socials)

                                @foreach ($socials as $row)
                                    <li> <a href="{{ $row->url }}" target="_blank">
                                            <i class="{{ $row->icon }} me-2"></i></a></li>
                                @endforeach
                            @endif
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
    </header>

    <!-- header-area-end -->


    <!-- main-area -->
    <main class="fix">

        @yield('content')

    </main>
    <!-- main-area-end -->

    <!-- footer-area -->


    <!-- footer-area-end -->
    

    <!-- JS here -->
    @include('user.includes.scripts')
    @yield('custom-scripts')
    <script>
     $(document).on('keyup', '.search-input', function () {
    var keyword = $('.search-input').val();
    console.log(keyword);
    $.ajax({
        type: 'GET',
        url: "{{ route('get-blogs') }}",
        data: {
            key: keyword
        },
        success: function (resp) {
            console.log(resp);
            $('.autocomplete').css('display', 'block');
            $('.autocomplete').html(resp);
        },
        error: function (resp) {
            console.log(resp);
        }
    });
});
    </script>
</body>

</html>
