<!doctype html>
<html class="no-js" lang="en">
    @php
    $settings = \App\Models\GeneralSetting::find(1);
    @endphp
<head>
    <meta charset="utf-8">
    <meta name="verify-admitad" content="b7ac5cac35" />
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    @yield('meta-content')
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=AW-11071565171">
    </script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());

        gtag('config', 'AW-11071565171');
    </script>

     <link rel="shortcut icon" type="image/x-admin-icon" href="@if($settings){{ asset('admin-assets/images/logos') }}/{{$settings->favicon}}@endif">
    <!-- Place favicon.ico in the root directory -->
   
    <!-- CSS here -->
    @include('user.includes.styles')
    @yield('custom-styles')
    
   <link rel="canonical" href="{{url()->current()}}"/>
</head>

<body class="uni-body panel bg-white text-gray-900 dark:bg-black dark:text-white text-opacity-50 overflow-x-hidden">

    <!--  Search modal -->
    <div id="uc-search-modal" class="uc-modal-full uc-modal" data-uc-modal="overlay: true">
        <div class="uc-modal-dialog d-flex justify-center bg-white text-dark dark:bg-gray-900 dark:text-white"
            data-uc-height-viewport="">
            <button
                class="uc-modal-close-default p-0 icon-3 btn border-0 dark:text-white dark:text-opacity-50 hover:text-primary hover:rotate-90 duration-150 transition-all"
                type="button">
                <i class="unicon-close"></i>
            </button>
            <div class="panel w-100 sm:w-500px px-2 py-10">
                <h3 class="h1 text-center">Search</h3>
                <form class="hstack gap-1 mt-4 border-bottom p-narrow dark:border-gray-700" action="?">
                    <span
                        class="d-inline-flex justify-center items-center w-24px sm:w-40 h-24px sm:h-40px opacity-50"><i
                            class="unicon-search icon-3"></i></span>
                    <input type="search" name="q"
                        class="form-control-plaintext ms-1 fs-6 sm:fs-5 w-full dark:text-white search-input"
                        placeholder="Type your keyword.." aria-label="Search" autofocus>
                </form>
                <div class="autocomplete" style="display:none"></div>
            </div>
        </div>
    </div>

    <!--  Menu panel -->
    <div id="uc-menu-panel" data-uc-offcanvas="overlay: true;">
        <div class="uc-offcanvas-bar bg-white text-dark dark:bg-gray-900 dark:text-white">
            <header class="uc-offcanvas-header hstack justify-between items-center pb-4 bg-white dark:bg-gray-900">
                <div class="uc-logo">
                    <a href="index.html" class="h5 text-none text-gray-900 dark:text-white">
                        <img class="" src="{{asset('user-assets/images/logo-light.svg')}}" alt="News5">
                    </a>
                </div>
                <button
                    class="uc-offcanvas-close p-0 icon-3 btn border-0 dark:text-white dark:text-opacity-50 hover:text-primary hover:rotate-90 duration-150 transition-all"
                    type="button">
                    <i class="unicon-close"></i>
                </button>
            </header>

            <div class="panel">
                <form id="search-panel" class="form-icon-group vstack gap-1 mb-3" data-uc-sticky="">
                    <input type="email" class="form-control form-control-md fs-6" placeholder="Search..">
                    <span class="form-icon text-gray">
                        <i class="unicon-search icon-1"></i>
                    </span>
                </form>
                <ul class="nav-y gap-narrow fw-bold fs-5" data-uc-nav>
                    <li><a href="{{route('index')}}">Home</a></li>
                    @php
                                $categories = \App\Models\Category::select('id', 'slug', 'name')
                                    ->limit(6)
                                    ->get();
                            @endphp
                            @foreach ($categories as $key => $row)
                    <li class="uc-parent">
                        <a href="{{ route('blogs.category', $row->slug) }}">{{$row->name}} </a>
                        <ul class="uc-nav-sub" data-uc-nav="">
                            @php
                            $subcategories = \App\Models\SubCategory::select(
                                'id',
                                'name',
                                'slug',
                            )
                                ->where('category_id', $row->id)
                                ->get();
                        @endphp
                            @foreach ($subcategories as $subcategory)
                            <li><a href="{{ route('blogs.subcategory', ['categoryslug' => $row->slug, 'subcategoryslug' => $subcategory->slug]) }}">{{$subcategory->name}}</a></li>
                            @endforeach
                        </ul>
                    </li>
                    @endforeach
                    
                    <li>
                        <a href="{{route('forex.crypto')}}">Forex/ Crypto</a>
                    </li>
                    <li>
                        <a href="{{route('gold.rates')}}">Gold</a>
                    </li>
                    <li>
                        <a href="{{route('prayer.times')}}">Prayers Timings</a>
                    </li>
                    
                    
                    <!--<li class="hr opacity-10 my-1"></li>-->
                    <!--<li><a href="sign-in.html">Sign in</a></li>-->
                    <!--<li><a href="sign-up.html">Create an account</a></li>-->
                </ul>
                <ul class="social-icons nav-x mt-4">
                    <li>
                        @php
                        $social_links = \App\Models\SocialMedia::get();
                    @endphp
                    @foreach($social_links as $link)
                        <a href="{{$link->url}}"><i class="unicon-logo-{{$link->title}} icon-2"></i></a>
                    @endforeach
                    </li>
                </ul>
                <div class="py-2 hstack gap-2 mt-4 bg-white dark:bg-gray-900" data-uc-sticky="position: bottom">
                    <div class="vstack gap-1">
                        <span class="fs-7 opacity-60">Select theme:</span>
                        <div class="darkmode-trigger" data-darkmode-switch="">
                            <label class="switch">
                                <input type="checkbox">
                                <span class="slider fs-5"></span>
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- header-area -->
    @include('user.includes.header')


    <!-- header-area-end -->


    <!-- main-area -->
    <div id="wrapper" class="wrap overflow-hidden-x">
        @yield('content')

    </div>
    <!-- main-area-end -->

    <!-- footer-area -->
    @include('user.includes.footer')


    <!-- footer-area-end -->
<div class="modal" id="couponModal">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal_main">
                    <div class="modal-header">
                        <center>
                            <h5 class="modal-title" id="exampleModalLabel"></h5>
                            <div class="store_title_modal">
                                <div class="modal_title_img">
                                    <a href="#" class="web_imagebox">
                                        <img class="img-responsive lazy modal-img" src="" style="">
                                    </a>
                                </div>
                                <div class="modal_title_content">
                                    <h2 class="store_modal modal_title"></h2>
                                    <div class="code-desc modal-desc">

                                    </div>
                                </div>
                            </div>
                            <button type="button" class="close close_modal" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                        </center>
                    </div>
                    <div class="modal-body">
                        <div class="modal_body_main">
                            <!--<p> Get Potted website has been opened in a new tab / window. Simply copy and paste the code CART5 and enter it at the checkout.</p>-->
                            <div class="modal_code pccopybtn code_text" data-clipboard-text="">

                            </div>
                            <a href="javascript:;"  onclick="copyToClipboard('.code_text')" class="visit_site" data-clipboard-action="copy"
                                data-clipboard-target="#code_text">Copy Code<i class=" fa fa-arrow-right"></i></a>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <!-- JS here -->

    @include('user.includes.scripts')
    @yield('custom-scripts')
     <script src="{{ asset('user-assets/js/clipboard.min.js') }}" type="text/javascript"></script>
    <script src="{{ asset('user-assets/js/custom.js') }}" type="text/javascript"></script>
    <script>
        var btn = document.getElementById('btn');
        var clipboard = new ClipboardJS(btn);

        clipboard.on('success', function(e) {
            console.info('Action:', e.action);
            console.info('Text:', e.text);
            console.info('Trigger:', e.trigger);
        });

        clipboard.on('error', function(e) {
            console.info('Action:', e.action);
            console.info('Text:', e.text);
            console.info('Trigger:', e.trigger);
        });
    </script>
    <script>
    	$(document).on('click','#coupon-button',function(){
    // alert();
    $('#couponModal').css('display','block');

  $('#couponModal').modal('show');
  var get_code = $(this).data('code');
  var get_url = $(this).data('url');
  var get_title = $(this).data('title');
  var get_des = $(this).data('des');
  var get_id = $(this).data('coupon_id');
  var get_img = $(this).data("img");
  $(this).parents('a').attr('href',get_url);
  console.log(get_code);
    $.ajax({
        type: "GET",
        contentType: "application/json; charset=utf-8",
        url: "{{route('update_coupon_used')}}",
        dataType: "json",
        data:{id:get_id},
        success: function (data) {
            console.log(data);
        },
        error: function (data){
            console.log(data);
        }
    });
  
  if(get_code == ""){
      $('.visit_site').css('display','none');
      $('.for-deal').css('display','block');
      $('.modal-url').attr('href',get_url);
  }
  else{
     $('.visit_site').css('display','block');
      $('.for-deal').css('display','none');
      $('.modal-url').attr('href','javascript:void(0)');
  }

  $('.code_text').text(get_code);
  $('.modal-url').attr('href',get_url);
  $('.modal-title').text(get_title);
  $('.modal_title').text(get_title);
  $('.modal-desc').text(get_des);
  $(".modal-img").attr("src",get_img);

});
function copyToClipboard(element) 
{
        var $temp = $("<input>");
        $("body").append($temp);
        $temp.val($(element).text()).select();
        document.execCommand("copy");
        $temp.remove();
        $('.code_text').text('Copied');
}
$(function () {
    $(".close").click(function () {
        $("#couponModal").modal("hide");
    });
});
         $(document).on('keyup', '.search-input', function() {
            var keyword = $('.search-input').val();
            console.log(keyword);
            $.ajax({
                type: 'GET',
                url: "{{ route('get-blogs') }}",
                data: {
                    key: keyword
                },
                success: function(resp) {
                    console.log(resp);
                    $('.autocomplete').css('display', 'block');
                    $('.autocomplete').html(resp);
                },
                error: function(resp) {
                    console.log(resp);
                }
            });
        });
    </script>
   

</body>

</html>
