@extends('user.layouts.auth')

@section('content')

    <div class="container mt-3">
        <div class="row justify-content-center">

            <div class="col-md-3">
                <div class="clear-fix mb-5 bt-2">
                    <center>
                        <div class="authlogos">
                            <a href="{{ route('index') }}" class="logo-light">
                                <img src="{{asset('user-assets/images/logo-dark.svg')}}" alt="">
                            </a>
                            <a href="{{ route('index') }}" class="logo-dark">
                                <img src="{{asset('user-assets/images/logo-light.svg')}}" alt="">
                            </a>
                        </div>
                    </center>
                </div>
                <div class="authcard card" style="z-index: 9999;">
                    {{-- <div class="card-header">{{ __('Login') }}</div> --}}

                    <div class="card-body">
                        <form method="POST" action="{{ route('login') }}">
                            @csrf

                            <div class="row mb-1">

                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="email"
                                            class=" col-form-label text-md-end">{{ __('Email Address') }}</label>

                                        <input id="email" type="email"
                                            class="form-control @error('email') is-invalid @enderror" name="email"
                                            value="{{ old('email') }}" required autocomplete="email" autofocus>
                                    </div>

                                    @error('email')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="row mb-1">

                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="password"
                                            class="col-form-label text-md-end">{{ __('Password') }}</label>

                                        <input id="password" type="password"
                                            class="form-control @error('password') is-invalid @enderror" name="password"
                                            required autocomplete="current-password">
                                        @if (Route::has('password.request'))
                                            <a class="btn-link" href="{{ route('password.request') }}"
                                                style="font-size:12px;position: relative;
                                        top: 8px;">
                                                {{ __('Forgot Your Password?') }}
                                            </a>
                                        @endif
                                    </div>

                                    @error('password')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="row mb-1">
                                <div class="col-md-12 ">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="remember" id="remember"
                                            {{ old('remember') ? 'checked' : '' }}>

                                        <label class="form-check-label" for="remember">
                                            {{ __('Remember Me') }}
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <div class="row mb-1">
                                <div class="col-md-12">
                                    <button type="submit" class="btn btn-primary" style="width: 100%;font-size:0.7rem">
                                        {{ __('Login') }}
                                    </button>
                                </div>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="row mt-1">
                    <div class="col-md-12">

                        <p style="text-align:center">{{ __('OR') }}</p>

                    </div>
                </div>
                <div class="row mb-1">
                    <div class="col-md-12">
                        <a href="{{ url('auth/google') }}" class="btn btn-default"
                            style="width: 100%;font-size:0.7rem;background:#fff;color:#183354; border:1px solid; border-color:#183354">
                            <svg aria-hidden="true" class="native svg-icon iconGoogle" width="18" height="18"
                                viewBox="0 0 18 18">
                                <path fill="#4285F4"
                                    d="M16.51 8H8.98v3h4.3c-.18 1-.74 1.48-1.6 2.04v2.01h2.6a7.8 7.8 0 0 0 2.38-5.88c0-.57-.05-.66-.15-1.18Z">
                                </path>
                                <path fill="#34A853"
                                    d="M8.98 17c2.16 0 3.97-.72 5.3-1.94l-2.6-2a4.8 4.8 0 0 1-7.18-2.54H1.83v2.07A8 8 0 0 0 8.98 17Z">
                                </path>
                                <path fill="#FBBC05"
                                    d="M4.5 10.52a4.8 4.8 0 0 1 0-3.04V5.41H1.83a8 8 0 0 0 0 7.18l2.67-2.07Z">
                                </path>
                                <path fill="#EA4335"
                                    d="M8.98 4.18c1.17 0 2.23.4 3.06 1.2l2.3-2.3A8 8 0 0 0 1.83 5.4L4.5 7.49a4.77 4.77 0 0 1 4.48-3.3Z">
                                </path>
                            </svg>
                            Log in with Google
                        </a>
                    </div>
                </div>
                <!--<div class="row mb-1">-->
                <!--    <div class="col-md-12">-->
                <!--        <a href="{{ route('auth.facebook') }}" type="button" class="btn btn-default fbbtn"-->
                <!--            style="width: 100%;background:#385499;font-size:0.7rem;">-->
                <!--            <svg aria-hidden="true" class="svg-icon iconFacebook" width="18" height="18"-->
                <!--                viewBox="0 0 18 18">-->
                <!--                <path fill="#fff"-->
                <!--                    d="M3 1a2 2 0 0 0-2 2v12c0 1.1.9 2 2 2h12a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2H3Zm6.55 16v-6.2H7.46V8.4h2.09V6.61c0-2.07 1.26-3.2 3.1-3.2.88 0 1.64.07 1.87.1v2.16h-1.29c-1 0-1.19.48-1.19 1.18V8.4h2.39l-.31 2.42h-2.08V17h-2.5Z">-->
                <!--                </path>-->
                <!--            </svg>-->
                <!--            Log in with Facebook-->
                <!--        </a>-->
                <!--    </div>-->
                <!--</div>-->
                <div class="row mt-2">
                    <div class="col-md-12">
                        <p style="font-size:14px;text:align:center">Don't have an account?
                            <a href="{{ route('register') }}">Register here</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
