@extends('admin.layouts.app')
@section('content')
    <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12">
            <div class="card">
                <div class="header">
                    <h2><strong>Add </strong> new User</h2>
                    
                </div>
                <div class="mt-2">
                    @include('admin.layouts.partials.messages')
                </div>
                <div class="body">
                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <strong>Whoops!</strong> There were some problems with your input.<br><br>
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form method="POST" action="{{ route('users.store') }}" autocomplete="off">
                        @csrf
                        <label for="name">Name</label>
                        <div class="form-group">
                            <input type="text" id="name" class="form-control" placeholder="Enter User Name"
                                value="{{ old('name') }}" name="name" required>
                            @if ($errors->has('name'))
                                <span class="text-danger text-left">{{ $errors->first('name') }}</span>
                            @endif
                        </div>
                        <label for="email">Email</label>
                        <div class="form-group">
                            <input type="email" id="email" class="form-control" placeholder="Enter User Email"
                                value="{{ old('email') }}" name="email" required>
                            @if ($errors->has('email'))
                                <span class="text-danger text-left">{{ $errors->first('email') }}</span>
                            @endif
                        </div>
                        <label for="password">Password</label>
                        <div class="form-group">
                            <input type="password" id="password" class="form-control" placeholder="Enter User Password"
                                name="password" required>
                            @if ($errors->has('password'))
                                <span class="text-danger text-left">{{ $errors->first('password') }}</span>
                            @endif
                        </div>
                        <button type="submit" class="btn btn-raised btn-primary  waves-effect">Save</button>
                        <a href="{{ route('users.index') }}" class="btn btn-default">Back</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

