@extends('admin.layouts.app')
@section('custom-styles')
    <!-- Bootstrap Select Css -->
    <link href="{{ asset('admin-assets/css/bootstrap-select.css') }}" rel="stylesheet" />
@endsection
@section('content')
    <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12">
            <div class="card">
                <div class="header">
                    <h2><strong>Add </strong> new Store</h2>

                </div>
                <div class="mt-2">
                    @include('admin.layouts.partials.messages')
                </div>
                <div class="body">
                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <strong>Whoops!</strong> There were some problems with your input.<br><br>
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form method="POST" action="{{ route('stores.store') }}" autocomplete="off"
                        enctype="multipart/form-data">
                        @csrf
                        <label for="name">Name</label>
                        <div class="form-group">
                            <input type="text" id="name" class="form-control" placeholder="Enter Store Name"
                                name="name" value="{{ old('name') }}" required>
                            @if ($errors->has('name'))
                                <span class="text-danger">{{ $errors->first('name') }}</span>
                            @endif
                        </div>
                        <label class="form-label">Category</label>
                        <select class="form-control show-tick" name="category_id">
                            <option value="">--select Category--</option>
                            @foreach ($categories as $key => $category)
                            <option value="{{ $key}}">{{ $category }}</option>
                            @endforeach
                        </select>
                        <label class="form-label">Event</label>
                        <select class="form-control show-tick" name="event_id">
                            <option value="">--select Event--</option>
                            @foreach ($events as $key => $event)
                            <option value="{{ $key}}">{{ $event }}</option>
                            @endforeach
                        </select>
                        <label for="url">Url</label>
                        <div class="form-group">
                            <input type="text" id="url" class="form-control" placeholder="Enter Store Url"
                                name="url" value="{{ old('url') }}">
                            @if ($errors->has('url'))
                                <span class="text-danger">{{ $errors->first('url') }}</span>
                            @endif
                        </div>
                        <label for="description">Description</label>
                        <div class="form-group">
                            <textarea id="description" class="form-control" name="description" placeholder="Entere Store Description"></textarea>
                            @if ($errors->has('description'))
                                <span class="text-danger">{{ $errors->first('description') }}</span>
                            @endif
                        </div>
                        <label for="blog_description">Blog Description</label>
                        <div class="form-group">
                            <textarea id="blog_description" class="form-control" name="blog_description" placeholder="Entere Blog Description"></textarea>
                            @if ($errors->has('blog_description'))
                                <span class="text-danger">{{ $errors->first('blog_description') }}</span>
                            @endif
                        </div>
                        <label for="meta_title">Meta Title</label>
                        <div class="form-group">
                            <input type="text" id="meta_title" class="form-control" placeholder="Enter Meta Title"
                                name="meta_title" value="{{ old('meta_title') }}">
                            @if ($errors->has('meta_title'))
                                <span class="text-danger">{{ $errors->first('meta_title') }}</span>
                            @endif
                        </div>
                        <label for="meta_description">Meta Description</label>
                        <div class="form-group">
                            <textarea id="meta_description" class="form-control" name="meta_description" placeholder="Entere Meta Description"></textarea>
                            @if ($errors->has('meta_description'))
                                <span class="text-danger">{{ $errors->first('meta_description') }}</span>
                            @endif
                        </div>
                        <label for="feature_image">Feature Image</label>
                        <div class="form-group">
                            <input type="file" id="feature_image" class="form-control" name="featured_image">

                        </div>

                        <button type="submit" class="btn btn-raised btn-primary  waves-effect">Save</button>
                        <a href="{{ route('stores.index') }}" class="btn btn-default">Back</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
