@extends('admin.layouts.app')
@section('custom-styles')
    <!-- Bootstrap Select Css -->
    <link href="{{ asset('admin-assets/css/bootstrap-select.css') }}" rel="stylesheet" />
    <!-- Colorpicker Css -->
@endsection
@section('content')

    <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12">
            <div class="card">
                <div class="header">
                    <h2><strong>Theme </strong>Settings</h2>

                </div>
                <div class="mt-2">
                    @include('admin.layouts.partials.messages')
                </div>
                <div class="body">
                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <strong>Whoops!</strong> There were some problems with your input.<br><br>
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form method="POST"
                        action="@if ($themesettings) {{ route('update.theme.settings') }}@else {{ route('store.theme.settings') }} @endif"
                        enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" value="@if ($themesettings) {{ $themesettings->id }} @endif"
                            name="id">
                        <div class="row">
                            <div class="col-12">
                                <label class="form-label">Header Type</label>
                                <select name="header_type" class="form-control header_type">
                                    @if ($themesettings)
                                        <option value="{{ $themesettings->header_type }}">{{ $themesettings->header_type }}
                                        </option>
                                    @endif
                                    <option value="">--Select Type--</option>
                                    <option value="single-color">Single Color</option>
                                    <option value="gradient-color">Gradient Color</option>
                                    <option value="image">Image</option>
                                </select>
                            </div>
                        </div>
                        <br>
                        <div class="row header-single-color" style="display:none">
                            <div class="col-12 ">
                                <label class="form-label">Header Single Color</label>
                                <div class="input-group colorpicker">
                                    <input type="text" class="form-control" name="header_single_color"
                                        value="@if ($themesettings) {{ $themesettings->header_single_color }} @endif">
                                    <span class="input-group-addon"> <i></i> </span>
                                </div>

                            </div>
                        </div>
                        <div class="row header-gradient-color" style="display:none">
                            <div class="col-12">
                                <div class="row">
                                    <div class="col-4">
                                        <label class="form-label">Header Gradient Color 1</label>
                                        <div class="input-group colorpicker">
                                            <input type="text" class="form-control" name="header_gradient_color1"
                                                value="@if ($themesettings) {{ $themesettings->header_gradient_color1 }} @endif">
                                            <span class="input-group-addon"> <i></i> </span>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <label class="form-label">Header Gradient Color 2</label>
                                        <div class="input-group colorpicker">
                                            <input type="text" class="form-control" name="header_gradient_color2"
                                                value="@if ($themesettings) {{ $themesettings->header_gradient_color2 }} @endif">
                                            <span class="input-group-addon"> <i></i> </span>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <label class="form-label">Header Gradient Direction</label>
                                        <select name="header_gradient_direction" class="form-control">
                                            @if ($themesettings)
                                                <option value="{{ $themesettings->header_gradient_direction }}">
                                                    {{ $themesettings->header_gradient_direction }}</option>
                                            @endif
                                            <option value="">--Select Direction--</option>
                                            <option value="to top">to top</option>
                                            <option value="to bottom">to bottom</option>
                                            <option value="to right">to right</option>
                                            <option value="to left">to left</option>
                                            <option value="to top right">to top right</option>
                                            <option value="to bottom right">to bottom right</option>
                                            <option value="to top left">to top left</option>
                                            <option value="to bottom left">to bottom left</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row header-image" style="display:none">
                            <div class="col-12">
                                <label class="form-label">Header Image</label>
                                <input type="file" class="form-control" name="header_image">
                            </div>
                            <br>
                            <div class="col-12">
                                <img src="@if ($themesettings) {{ asset('admin-assets/images/theme') }}/{{ $themesettings->header_image }} @endif"
                                    alt="" style="width:100%; height:200px">
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-12">
                                <label class="form-label">Footer Type</label>
                                <select name="footer_type" class="form-control footer_type">
                                    @if ($themesettings)
                                        <option value="{{ $themesettings->footer_type }}">
                                            {{ $themesettings->footer_type }}</option>
                                    @endif
                                    <option value="">--Select Type--</option>
                                    <option value="single-color">Single Color</option>
                                    <option value="gradient-color">Gradient Color</option>
                                    <option value="image">Image</option>
                                </select>
                            </div>
                        </div>
                        <br>
                        <div class="row footer-single-color" style="display:none">
                            <div class="col-12 ">
                                <label class="form-label">Footer Single Color</label>
                                <div class="input-group colorpicker">
                                    <input type="text" class="form-control" name="footer_single_color"
                                        value="@if ($themesettings) {{ $themesettings->footer_single_color }} @endif">
                                    <span class="input-group-addon"> <i></i> </span>
                                </div>
                            </div>
                        </div>
                        <div class="row footer-gradient-color" style="display:none">
                            <div class="col-12">
                                <div class="row">
                                    <div class="col-4">
                                        <label class="form-label">Footer Gradient Color 1</label>
                                        <div class="input-group colorpicker">
                                            <input type="text" class="form-control" name="footer_gradient_color1"
                                                value="@if ($themesettings) {{ $themesettings->footer_gradient_color1 }} @endif">
                                            <span class="input-group-addon"> <i></i> </span>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <label class="form-label">Footer Gradient Color 2</label>
                                        <div class="input-group colorpicker">
                                            <input type="text" class="form-control" name="footer_gradient_color2"
                                                value="@if ($themesettings) {{ $themesettings->footer_gradient_color2 }} @endif">
                                            <span class="input-group-addon"> <i></i> </span>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <label class="form-label">Footer Gradient Direction</label>
                                        <select name="footer_gradient_direction" class="form-control">
                                            @if ($themesettings)
                                                <option value="{{ $themesettings->footer_gradient_direction }}">
                                                    {{ $themesettings->footer_gradient_direction }}</option>
                                            @endif
                                            <option value="">--Select Direction--</option>
                                            <option value="to top">to top</option>
                                            <option value="to bottom">to bottom</option>
                                            <option value="to right">to right</option>
                                            <option value="to left">to left</option>
                                            <option value="to top right">to top right</option>
                                            <option value="to bottom right">to bottom right</option>
                                            <option value="to top left">to top left</option>
                                            <option value="to bottom left">to bottom left</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row footer-image" style="display:none">
                            <div class="col-12">
                                <label class="form-label">Footer Image</label>
                                <input type="file" class="form-control" name="footer_image">
                            </div>
                            <br>

                            <div class="col-12">
                                <img src="@if ($themesettings) {{ asset('admin-assets/images/theme') }}/{{ $themesettings->footer_image }} @endif"
                                    alt="" style="width:100%; height:200px">
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-12">
                                <label class="form-label">Login Type</label>
                                <select name="login_type" class="form-control login_type">
                                    @if ($themesettings)
                                        <option value="{{ $themesettings->login_type }}">
                                            {{ $themesettings->login_type }}
                                        </option>
                                    @endif
                                    <option value="">--Select Type--</option>
                                    <option value="single-color">Single Color</option>
                                    <option value="gradient-color">Gradient Color</option>
                                    <option value="image">Image</option>
                                </select>
                            </div>
                        </div>
                        <br>
                        <div class="row login-single-color"style="display:none">
                            <div class="col-12 ">
                                <label class="form-label">Login Single Color</label>
                                <div class="input-group colorpicker">
                                    <input type="text" class="form-control" name="login_single_color"
                                        value="@if ($themesettings) {{ $themesettings->login_single_color }} @endif">
                                    <span class="input-group-addon"> <i></i> </span>
                                </div>
                            </div>
                        </div>
                        <div class="row login-gradient-color" style="display:none">
                            <div class="col-12">
                                <div class="row">
                                    <div class="col-4">
                                        <label class="form-label">Login Gradient Color 1</label>
                                        <div class="input-group colorpicker">
                                            <input type="text" class="form-control" name="login_gradient_color1"
                                                value="@if ($themesettings) {{ $themesettings->login_gradient_color1 }} @endif">
                                            <span class="input-group-addon"> <i></i> </span>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <label class="form-label">Login Gradient Color 2</label>
                                        <div class="input-group colorpicker">
                                            <input type="text" class="form-control" name="login_gradient_color2"
                                                value="@if ($themesettings) {{ $themesettings->login_gradient_color2 }} @endif">
                                            <span class="input-group-addon"> <i></i> </span>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <label class="form-label">Login Gradient Direction</label>
                                        <select name="login_gradient_direction" class="form-control">
                                            @if ($themesettings)
                                                <option value="{{ $themesettings->login_gradient_direction }}">
                                                    {{ $themesettings->login_gradient_direction }}</option>
                                            @endif
                                            <option value="">--Select Direction--</option>
                                            <option value="to top">to top</option>
                                            <option value="to bottom">to bottom</option>
                                            <option value="to right">to right</option>
                                            <option value="to left">to left</option>
                                            <option value="to top right">to top right</option>
                                            <option value="to bottom right">to bottom right</option>
                                            <option value="to top left">to top left</option>
                                            <option value="to bottom left">to bottom left</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row login-image" style="display:none">
                            <div class="col-12">
                                <label class="form-label">Login Image</label>
                                <input type="file" class="form-control" name="login_image">
                            </div>
                            <br>

                            <div class="col-12">
                                <img src="@if ($themesettings) {{ asset('admin-assets/images/theme') }}/{{ $themesettings->login_image }} @endif"
                                    alt="" style="width:100%; height:200px">
                            </div>
                        </div>
                        <br>
                        <div class="col-12">
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('custom-scripts')
    <script src="{{ asset('admin-assets/js/bootstrap-colorpicker.js')}}"></script> <!-- Bootstrap Colorpicker Js -->
    
    <script>
       $('.colorpicker').colorpicker();   
        $(document).ready(function() {
            var header_type = $('.header_type').val();

            if (header_type == 'single-color') {
                $('.header-single-color').css('display', 'block');
                $('.header-gradient-color').css('display', 'none');
                $('.header-image').css('display', 'none');
            } else if (header_type == 'gradient-color') {
                $('.header-single-color').css('display', 'none');
                $('.header-gradient-color').css('display', 'block');
                $('.header-image').css('display', 'none');
            } else if (header_type == 'image') {
                $('.header-single-color').css('display', 'none');
                $('.header-gradient-color').css('display', 'none');
                $('.header-image').css('display', 'block');
            }

            var footer_type = $('.footer_type').val();
            if (footer_type == 'single-color') {
                $('.footer-single-color').css('display', 'block');
                $('.footer-gradient-color').css('display', 'none');
                $('.footer-image').css('display', 'none');
            } else if (footer_type == 'gradient-color') {
                $('.footer-single-color').css('display', 'none');
                $('.footer-gradient-color').css('display', 'block');
                $('.footer-image').css('display', 'none');
            } else if (footer_type == 'image') {
                $('.footer-single-color').css('display', 'none');
                $('.footer-gradient-color').css('display', 'none');
                $('.footer-image').css('display', 'block');
            }


            var login_type = $('.login_type').val();
            if (login_type == 'single-color') {
                $('.login-single-color').css('display', 'block');
                $('.login-gradient-color').css('display', 'none');
                $('.login-image').css('display', 'none');
            } else if (login_type == 'gradient-color') {
                $('.login-single-color').css('display', 'none');
                $('.login-gradient-color').css('display', 'block');
                $('.login-image').css('display', 'none');
            } else if (login_type == 'image') {
                $('.login-single-color').css('display', 'none');
                $('.login-gradient-color').css('display', 'none');
                $('.login-image').css('display', 'block');
            }
        });
        $(document).on('change', '.header_type', function() {
            var header_type = $(this).val();
            console.log(header_type);
            if (header_type == 'single-color') {
                $('.header-single-color').css('display', 'block');
                $('.header-gradient-color').css('display', 'none');
                $('.header-image').css('display', 'none');
            } else if (header_type == 'gradient-color') {
                $('.header-single-color').css('display', 'none');
                $('.header-gradient-color').css('display', 'block');
                $('.header-image').css('display', 'none');
            } else if (header_type == 'image') {
                $('.header-single-color').css('display', 'none');
                $('.header-gradient-color').css('display', 'none');
                $('.header-image').css('display', 'block');
            }
        });
        $(document).on('change', '.footer_type', function() {
            var footer_type = $(this).val();
            if (footer_type == 'single-color') {
                $('.footer-single-color').css('display', 'block');
                $('.footer-gradient-color').css('display', 'none');
                $('.footer-image').css('display', 'none');
            } else if (footer_type == 'gradient-color') {
                $('.footer-single-color').css('display', 'none');
                $('.footer-gradient-color').css('display', 'block');
                $('.footer-image').css('display', 'none');
            } else if (footer_type == 'image') {
                $('.footer-single-color').css('display', 'none');
                $('.footer-gradient-color').css('display', 'none');
                $('.footer-image').css('display', 'block');
            }
        });

        $(document).on('change', '.login_type', function() {
            var login_type = $(this).val();
            if (login_type == 'single-color') {
                $('.login-single-color').css('display', 'block');
                $('.login-gradient-color').css('display', 'none');
                $('.login-image').css('display', 'none');
            } else if (login_type == 'gradient-color') {
                $('.login-single-color').css('display', 'none');
                $('.login-gradient-color').css('display', 'block');
                $('.login-image').css('display', 'none');
            } else if (login_type == 'image') {
                $('.login-single-color').css('display', 'none');
                $('.login-gradient-color').css('display', 'none');
                $('.login-image').css('display', 'block');
            }
        });
    </script>
    
@endsection
