@extends('admin.layouts.app')

@section('content')
    <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12">
            <div class="card">
                <div class="header">
                    <h2><strong>Social </strong>Media</h2>
<ul class="header-dropdown">
                        <li class="dropdown">
                            <a href="{{ route('add.social.media') }}" class="btn btn-primary btn-sm float-right">Add
                                Social Media</a>
                        </li>
                    </ul>
                </div>
                <div class="mt-2">
                    @include('admin.layouts.partials.messages')
                </div>
                <div class="body">
                     <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover js-basic-example dataTable">

                            <thead>
                                <tr>
                                    <th>Title</th>
                                    <th>Url</th>
                                    <th>Actions</th>

                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($socialmedia as $row)
                                    <tr>
                                        <td>{{ $row->title }}</td>
                                        <td>{{ $row->url }}</td>
                                        <td>
                                            <a class="btn btn-primary btn-sm"
                                                href="{{ route('social.media.edit', $row->id) }}">Edit</a>

                                            {!! Form::open([
                                                'method' => 'DELETE',
                                                'route' => ['social.media.destroy', $row->id],
                                                'style' => 'display:inline',
                                            ]) !!}
                                            {!! Form::submit('Delete', ['class' => 'btn btn-danger btn-sm']) !!}
                                            {!! Form::close() !!}
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>

                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
