@extends('admin.layouts.app')
@section('custom-styles')
    <!-- Bootstrap Select Css -->
    <link href="{{ asset('admin-assets/css/bootstrap-select.css') }}" rel="stylesheet" />
@endsection
@section('content')

    <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12">
            <div class="card">
                <div class="header">
                    <h2><strong>Social </strong>Media</h2>

                </div>
                <div class="mt-2">
                    @include('admin.layouts.partials.messages')
                </div>
                <div class="body">
                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <strong>Whoops!</strong> There were some problems with your input.<br><br>
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form method="POST"
                        action="@if ($querysettings) {{ route('update.query.settings') }}@else {{ route('store.query.settings') }} @endif"
                        enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" value="@if ($querysettings) {{ $querysettings->id }} @endif"
                            name="id">
                        <div class="row">
                            <div class="col-6">
                                <label class="form-label">Home Page Stores</label>
                                <select name="homepage_stores" class="form-control homepage_stores">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->homepage_stores }}">
                                            {{ $querysettings->homepage_stores }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 homepage_stores_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="homepage_stores_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->homepage_stores_limit }}" @endif>
                                    </div>
                                    <div class="col-6 homepage_stores_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="homepage_stores_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->homepage_stores_orderby_key1 }}">
                                                    {{ $querysettings->homepage_stores_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 homepage_stores_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="homepage_stores_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->homepage_stores_orderby_key2 }}">
                                                    {{ $querysettings->homepage_stores_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <label class="form-label">Home Page Coupons</label>
                                <select name="homepage_coupons" class="form-control homepage_coupons">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->homepage_coupons }}">
                                            {{ $querysettings->homepage_coupons }}</option>
                                    @endif
                                    <option value="">-- Select --</option>

                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 homepage_coupons_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="homepage_coupons_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->homepage_coupons_limit }}" @endif>
                                    </div>
                                    <div class="col-6 homepage_coupons_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="homepage_coupons_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->homepage_coupons_orderby_key1 }}">
                                                    {{ $querysettings->homepage_coupons_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 homepage_coupons_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="homepage_coupons_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->homepage_coupons_orderby_key2 }}">
                                                    {{ $querysettings->homepage_coupons_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-6">
                                <label class="form-label">Home Page Categories</label>
                                <select name="homepage_categories" class="form-control homepage_categories">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->homepage_categories }}">
                                            {{ $querysettings->homepage_categories }}</option>
                                    @endif

                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 homepage_categories_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="homepage_categories_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->homepage_categories_limit }}" @endif>
                                    </div>
                                    <div class="col-6 homepage_categories_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="homepage_categories_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->homepage_categories_orderby_key1 }}">
                                                    {{ $querysettings->homepage_categories_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 homepage_categories_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="homepage_categories_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->homepage_categories_orderby_key2 }}">
                                                    {{ $querysettings->homepage_categories_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <label class="form-label">Home Page Blogs</label>
                                <select name="homepage_blogs" class="form-control homepage_blogs">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->homepage_blogs }}">
                                            {{ $querysettings->homepage_blogs }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 homepage_blogs_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="homepage_blogs_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->homepage_blogs_limit }}" @endif>
                                    </div>
                                    <div class="col-6 homepage_blogs_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="homepage_blogs_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->homepage_blogs_orderby_key1 }}">
                                                    {{ $querysettings->homepage_blogs_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 homepage_blogs_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="homepage_blogs_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->homepage_blogs_orderby_key2 }}">
                                                    {{ $querysettings->homepage_blogs_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <h6 class="mb-0 text-uppercase">Store Page Settings</h6>

                        <br>
                        <div class="row">
                            <div class="col-6">
                                <label class="form-label">Store Page Stores</label>
                                <select name="storepage_stores" class="form-control storepage_stores">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->storepage_stores }}">
                                            {{ $querysettings->storepage_stores }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="paginate()">paginate()</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 storepage_stores_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="storepage_stores_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->storepage_stores_limit }}" @endif>
                                    </div>
                                    <div class="col-6 storepage_stores_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="storepage_stores_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->storepage_stores_orderby_key1 }}">
                                                    {{ $querysettings->storepage_stores_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="name">name</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 storepage_stores_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="storepage_stores_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->storepage_stores_orderby_key2 }}">
                                                    {{ $querysettings->storepage_stores_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <label class="form-label">Store Page Coupons</label>
                                <select name="storepage_coupons" class="form-control storepage_coupons">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->storepage_coupons }}">
                                            {{ $querysettings->storepage_coupons }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 storepage_coupons_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="storepage_coupons_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->storepage_coupons_limit }}" @endif>
                                    </div>
                                    <div class="col-6 storepage_coupons_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="storepage_coupons_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->storepage_coupons_orderby_key1 }}">
                                                    {{ $querysettings->storepage_coupons_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 storepage_coupons_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="storepage_coupons_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->storepage_coupons_orderby_key2 }}">
                                                    {{ $querysettings->storepage_coupons_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-6">
                                <label class="form-label">Store Page Categories</label>
                                <select name="storepage_categories" class="form-control storepage_categories">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->storepage_categories }}">
                                            {{ $querysettings->storepage_categories }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 storepage_categories_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="storepage_categories_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->storepage_categories_limit }}" @endif>
                                    </div>
                                    <div class="col-6 storepage_categories_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="storepage_categories_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->storepage_categories_orderby_key1 }}">
                                                    {{ $querysettings->storepage_categories_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 storepage_categories_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="storepage_categories_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->storepage_categories_orderby_key2 }}">
                                                    {{ $querysettings->storepage_categories_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <label class="form-label">Store Page Blogs</label>
                                <select name="storepage_blogs" class="form-control storepage_blogs">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->storepage_blogs }}">
                                            {{ $querysettings->storepage_blogs }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 storepage_blogs_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="storepage_blogs_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->storepage_blogs_limit }}" @endif>
                                    </div>
                                    <div class="col-6 storepage_blogs_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="storepage_blogs_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->storepage_blogs_orderby_key1 }}">
                                                    {{ $querysettings->storepage_blogs_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 storepage_blogs_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="storepage_blogs_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->storepage_blogs_orderby_key2 }}">
                                                    {{ $querysettings->storepage_blogs_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <h6 class="mb-0 text-uppercase">Category Page Settings</h6>
                        <br>
                        <div class="row">
                            <div class="col-6">
                                <label class="form-label">Category Page Stores</label>
                                <select name="categorypage_stores" class="form-control categorypage_stores">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->categorypage_stores }}">
                                            {{ $querysettings->categorypage_stores }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 categorypage_stores_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="categorypage_stores_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->categorypage_stores_limit }}" @endif>
                                    </div>
                                    <div class="col-6 categorypage_stores_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="categorypage_stores_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->categorypage_stores_orderby_key1 }}">
                                                    {{ $querysettings->categorypage_stores_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 categorypage_stores_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="categorypage_stores_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->categorypage_stores_orderby_key2 }}">
                                                    {{ $querysettings->categorypage_stores_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <label class="form-label">Category Page Coupons</label>
                                <select name="categorypage_coupons" class="form-control categorypage_coupons">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->categorypage_coupons }}">
                                            {{ $querysettings->categorypage_coupons }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 categorypage_coupons_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="categorypage_coupons_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->categorypage_coupons_limit }}" @endif>
                                    </div>
                                    <div class="col-6 categorypage_coupons_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="categorypage_coupons_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->categorypage_coupons_orderby_key1 }}">
                                                    {{ $querysettings->categorypage_coupons_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 categorypage_coupons_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="categorypage_coupons_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->categorypage_coupons_orderby_key2 }}">
                                                    {{ $querysettings->categorypage_coupons_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <br>
                        <div class="row">
                            <div class="col-6">
                                <label class="form-label">Category Page Categories</label>
                                <select name="categorypage_categories" class="form-control categorypage_categories">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->categorypage_categories }}">
                                            {{ $querysettings->categorypage_categories }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="paginate()">paginate()</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 categorypage_categories_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="categorypage_categories_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->categorypage_categories_limit }}" @endif>
                                    </div>
                                    <div class="col-6 categorypage_categories_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="categorypage_categories_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->categorypage_categories_orderby_key1 }}">
                                                    {{ $querysettings->categorypage_categories_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 categorypage_categories_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="categorypage_categories_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->categorypage_categories_orderby_key2 }}">
                                                    {{ $querysettings->categorypage_categories_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <label class="form-label">Category Page Blogs</label>
                                <select name="categorypage_blogs" class="form-control categorypage_blogs">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->categorypage_blogs }}">
                                            {{ $querysettings->categorypage_blogs }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 categorypage_blogs_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="categorypage_blogs_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->categorypage_blogs_limit }}" @endif>
                                    </div>
                                    <div class="col-6 categorypage_blogs_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="categorypage_blogs_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->categorypage_blogs_orderby_key1 }}">
                                                    {{ $querysettings->categorypage_blogs_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 categorypage_blogs_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="categorypage_blogs_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->categorypage_blogs_orderby_key2 }}">
                                                    {{ $querysettings->categorypage_blogs_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <h6 class="mb-0 text-uppercase">Blog Page Settings</h6>
                        <br>
                        <div class="row">
                            <div class="col-6">
                                <label class="form-label">Blog Page Stores</label>
                                <select name="blogpage_stores" class="form-control blogpage_stores">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->blogpage_stores }}">
                                            {{ $querysettings->blogpage_stores }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 blogpage_stores_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="blogpage_stores_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->blogpage_stores_limit }}" @endif>
                                    </div>
                                    <div class="col-6 blogpage_stores_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="blogpage_stores_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->blogpage_stores_orderby_key1 }}">
                                                    {{ $querysettings->blogpage_stores_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 blogpage_stores_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="blogpage_stores_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->blogpage_stores_orderby_key2 }}">
                                                    {{ $querysettings->blogpage_stores_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <label class="form-label">Blog Page Coupons</label>
                                <select name="blogpage_coupons" class="form-control blogpage_coupons">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->blogpage_coupons }}">
                                            {{ $querysettings->blogpage_coupons }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 blogpage_coupons_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="blogpage_coupons_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->blogpage_coupons_limit }}" @endif>
                                    </div>
                                    <div class="col-6 blogpage_coupons_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="blogpage_coupons_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->blogpage_coupons_orderby_key1 }}">
                                                    {{ $querysettings->blogpage_coupons_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 blogpage_coupons_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="blogpage_coupons_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->blogpage_coupons_orderby_key2 }}">
                                                    {{ $querysettings->blogpage_coupons_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-6">
                                <label class="form-label">Blog Page Categories</label>
                                <select name="blogpage_categories" class="form-control blogpage_categories">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->blogpage_categories }}">
                                            {{ $querysettings->blogpage_categories }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 blogpage_categories_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="blogpage_categories_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->blogpage_categories_limit }}" @endif>
                                    </div>
                                    <div class="col-6 blogpage_categories_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="blogpage_categories_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->blogpage_categories_orderby_key1 }}">
                                                    {{ $querysettings->blogpage_categories_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 blogpage_categories_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="blogpage_categories_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->blogpage_categories_orderby_key2 }}">
                                                    {{ $querysettings->blogpage_categories_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <label class="form-label">Blog Page Blogs</label>
                                <select name="blogpage_blogs" class="form-control blogpage_blogs">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->blogpage_blogs }}">
                                            {{ $querysettings->blogpage_blogs }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="paginate()">paginate()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 blogpage_blogs_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="blogpage_blogs_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->blogpage_blogs_limit }}" @endif>
                                    </div>
                                    <div class="col-6 blogpage_blogs_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="blogpage_blogs_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->blogpage_blogs_orderby_key1 }}">
                                                    {{ $querysettings->blogpage_blogs_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 blogpage_blogs_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="blogpage_blogs_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->blogpage_blogs_orderby_key2 }}">
                                                    {{ $querysettings->blogpage_blogs_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <h6 class="mb-0 text-uppercase">Event Page Settings</h6>
                        <br>
                        <div class="row">
                            <div class="col-6">
                                <label class="form-label">Event Page Stores</label>
                                <select name="eventpage_stores" class="form-control eventpage_stores">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->eventpage_stores }}">
                                            {{ $querysettings->eventpage_stores }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 eventpage_stores_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="eventpage_stores_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->eventpage_stores_limit }}" @endif>
                                    </div>
                                    <div class="col-6 eventpage_stores_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="eventpage_stores_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->eventpage_stores_orderby_key1 }}">
                                                    {{ $querysettings->eventpage_stores_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 eventpage_stores_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="eventpage_stores_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->eventpage_stores_orderby_key2 }}">
                                                    {{ $querysettings->eventpage_stores_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <label class="form-label">Event Page Coupons</label>
                                <select name="eventpage_coupons" class="form-control eventpage_coupons">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->eventpage_coupons }}">
                                            {{ $querysettings->eventpage_coupons }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 eventpage_coupons_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="eventpage_coupons_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->eventpage_coupons_limit }}" @endif>
                                    </div>
                                    <div class="col-6 eventpage_coupons_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="eventpage_coupons_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->eventpage_coupons_orderby_key1 }}">
                                                    {{ $querysettings->eventpage_coupons_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 eventpage_coupons_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="eventpage_coupons_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->eventpage_coupons_orderby_key2 }}">
                                                    {{ $querysettings->eventpage_coupons_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <br>
                        <div class="row">
                            <div class="col-6">
                                <label class="form-label">Event Page Categories</label>
                                <select name="eventpage_categories" class="form-control eventpage_categories">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->eventpage_categories }}">
                                            {{ $querysettings->eventpage_categories }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 eventpage_categories_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="eventpage_categories_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->eventpage_categories_limit }}" @endif>
                                    </div>
                                    <div class="col-6 eventpage_categories_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="eventpage_categories_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->eventpage_categories_orderby_key1 }}">
                                                    {{ $querysettings->eventpage_categories_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 eventpage_categories_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="eventpage_categories_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->eventpage_categories_orderby_key2 }}">
                                                    {{ $querysettings->eventpage_categories_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <label class="form-label">Event Page Blogs</label>
                                <select name="eventpage_blogs" class="form-control eventpage_blogs">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->eventpage_blogs }}">
                                            {{ $querysettings->eventpage_blogs }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 eventpage_blogs_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="eventpage_blogs_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->eventpage_blogs_limit }}" @endif>
                                    </div>
                                    <div class="col-6 eventpage_blogs_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="eventpage_blogs_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->eventpage_blogs_orderby_key1 }}">
                                                    {{ $querysettings->eventpage_blogs_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 eventpage_blogs_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="eventpage_blogs_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->eventpage_blogs_orderby_key2 }}">
                                                    {{ $querysettings->eventpage_blogs_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <h6 class="mb-0 text-uppercase">Store Profile Page Settings</h6>
                        <br>
                        <div class="row">
                            <div class="col-6">
                                <label class="form-label">Store Profile Page Stores</label>
                                <select name="storeprofilepage_stores" class="form-control storeprofilepage_stores">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->storeprofilepage_stores }}">
                                            {{ $querysettings->storeprofilepage_stores }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 storeprofilepage_stores_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="storeprofilepage_stores_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->storeprofilepage_stores_limit }}" @endif>
                                    </div>
                                    <div class="col-6 storeprofilepage_stores_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="storeprofilepage_stores_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->storeprofilepage_stores_orderby_key1 }}">
                                                    {{ $querysettings->storeprofilepage_stores_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 storeprofilepage_stores_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="storeprofilepage_stores_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->storeprofilepage_stores_orderby_key2 }}">
                                                    {{ $querysettings->storeprofilepage_stores_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <label class="form-label">Store Profile Page Coupons</label>
                                <select name="storeprofilepage_coupons" class="form-control storeprofilepage_coupons">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->storeprofilepage_coupons }}">
                                            {{ $querysettings->storeprofilepage_coupons }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 storeprofilepage_coupons_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="storeprofilepage_coupons_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->storeprofilepage_coupons_limit }}" @endif>
                                    </div>
                                    <div class="col-6 storeprofilepage_coupons_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="storeprofilepage_coupons_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->storeprofilepage_coupons_orderby_key1 }}">
                                                    {{ $querysettings->storeprofilepage_coupons_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                            <option value="sorting_order">sorting_order</option>
                                        </select>
                                    </div>
                                    <div class="col-6 storeprofilepage_coupons_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="storeprofilepage_coupons_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->storeprofilepage_coupons_orderby_key2 }}">
                                                    {{ $querysettings->storeprofilepage_coupons_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-6">
                                <label class="form-label">Store Profile Page Categories</label>
                                <select name="storeprofilepage_categories"
                                    class="form-control storeprofilepage_categories">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->storeprofilepage_categories }}">
                                            {{ $querysettings->storeprofilepage_categories }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 storeprofilepage_categories_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="storeprofilepage_categories_limit"
                                            class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->storeprofilepage_categories_limit }}" @endif>
                                    </div>
                                    <div class="col-6 storeprofilepage_categories_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="storeprofilepage_categories_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->storeprofilepage_categories_orderby_key1 }}">
                                                    {{ $querysettings->storeprofilepage_categories_orderby_key1 }}
                                                </option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 storeprofilepage_categories_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="storeprofilepage_categories_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->storeprofilepage_categories_orderby_key2 }}">
                                                    {{ $querysettings->storeprofilepage_categories_orderby_key2 }}
                                                </option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <label class="form-label">Store Profile Page Blogs</label>
                                <select name="storeprofilepage_blogs" class="form-control storeprofilepage_blogs">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->storeprofilepage_blogs }}">
                                            {{ $querysettings->storeprofilepage_blogs }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 storeprofilepage_blogs_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="storeprofilepage_blogs_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->storeprofilepage_blogs_limit }}" @endif>
                                    </div>
                                    <div class="col-6 storeprofilepage_blogs_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="storeprofilepage_blogs_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->storeprofilepage_blogs_orderby_key1 }}">
                                                    {{ $querysettings->storeprofilepage_blogs_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 storeprofilepage_blogs_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="storeprofilepage_blogs_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->storeprofilepage_blogs_orderby_key2 }}">
                                                    {{ $querysettings->storeprofilepage_blogs_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <h6 class="mb-0 text-uppercase">Category Profile Page Settings</h6>
                        <br>
                        <div class="row">
                            <div class="col-6">
                                <label class="form-label">Category Profile Page Stores</label>
                                <select name="categoryprofilepage_stores" class="form-control categoryprofilepage_stores">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->categoryprofilepage_stores }}">
                                            {{ $querysettings->categoryprofilepage_stores }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 categoryprofilepage_stores_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="categoryprofilepage_stores_limit"
                                            class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->categoryprofilepage_stores_limit }}" @endif>
                                    </div>
                                    <div class="col-6 categoryprofilepage_stores_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="categoryprofilepage_stores_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->categoryprofilepage_stores_orderby_key1 }}">
                                                    {{ $querysettings->categoryprofilepage_stores_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 categoryprofilepage_stores_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="categoryprofilepage_stores_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->categoryprofilepage_stores_orderby_key2 }}">
                                                    {{ $querysettings->categoryprofilepage_stores_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <label class="form-label">Category Profile Page Coupons</label>
                                <select name="categoryprofilepage_coupons"
                                    class="form-control categoryprofilepage_coupons">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->categoryprofilepage_coupons }}">
                                            {{ $querysettings->categoryprofilepage_coupons }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 categoryprofilepage_coupons_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="categoryprofilepage_coupons_limit"
                                            class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->categoryprofilepage_coupons_limit }}" @endif>
                                    </div>
                                    <div class="col-6 categoryprofilepage_coupons_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="categoryprofilepage_coupons_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->categoryprofilepage_coupons_orderby_key1 }}">
                                                    {{ $querysettings->categoryprofilepage_coupons_orderby_key1 }}
                                                </option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 categoryprofilepage_coupons_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="categoryprofilepage_coupons_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->categoryprofilepage_coupons_orderby_key2 }}">
                                                    {{ $querysettings->categoryprofilepage_coupons_orderby_key2 }}
                                                </option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-6">
                                <label class="form-label">Category Profile Page Categories</label>
                                <select name="categoryprofilepage_categories"
                                    class="form-control categoryprofilepage_categories">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->categoryprofilepage_categories }}">
                                            {{ $querysettings->categoryprofilepage_categories }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 categoryprofilepage_categories_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="categoryprofilepage_categories_limit"
                                            class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->categoryprofilepage_categories_limit }}" @endif>
                                    </div>
                                    <div class="col-6 categoryprofilepage_categories_orderby_key1"
                                        style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="categoryprofilepage_categories_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->categoryprofilepage_categories_orderby_key1 }}">
                                                    {{ $querysettings->categoryprofilepage_categories_orderby_key1 }}
                                                </option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 categoryprofilepage_categories_orderby_key2"
                                        style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="categoryprofilepage_categories_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->categoryprofilepage_categories_orderby_key2 }}">
                                                    {{ $querysettings->categoryprofilepage_categories_orderby_key2 }}
                                                </option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <label class="form-label">Category Profile Page Blogs</label>
                                <select name="categoryprofilepage_blogs" class="form-control categoryprofilepage_blogs">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->categoryprofilepage_blogs }}">
                                            {{ $querysettings->categoryprofilepage_blogs }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 categoryprofilepage_blogs_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="categoryprofilepage_blogs_limit"
                                            class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->categoryprofilepage_blogs_limit }}" @endif>
                                    </div>
                                    <div class="col-6 categoryprofilepage_blogs_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="categoryprofilepage_blogs_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->categoryprofilepage_blogs_orderby_key1 }}">
                                                    {{ $querysettings->categoryprofilepage_blogs_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 categoryprofilepage_blogs_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="categoryprofilepage_blogs_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->categoryprofilepage_blogs_orderby_key2 }}">
                                                    {{ $querysettings->categoryprofilepage_blogs_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <h6 class="mb-0 text-uppercase">Blog Profile Page Settings</h6>
                        <br>
                        <div class="row">
                            <div class="col-6">
                                <label class="form-label">Blog Profile Page Stores</label>
                                <select name="blogprofilepage_stores" class="form-control blogprofilepage_stores">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->blogprofilepage_stores }}">
                                            {{ $querysettings->blogprofilepage_stores }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 blogprofilepage_stores_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="blogprofilepage_stores_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->blogprofilepage_stores_limit }}" @endif>
                                    </div>
                                    <div class="col-6 blogprofilepage_stores_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="blogprofilepage_stores_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->blogprofilepage_stores_orderby_key1 }}">
                                                    {{ $querysettings->blogprofilepage_stores_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 blogprofilepage_stores_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="blogprofilepage_stores_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->blogprofilepage_stores_orderby_key2 }}">
                                                    {{ $querysettings->blogprofilepage_stores_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <label class="form-label">Blog Profile Page Coupons</label>
                                <select name="blogprofilepage_coupons" class="form-control blogprofilepage_coupons">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->blogprofilepage_coupons }}">
                                            {{ $querysettings->blogprofilepage_coupons }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 blogprofilepage_coupons_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="blogprofilepage_coupons_limit"
                                            class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->blogprofilepage_coupons_limit }}" @endif>
                                    </div>
                                    <div class="col-6 blogprofilepage_coupons_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="blogprofilepage_coupons_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->blogprofilepage_coupons_orderby_key1 }}">
                                                    {{ $querysettings->blogprofilepage_coupons_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 blogprofilepage_coupons_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="blogprofilepage_coupons_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->blogprofilepage_coupons_orderby_key2 }}">
                                                    {{ $querysettings->blogprofilepage_coupons_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <br>
                        <div class="row">
                            <div class="col-6">
                                <label class="form-label">Blog Profile Page Categories</label>
                                <select name="blogprofilepage_categories"
                                    class="form-control blogprofilepage_categories">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->blogprofilepage_categories }}">
                                            {{ $querysettings->blogprofilepage_categories }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 blogprofilepage_categories_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="blogprofilepage_categories_limit"
                                            class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->blogprofilepage_categories_limit }}" @endif>
                                    </div>
                                    <div class="col-6 blogprofilepage_categories_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="blogprofilepage_categories_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->blogprofilepage_categories_orderby_key1 }}">
                                                    {{ $querysettings->blogprofilepage_categories_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 blogprofilepage_categories_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="blogprofilepage_categories_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->blogprofilepage_categories_orderby_key2 }}">
                                                    {{ $querysettings->blogprofilepage_categories_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <label class="form-label">Blog Profile Page Blogs</label>
                                <select name="blogprofilepage_blogs" class="form-control blogprofilepage_blogs">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->blogprofilepage_blogs }}">
                                            {{ $querysettings->blogprofilepage_blogs }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 blogprofilepage_blogs_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="blogprofilepage_blogs_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->blogprofilepage_blogs_limit }}" @endif>
                                    </div>
                                    <div class="col-6 blogprofilepage_blogs_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="blogprofilepage_blogs_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->blogprofilepage_blogs_orderby_key1 }}">
                                                    {{ $querysettings->blogprofilepage_blogs_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 blogprofilepage_blogs_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="blogprofilepage_blogs_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->blogprofilepage_blogs_orderby_key2 }}">
                                                    {{ $querysettings->blogprofilepage_blogs_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <h6 class="mb-0 text-uppercase">Event Profile Page Settings</h6>
                        <br>
                        <div class="row">
                            <div class="col-6">
                                <label class="form-label">Event Profile Page Stores</label>
                                <select name="eventprofilepage_stores" class="form-control eventprofilepage_stores">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->eventprofilepage_stores }}">
                                            {{ $querysettings->eventprofilepage_stores }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 eventprofilepage_stores_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="eventprofilepage_stores_limit"
                                            class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->eventprofilepage_stores_limit }}" @endif>
                                    </div>
                                    <div class="col-6 eventprofilepage_stores_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="eventprofilepage_stores_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->eventprofilepage_stores_orderby_key1 }}">
                                                    {{ $querysettings->eventprofilepage_stores_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 eventprofilepage_stores_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="eventprofilepage_stores_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->eventprofilepage_stores_orderby_key2 }}">
                                                    {{ $querysettings->eventprofilepage_stores_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <label class="form-label">Event Profile Page Coupons</label>
                                <select name="eventprofilepage_coupons" class="form-control eventprofilepage_coupons">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->eventprofilepage_coupons }}">
                                            {{ $querysettings->eventprofilepage_coupons }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 eventprofilepage_coupons_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="eventprofilepage_coupons_limit"
                                            class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->eventprofilepage_coupons_limit }}" @endif>
                                    </div>
                                    <div class="col-6 eventprofilepage_coupons_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="eventprofilepage_coupons_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->eventprofilepage_coupons_orderby_key1 }}">
                                                    {{ $querysettings->eventprofilepage_coupons_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 eventprofilepage_coupons_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="eventprofilepage_coupons_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->eventprofilepage_coupons_orderby_key2 }}">
                                                    {{ $querysettings->eventprofilepage_coupons_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <br>
                        <div class="row">
                            <div class="col-6">
                                <label class="form-label">Event Profile Page Categories</label>
                                <select name="eventprofilepage_categories"
                                    class="form-control eventprofilepage_categories">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->eventprofilepage_categories }}">
                                            {{ $querysettings->eventprofilepage_categories }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 eventprofilepage_categories_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="eventprofilepage_categories_limit"
                                            class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->eventprofilepage_categories_limit }}" @endif>
                                    </div>
                                    <div class="col-6 eventprofilepage_categories_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="eventprofilepage_categories_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->eventprofilepage_categories_orderby_key1 }}">
                                                    {{ $querysettings->eventprofilepage_categories_orderby_key1 }}
                                                </option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 eventprofilepage_categories_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="eventprofilepage_categories_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->eventprofilepage_categories_orderby_key2 }}">
                                                    {{ $querysettings->eventprofilepage_categories_orderby_key2 }}
                                                </option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <label class="form-label">Event Profile Page Blogs</label>
                                <select name="eventprofilepage_blogs" class="form-control eventprofilepage_blogs">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->eventprofilepage_blogs }}">
                                            {{ $querysettings->eventprofilepage_blogs }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 eventprofilepage_blogs_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="eventprofilepage_blogs_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->eventprofilepage_blogs_limit }}" @endif>
                                    </div>
                                    <div class="col-6 eventprofilepage_blogs_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="eventprofilepage_blogs_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->eventprofilepage_blogs_orderby_key1 }}">
                                                    {{ $querysettings->eventprofilepage_blogs_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 eventprofilepage_blogs_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="eventprofilepage_blogs_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option
                                                    value="{{ $querysettings->eventprofilepage_blogs_orderby_key2 }}">
                                                    {{ $querysettings->eventprofilepage_blogs_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <h6 class="mb-0 text-uppercase">Footer Settings</h6>
                        <br>
                        <div class="row">
                            <div class="col-6">
                                <label class="form-label">Footer Stores</label>
                                <select name="footer_stores" class="form-control footer_stores">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->footer_stores }}">
                                            {{ $querysettings->footer_stores }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 footer_stores_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="footer_stores_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->footer_stores_limit }}" @endif>
                                    </div>
                                    <div class="col-6 footer_stores_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="footer_stores_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->footer_stores_orderby_key1 }}">
                                                    {{ $querysettings->footer_stores_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 footer_stores_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="footer_stores_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->footer_stores_orderby_key2 }}">
                                                    {{ $querysettings->footer_stores_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <label class="form-label">Footer Categories</label>
                                <select name="footer_categories" class="form-control footer_categories">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->footer_categories }}">
                                            {{ $querysettings->footer_categories }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 footer_categories_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="footer_categories_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->footer_categories_limit }}" @endif>
                                    </div>
                                    <div class="col-6 footer_categories_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="footer_categories_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->footer_categories_orderby_key1 }}">
                                                    {{ $querysettings->footer_categories_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 footer_categories_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="footer_categories_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->footer_categories_orderby_key2 }}">
                                                    {{ $querysettings->footer_categories_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <br>
                        <div class="row">

                            <div class="col-6">
                                <label class="form-label">Footer Blogs</label>
                                <select name="footer_blogs" class="form-control footer_blogs">
                                    @if ($querysettings)
                                        <option value="{{ $querysettings->footer_blogs }}">
                                            {{ $querysettings->footer_blogs }}</option>
                                    @endif
                                    <option value="">-- Select --</option>
                                    <option value="limit()">limit()</option>
                                    <option value="inRandomOrder()">inRandomOrder()</option>
                                    <option value="inRandomOrder()->limit()">inRandomOrder()->limit()</option>
                                    <option value="Orderby()">Orderby()</option>
                                    <option value="Orderby()->limit()">Orderby()->limit()</option>
                                </select>
                                <br>
                                <div class="row">
                                    <div class="col-6 footer_blogs_limit" style="display: none">
                                        <label class="form-label">Limit</label>
                                        <input type="text" name="footer_blogs_limit" class="form-control"
                                            @if ($querysettings) value="{{ $querysettings->footer_categories_limit }}" @endif>
                                    </div>
                                    <div class="col-6 footer_blogs_orderby_key1" style="display: none">
                                        <label class="form-label">Orderby Param 1</label>
                                        <select name="footer_blogs_orderby_key1" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->footer_blogs_orderby_key1 }}">
                                                    {{ $querysettings->footer_blogs_orderby_key1 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="id">id</option>
                                            <option value="created_at">created_at</option>
                                            <option value="updated_at">updated_at</option>
                                        </select>
                                    </div>
                                    <div class="col-6 footer_blogs_orderby_key2" style="display: none">
                                        <label class="form-label">Orderby Param 2</label>
                                        <select name="footer_blogs_orderby_key2" class="form-control">
                                            @if ($querysettings)
                                                <option value="{{ $querysettings->footer_blogs_orderby_key2 }}">
                                                    {{ $querysettings->footer_blogs_orderby_key2 }}</option>
                                            @endif
                                            <option value="">--Select--</option>
                                            <option value="asc">asc</option>
                                            <option value="desc">desc</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <br>
                        <div class="col-12">
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">Save</button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
@endsection
@section('custom-scripts')
    <script>
        $(document).ready(function() {
            //homepage settings
            var homepage_stores = $('.homepage_stores').val();
            console.log(homepage_stores);
            if (homepage_stores == 'limit()' || homepage_stores == 'inRandomOrder()->limit()') {
                $('.homepage_stores_limit').css('display', 'block');
                $('.homepage_stores_orderby_key1').css('display', 'none');
                $('.homepage_stores_orderby_key2').css('display', 'none');
            } else if (homepage_stores == 'inRandomOrder()') {
                $('.homepage_stores_limit').css('display', 'none');
                $('.homepage_stores_orderby_key1').css('display', 'none');
                $('.homepage_stores_orderby_key2').css('display', 'none');
            } else if (homepage_stores == 'Orderby()') {
                $('.homepage_stores_limit').css('display', 'none');
                $('.homepage_stores_orderby_key1').css('display', 'block');
                $('.homepage_stores_orderby_key2').css('display', 'block');
            } else if (homepage_stores == 'Orderby()->limit()') {
                $('.homepage_stores_limit').css('display', 'block');
                $('.homepage_stores_orderby_key1').css('display', 'block');
                $('.homepage_stores_orderby_key2').css('display', 'block');
            }

            var homepage_coupons = $('.homepage_coupons').val();
            if (homepage_coupons == 'limit()' || homepage_coupons == 'inRandomOrder()->limit()') {
                $('.homepage_coupons_limit').css('display', 'block');
                $('.homepage_coupons_orderby_key1').css('display', 'none');
                $('.homepage_coupons_orderby_key2').css('display', 'none');
            } else if (homepage_coupons == 'inRandomOrder()') {
                $('.homepage_coupons_limit').css('display', 'none');
                $('.homepage_coupons_orderby_key1').css('display', 'none');
                $('.homepage_coupons_orderby_key2').css('display', 'none');
            } else if (homepage_coupons == 'Orderby()') {
                $('.homepage_coupons_limit').css('display', 'none');
                $('.homepage_coupons_orderby_key1').css('display', 'block');
                $('.homepage_coupons_orderby_key2').css('display', 'block');
            } else if (homepage_coupons == 'Orderby()->limit()') {
                $('.homepage_coupons_limit').css('display', 'block');
                $('.homepage_coupons_orderby_key1').css('display', 'block');
                $('.homepage_coupons_orderby_key2').css('display', 'block');
            }

            var homepage_categories = $('.homepage_categories').val();
            console.log(homepage_categories);
            if (homepage_categories == 'limit()' || homepage_categories == 'inRandomOrder()->limit()') {
                $('.homepage_categories_limit').css('display', 'block');
                $('.homepage_categories_orderby_key1').css('display', 'none');
                $('.homepage_categories_orderby_key2').css('display', 'none');
            } else if (homepage_categories == 'inRandomOrder()') {
                $('.homepage_categories_limit').css('display', 'none');
                $('.homepage_categories_orderby_key1').css('display', 'none');
                $('.homepage_categories_orderby_key2').css('display', 'none');
            } else if (homepage_categories == 'Orderby()') {
                $('.homepage_categories_limit').css('display', 'none');
                $('.homepage_categories_orderby_key1').css('display', 'block');
                $('.homepage_categories_orderby_key2').css('display', 'block');
            } else if (homepage_categories == 'Orderby()->limit()') {
                $('.homepage_categories_limit').css('display', 'block');
                $('.homepage_categories_orderby_key1').css('display', 'block');
                $('.homepage_categories_orderby_key2').css('display', 'block');
            }

            var homepage_blogs = $('.homepage_blogs').val();
            if (homepage_blogs == 'limit()' || homepage_blogs == 'inRandomOrder()->limit()') {
                $('.homepage_blogs_limit').css('display', 'block');
                $('.homepage_blogs_orderby_key1').css('display', 'none');
                $('.homepage_blogs_orderby_key2').css('display', 'none');
            } else if (homepage_blogs == 'inRandomOrder()') {
                $('.homepage_blogs_limit').css('display', 'none');
                $('.homepage_blogs_orderby_key1').css('display', 'none');
                $('.homepage_blogs_orderby_key2').css('display', 'none');
            } else if (homepage_blogs == 'Orderby()') {
                $('.homepage_blogs_limit').css('display', 'none');
                $('.homepage_blogs_orderby_key1').css('display', 'block');
                $('.homepage_blogs_orderby_key2').css('display', 'block');
            } else if (homepage_blogs == 'Orderby()->limit()') {
                $('.homepage_blogs_limit').css('display', 'block');
                $('.homepage_blogs_orderby_key1').css('display', 'block');
                $('.homepage_blogs_orderby_key2').css('display', 'block');
            }

            //storepage settings

            var storepage_stores = $('.storepage_stores').val();
            console.log(storepage_stores);
            if (storepage_stores == 'paginate()' || storepage_stores == 'limit()' || storepage_stores ==
                'inRandomOrder()->limit()') {
                $('.storepage_stores_limit').css('display', 'block');
                $('.storepage_stores_orderby_key1').css('display', 'none');
                $('.storepage_stores_orderby_key2').css('display', 'none');
            } else if (storepage_stores == 'inRandomOrder()') {
                $('.storepage_stores_limit').css('display', 'none');
                $('.storepage_stores_orderby_key1').css('display', 'none');
                $('.storepage_stores_orderby_key2').css('display', 'none');
            } else if (storepage_stores == 'Orderby()') {
                $('.storepage_stores_limit').css('display', 'none');
                $('.storepage_stores_orderby_key1').css('display', 'block');
                $('.storepage_stores_orderby_key2').css('display', 'block');
            } else if (storepage_stores == 'Orderby()->limit()') {
                $('.storepage_stores_limit').css('display', 'block');
                $('.storepage_stores_orderby_key1').css('display', 'block');
                $('.storepage_stores_orderby_key2').css('display', 'block');
            }

            var storepage_coupons = $('.storepage_coupons').val();
            if (storepage_coupons == 'limit()' || storepage_coupons == 'inRandomOrder()->limit()') {
                $('.storepage_coupons_limit').css('display', 'block');
                $('.storepage_coupons_orderby_key1').css('display', 'none');
                $('.storepage_coupons_orderby_key2').css('display', 'none');
            } else if (storepage_coupons == 'inRandomOrder()') {
                $('.storepage_coupons_limit').css('display', 'none');
                $('.storepage_coupons_orderby_key1').css('display', 'none');
                $('.storepage_coupons_orderby_key2').css('display', 'none');
            } else if (storepage_coupons == 'Orderby()') {
                $('.storepage_coupons_limit').css('display', 'none');
                $('.storepage_coupons_orderby_key1').css('display', 'block');
                $('.storepage_coupons_orderby_key2').css('display', 'block');
            } else if (storepage_coupons == 'Orderby()->limit()') {
                $('.storepage_coupons_limit').css('display', 'block');
                $('.storepage_coupons_orderby_key1').css('display', 'block');
                $('.storepage_coupons_orderby_key2').css('display', 'block');
            }

            var storepage_categories = $('.storepage_categories').val();
            console.log(storepage_categories);
            if (storepage_categories == 'limit()' || storepage_categories == 'inRandomOrder()->limit()') {
                $('.storepage_categories_limit').css('display', 'block');
                $('.storepage_categories_orderby_key1').css('display', 'none');
                $('.storepage_categories_orderby_key2').css('display', 'none');
            } else if (storepage_categories == 'inRandomOrder()') {
                $('.storepage_categories_limit').css('display', 'none');
                $('.storepage_categories_orderby_key1').css('display', 'none');
                $('.storepage_categories_orderby_key2').css('display', 'none');
            } else if (storepage_categories == 'Orderby()') {
                $('.storepage_categories_limit').css('display', 'none');
                $('.storepage_categories_orderby_key1').css('display', 'block');
                $('.storepage_categories_orderby_key2').css('display', 'block');
            } else if (storepage_categories == 'Orderby()->limit()') {
                $('.storepage_categories_limit').css('display', 'block');
                $('.storepage_categories_orderby_key1').css('display', 'block');
                $('.storepage_categories_orderby_key2').css('display', 'block');
            }

            var storepage_blogs = $('.storepage_blogs').val();
            if (storepage_blogs == 'limit()' || storepage_blogs == 'inRandomOrder()->limit()') {
                $('.storepage_blogs_limit').css('display', 'block');
                $('.storepage_blogs_orderby_key1').css('display', 'none');
                $('.storepage_blogs_orderby_key2').css('display', 'none');
            } else if (storepage_blogs == 'inRandomOrder()') {
                $('.storepage_blogs_limit').css('display', 'none');
                $('.storepage_blogs_orderby_key1').css('display', 'none');
                $('.storepage_blogs_orderby_key2').css('display', 'none');
            } else if (storepage_blogs == 'Orderby()') {
                $('.storepage_blogs_limit').css('display', 'none');
                $('.storepage_blogs_orderby_key1').css('display', 'block');
                $('.storepage_blogs_orderby_key2').css('display', 'block');
            } else if (storepage_blogs == 'Orderby()->limit()') {
                $('.storepage_blogs_limit').css('display', 'block');
                $('.storepage_blogs_orderby_key1').css('display', 'block');
                $('.storepage_blogs_orderby_key2').css('display', 'block');
            }

            //categorypage settings

            var categorypage_stores = $('.categorypage_stores').val();
            console.log(categorypage_stores);
            if (categorypage_stores == 'limit()' || categorypage_stores == 'inRandomOrder()->limit()') {
                $('.categorypage_stores_limit').css('display', 'block');
                $('.categorypage_stores_orderby_key1').css('display', 'none');
                $('.categorypage_stores_orderby_key2').css('display', 'none');
            } else if (categorypage_stores == 'inRandomOrder()') {
                $('.categorypage_stores_limit').css('display', 'none');
                $('.categorypage_stores_orderby_key1').css('display', 'none');
                $('.categorypage_stores_orderby_key2').css('display', 'none');
            } else if (categorypage_stores == 'Orderby()') {
                $('.categorypage_stores_limit').css('display', 'none');
                $('.categorypage_stores_orderby_key1').css('display', 'block');
                $('.categorypage_stores_orderby_key2').css('display', 'block');
            } else if (categorypage_stores == 'Orderby()->limit()') {
                $('.categorypage_stores_limit').css('display', 'block');
                $('.categorypage_stores_orderby_key1').css('display', 'block');
                $('.categorypage_stores_orderby_key2').css('display', 'block');
            }

            var categorypage_coupons = $('.categorypage_coupons').val();
            if (categorypage_coupons == 'limit()' || categorypage_coupons == 'inRandomOrder()->limit()') {
                $('.categorypage_coupons_limit').css('display', 'block');
                $('.categorypage_coupons_orderby_key1').css('display', 'none');
                $('.categorypage_coupons_orderby_key2').css('display', 'none');
            } else if (categorypage_coupons == 'inRandomOrder()') {
                $('.categorypage_coupons_limit').css('display', 'none');
                $('.categorypage_coupons_orderby_key1').css('display', 'none');
                $('.categorypage_coupons_orderby_key2').css('display', 'none');
            } else if (categorypage_coupons == 'Orderby()') {
                $('.categorypage_coupons_limit').css('display', 'none');
                $('.categorypage_coupons_orderby_key1').css('display', 'block');
                $('.categorypage_coupons_orderby_key2').css('display', 'block');
            } else if (categorypage_coupons == 'Orderby()->limit()') {
                $('.categorypage_coupons_limit').css('display', 'block');
                $('.categorypage_coupons_orderby_key1').css('display', 'block');
                $('.categorypage_coupons_orderby_key2').css('display', 'block');
            }

            var categorypage_categories = $('.categorypage_categories').val();
            console.log(categorypage_categories);
            if (categorypage_categories == 'paginate()' || categorypage_categories == 'limit()' ||
                categorypage_categories == 'inRandomOrder()->limit()') {
                $('.categorypage_categories_limit').css('display', 'block');
                $('.categorypage_categories_orderby_key1').css('display', 'none');
                $('.categorypage_categories_orderby_key2').css('display', 'none');
            } else if (categorypage_categories == 'inRandomOrder()') {
                $('.categorypage_categories_limit').css('display', 'none');
                $('.categorypage_categories_orderby_key1').css('display', 'none');
                $('.categorypage_categories_orderby_key2').css('display', 'none');
            } else if (categorypage_categories == 'Orderby()') {
                $('.categorypage_categories_limit').css('display', 'none');
                $('.categorypage_categories_orderby_key1').css('display', 'block');
                $('.categorypage_categories_orderby_key2').css('display', 'block');
            } else if (categorypage_categories == 'Orderby()->limit()') {
                $('.categorypage_categories_limit').css('display', 'block');
                $('.categorypage_categories_orderby_key1').css('display', 'block');
                $('.categorypage_categories_orderby_key2').css('display', 'block');
            }

            var categorypage_blogs = $('.categorypage_blogs').val();
            if (categorypage_blogs == 'limit()' || categorypage_blogs == 'inRandomOrder()->limit()') {
                $('.categorypage_blogs_limit').css('display', 'block');
                $('.categorypage_blogs_orderby_key1').css('display', 'none');
                $('.categorypage_blogs_orderby_key2').css('display', 'none');
            } else if (categorypage_blogs == 'inRandomOrder()') {
                $('.categorypage_blogs_limit').css('display', 'none');
                $('.categorypage_blogs_orderby_key1').css('display', 'none');
                $('.categorypage_blogs_orderby_key2').css('display', 'none');
            } else if (categorypage_blogs == 'Orderby()') {
                $('.categorypage_blogs_limit').css('display', 'none');
                $('.categorypage_blogs_orderby_key1').css('display', 'block');
                $('.categorypage_blogs_orderby_key2').css('display', 'block');
            } else if (categorypage_blogs == 'Orderby()->limit()') {
                $('.categorypage_blogs_limit').css('display', 'block');
                $('.categorypage_blogs_orderby_key1').css('display', 'block');
                $('.categorypage_blogs_orderby_key2').css('display', 'block');
            }

            //blogpage settings

            var blogpage_stores = $('.blogpage_stores').val();
            console.log(blogpage_stores);
            if (blogpage_stores == 'limit()' || blogpage_stores == 'inRandomOrder()->limit()') {
                $('.blogpage_stores_limit').css('display', 'block');
                $('.blogpage_stores_orderby_key1').css('display', 'none');
                $('.blogpage_stores_orderby_key2').css('display', 'none');
            } else if (blogpage_stores == 'inRandomOrder()') {
                $('.blogpage_stores_limit').css('display', 'none');
                $('.blogpage_stores_orderby_key1').css('display', 'none');
                $('.blogpage_stores_orderby_key2').css('display', 'none');
            } else if (blogpage_stores == 'Orderby()') {
                $('.blogpage_stores_limit').css('display', 'none');
                $('.blogpage_stores_orderby_key1').css('display', 'block');
                $('.blogpage_stores_orderby_key2').css('display', 'block');
            } else if (blogpage_stores == 'Orderby()->limit()') {
                $('.blogpage_stores_limit').css('display', 'block');
                $('.blogpage_stores_orderby_key1').css('display', 'block');
                $('.blogpage_stores_orderby_key2').css('display', 'block');
            }

            var blogpage_coupons = $('.blogpage_coupons').val();
            if (blogpage_coupons == 'limit()' || blogpage_coupons == 'inRandomOrder()->limit()') {
                $('.blogpage_coupons_limit').css('display', 'block');
                $('.blogpage_coupons_orderby_key1').css('display', 'none');
                $('.blogpage_coupons_orderby_key2').css('display', 'none');
            } else if (blogpage_coupons == 'inRandomOrder()') {
                $('.blogpage_coupons_limit').css('display', 'none');
                $('.blogpage_coupons_orderby_key1').css('display', 'none');
                $('.blogpage_coupons_orderby_key2').css('display', 'none');
            } else if (blogpage_coupons == 'Orderby()') {
                $('.blogpage_coupons_limit').css('display', 'none');
                $('.blogpage_coupons_orderby_key1').css('display', 'block');
                $('.blogpage_coupons_orderby_key2').css('display', 'block');
            } else if (blogpage_coupons == 'Orderby()->limit()') {
                $('.blogpage_coupons_limit').css('display', 'block');
                $('.blogpage_coupons_orderby_key1').css('display', 'block');
                $('.blogpage_coupons_orderby_key2').css('display', 'block');
            }

            var blogpage_categories = $('.blogpage_categories').val();
            console.log(blogpage_categories);
            if (blogpage_categories == 'limit()' || blogpage_categories == 'inRandomOrder()->limit()') {
                $('.blogpage_categories_limit').css('display', 'block');
                $('.blogpage_categories_orderby_key1').css('display', 'none');
                $('.blogpage_categories_orderby_key2').css('display', 'none');
            } else if (blogpage_categories == 'inRandomOrder()') {
                $('.blogpage_categories_limit').css('display', 'none');
                $('.blogpage_categories_orderby_key1').css('display', 'none');
                $('.blogpage_categories_orderby_key2').css('display', 'none');
            } else if (blogpage_categories == 'Orderby()') {
                $('.blogpage_categories_limit').css('display', 'none');
                $('.blogpage_categories_orderby_key1').css('display', 'block');
                $('.blogpage_categories_orderby_key2').css('display', 'block');
            } else if (blogpage_categories == 'Orderby()->limit()') {
                $('.blogpage_categories_limit').css('display', 'block');
                $('.blogpage_categories_orderby_key1').css('display', 'block');
                $('.blogpage_categories_orderby_key2').css('display', 'block');
            }

            var blogpage_blogs = $('.blogpage_blogs').val();
            if (blogpage_blogs == 'paginate()' || blogpage_blogs == 'limit()' || blogpage_blogs ==
                'inRandomOrder()->limit()') {
                $('.blogpage_blogs_limit').css('display', 'block');
                $('.blogpage_blogs_orderby_key1').css('display', 'none');
                $('.blogpage_blogs_orderby_key2').css('display', 'none');
            } else if (blogpage_blogs == 'inRandomOrder()') {
                $('.blogpage_blogs_limit').css('display', 'none');
                $('.blogpage_blogs_orderby_key1').css('display', 'none');
                $('.blogpage_blogs_orderby_key2').css('display', 'none');
            } else if (blogpage_blogs == 'Orderby()') {
                $('.blogpage_blogs_limit').css('display', 'none');
                $('.blogpage_blogs_orderby_key1').css('display', 'block');
                $('.blogpage_blogs_orderby_key2').css('display', 'block');
            } else if (blogpage_blogs == 'Orderby()->limit()') {
                $('.blogpage_blogs_limit').css('display', 'block');
                $('.blogpage_blogs_orderby_key1').css('display', 'block');
                $('.blogpage_blogs_orderby_key2').css('display', 'block');
            }

            //eventpage settings

            var eventpage_stores = $('.eventpage_stores').val();
            console.log(eventpage_stores);
            if (eventpage_stores == 'limit()' || eventpage_stores == 'inRandomOrder()->limit()') {
                $('.eventpage_stores_limit').css('display', 'block');
                $('.eventpage_stores_orderby_key1').css('display', 'none');
                $('.eventpage_stores_orderby_key2').css('display', 'none');
            } else if (eventpage_stores == 'inRandomOrder()') {
                $('.eventpage_stores_limit').css('display', 'none');
                $('.eventpage_storess_orderby_key1').css('display', 'none');
                $('.eventpage_stores_orderby_key2').css('display', 'none');
            } else if (eventpage_stores == 'Orderby()') {
                $('.eventpage_stores_limit').css('display', 'none');
                $('.eventpage_stores_orderby_key1').css('display', 'block');
                $('.eventpage_stores_orderby_key2').css('display', 'block');
            } else if (eventpage_stores == 'Orderby()->limit()') {
                $('.eventpage_stores_limit').css('display', 'block');
                $('.eventpage_stores_orderby_key1').css('display', 'block');
                $('.eventpage_stores_orderby_key2').css('display', 'block');
            }

            var eventpage_coupons = $('.eventpage_coupons').val();
            if (eventpage_coupons == 'limit()' || eventpage_coupons == 'inRandomOrder()->limit()') {
                $('.eventpage_coupons_limit').css('display', 'block');
                $('.eventpage_couponss_orderby_key1').css('display', 'none');
                $('.eventpage_coupons_orderby_key2').css('display', 'none');
            } else if (eventpage_coupons == 'inRandomOrder()') {
                $('.eventpage_coupons_limit').css('display', 'none');
                $('.eventpage_coupons_orderby_key1').css('display', 'none');
                $('.eventpage_coupons_orderby_key2').css('display', 'none');
            } else if (eventpage_coupons == 'Orderby()') {
                $('.eventpage_coupons_limit').css('display', 'none');
                $('.eventpage_coupons_orderby_key1').css('display', 'block');
                $('.eventpage_coupons_orderby_key2').css('display', 'block');
            } else if (eventpage_coupons == 'Orderby()->limit()') {
                $('.eventpage_coupons_limit').css('display', 'block');
                $('.eventpage_coupons_orderby_key1').css('display', 'block');
                $('.eventpage_coupons_orderby_key2').css('display', 'block');
            }

            var eventpage_categories = $('.eventpage_categories').val();
            console.log(eventpage_categories);
            if (eventpage_categories == 'limit()' || eventpage_categories == 'inRandomOrder()->limit()') {
                $('.eventpage_categories_limit').css('display', 'block');
                $('.eventpage_categories_orderby_key1').css('display', 'none');
                $('.eventpage_categories_orderby_key2').css('display', 'none');
            } else if (eventpage_categories == 'inRandomOrder()') {
                $('.eventpage_categories_limit').css('display', 'none');
                $('.eventpage_categories_orderby_key1').css('display', 'none');
                $('.eventpage_categories_orderby_key2').css('display', 'none');
            } else if (eventpage_categories == 'Orderby()') {
                $('.eventpage_categories_limit').css('display', 'none');
                $('.eventpage_categories_orderby_key1').css('display', 'block');
                $('.eventpage_categories_orderby_key2').css('display', 'block');
            } else if (eventpage_categories == 'Orderby()->limit()') {
                $('.eventpage_categories_limit').css('display', 'block');
                $('.eventpage_categories_orderby_key1').css('display', 'block');
                $('.eventpage_categories_orderby_key2').css('display', 'block');
            }

            var eventpage_blogs = $('.eventpage_blogs').val();
            if (eventpage_blogs == 'limit()' || eventpage_blogs == 'inRandomOrder()->limit()') {
                $('.eventpage_blogs_limit').css('display', 'block');
                $('.eventpage_blogs_orderby_key1').css('display', 'none');
                $('.eventpage_blogs_orderby_key2').css('display', 'none');
            } else if (eventpage_blogs == 'inRandomOrder()') {
                $('.eventpage_blogs_limit').css('display', 'none');
                $('.eventpage_blogs_orderby_key1').css('display', 'none');
                $('.eventpage_blogs_orderby_key2').css('display', 'none');
            } else if (eventpage_blogs == 'Orderby()') {
                $('.eventpage_blogs_limit').css('display', 'none');
                $('.eventpage_blogs_orderby_key1').css('display', 'block');
                $('.eventpage_blogs_orderby_key2').css('display', 'block');
            } else if (eventpage_blogs == 'Orderby()->limit()') {
                $('.eventpage_blogs_limit').css('display', 'block');
                $('.eventpage_blogs_orderby_key1').css('display', 'block');
                $('.eventpage_blogs_orderby_key2').css('display', 'block');
            }

            //store profile settings

            var storeprofilepage_stores = $('.storeprofilepage_stores').val();
            console.log(storeprofilepage_stores);
            if (storeprofilepage_stores == 'limit()' || storeprofilepage_stores == 'inRandomOrder()->limit()') {
                $('.storeprofilepage_stores_limit').css('display', 'block');
                $('.storeprofilepage_stores_orderby_key1').css('display', 'none');
                $('.storeprofilepage_stores_orderby_key2').css('display', 'none');
            } else if (storeprofilepage_stores == 'inRandomOrder()') {
                $('.storeprofilepage_stores_limit').css('display', 'none');
                $('.storeprofilepage_stores_orderby_key1').css('display', 'none');
                $('.storeprofilepage_stores_orderby_key2').css('display', 'none');
            } else if (storeprofilepage_stores == 'Orderby()') {
                $('.storeprofilepage_stores_limit').css('display', 'none');
                $('.storeprofilepage_stores_orderby_key1').css('display', 'block');
                $('.storeprofilepage_stores_orderby_key2').css('display', 'block');
            } else if (storeprofilepage_stores == 'Orderby()->limit()') {
                $('.storeprofilepage_stores_limit').css('display', 'block');
                $('.storeprofilepage_stores_orderby_key1').css('display', 'block');
                $('.storeprofilepage_stores_orderby_key2').css('display', 'block');
            }

            var storeprofilepage_coupons = $('.storeprofilepage_coupons').val();
            if (storeprofilepage_coupons == 'limit()' || storeprofilepage_coupons == 'inRandomOrder()->limit()') {
                $('.storeprofilepage_coupons_limit').css('display', 'block');
                $('.storeprofilepage_coupons_orderby_key1').css('display', 'none');
                $('.storeprofilepage_coupons_orderby_key2').css('display', 'none');
            } else if (storeprofilepage_coupons == 'inRandomOrder()') {
                $('.storeprofilepage_coupons_limit').css('display', 'none');
                $('.storeprofilepage_coupons_orderby_key1').css('display', 'none');
                $('.storeprofilepage_coupons_orderby_key2').css('display', 'none');
            } else if (storeprofilepage_coupons == 'Orderby()') {
                $('.storeprofilepage_coupons_limit').css('display', 'none');
                $('.storeprofilepage_coupons_orderby_key1').css('display', 'block');
                $('.storeprofilepage_coupons_orderby_key2').css('display', 'block');
            } else if (storeprofilepage_coupons == 'Orderby()->limit()') {
                $('.storeprofilepage_coupons_limit').css('display', 'block');
                $('.storeprofilepage_coupons_orderby_key1').css('display', 'block');
                $('.storeprofilepage_coupons_orderby_key2').css('display', 'block');
            }

            var storeprofilepage_categories = $('.storeprofilepage_categories').val();
            console.log(storeprofilepage_categories);
            if (storeprofilepage_categories == 'limit()' || storeprofilepage_categories ==
                'inRandomOrder()->limit()') {
                $('.storeprofilepage_categories_limit').css('display', 'block');
                $('.storeprofilepage_categories_orderby_key1').css('display', 'none');
                $('.storeprofilepage_categories_orderby_key2').css('display', 'none');
            } else if (storeprofilepage_categories == 'inRandomOrder()') {
                $('.storeprofilepage_categories_limit').css('display', 'none');
                $('.storeprofilepage_categories_orderby_key1').css('display', 'none');
                $('.storeprofilepage_categories_orderby_key2').css('display', 'none');
            } else if (storeprofilepage_categories == 'Orderby()') {
                $('.storeprofilepage_categories_limit').css('display', 'none');
                $('.storeprofilepage_categories_orderby_key1').css('display', 'block');
                $('.storeprofilepage_categories_orderby_key2').css('display', 'block');
            } else if (storeprofilepage_categories == 'Orderby()->limit()') {
                $('.storeprofilepage_categories_limit').css('display', 'block');
                $('.storeprofilepage_categories_orderby_key1').css('display', 'block');
                $('.storeprofilepage_categories_orderby_key2').css('display', 'block');
            }

            var storeprofilepage_blogs = $('.storeprofilepage_blogs').val();
            if (storeprofilepage_blogs == 'limit()' || storeprofilepage_blogs == 'inRandomOrder()->limit()') {
                $('.storeprofilepage_blogs_limit').css('display', 'block');
                $('.storeprofilepage_blogs_orderby_key1').css('display', 'none');
                $('.storeprofilepage_blogs_orderby_key2').css('display', 'none');
            } else if (storeprofilepage_blogs == 'inRandomOrder()') {
                $('.storeprofilepage_blogs_limit').css('display', 'none');
                $('.storeprofilepage_blogs_orderby_key1').css('display', 'none');
                $('.storeprofilepage_blogs_orderby_key2').css('display', 'none');
            } else if (storeprofilepage_blogs == 'Orderby()') {
                $('.storeprofilepage_blogs_limit').css('display', 'none');
                $('.storeprofilepage_blogs_orderby_key1').css('display', 'block');
                $('.storeprofilepage_blogs_orderby_key2').css('display', 'block');
            } else if (storeprofilepage_blogs == 'Orderby()->limit()') {
                $('.storeprofilepage_blogs_limit').css('display', 'block');
                $('.storeprofilepage_blogs_orderby_key1').css('display', 'block');
                $('.storeprofilepage_blogs_orderby_key2').css('display', 'block');
            }

            //category profile settings

            var categoryprofilepage_stores = $('.categoryprofilepage_stores').val();
            console.log(categoryprofilepage_stores);
            if (categoryprofilepage_stores == 'limit()' || categoryprofilepage_stores ==
                'inRandomOrder()->limit()') {
                $('.categoryprofilepage_stores_limit').css('display', 'block');
                $('.categoryprofilepage_stores_orderby_key1').css('display', 'none');
                $('.categoryprofilepage_stores_orderby_key2').css('display', 'none');
            } else if (categoryprofilepage_stores == 'inRandomOrder()') {
                $('.categoryprofilepage_stores_limit').css('display', 'none');
                $('.categoryprofilepage_stores_orderby_key1').css('display', 'none');
                $('.categoryprofilepage_stores_orderby_key2').css('display', 'none');
            } else if (categoryprofilepage_stores == 'Orderby()') {
                $('.categoryprofilepage_stores_limit').css('display', 'none');
                $('.categoryprofilepage_stores_orderby_key1').css('display', 'block');
                $('.categoryprofilepage_stores_orderby_key2').css('display', 'block');
            } else if (categoryprofilepage_stores == 'Orderby()->limit()') {
                $('.categoryprofilepage_stores_limit').css('display', 'block');
                $('.categoryprofilepage_stores_orderby_key1').css('display', 'block');
                $('.categoryprofilepage_stores_orderby_key2').css('display', 'block');
            }

            var categoryprofilepage_coupons = $('.categoryprofilepage_coupons').val();
            if (categoryprofilepage_coupons == 'limit()' || categoryprofilepage_coupons ==
                'inRandomOrder()->limit()') {
                $('.categoryprofilepage_coupons_limit').css('display', 'block');
                $('.categoryprofilepage_coupons_orderby_key1').css('display', 'none');
                $('.categoryprofilepage_coupons_orderby_key2').css('display', 'none');
            } else if (categoryprofilepage_coupons == 'inRandomOrder()') {
                $('.categoryprofilepage_coupons_limit').css('display', 'none');
                $('.categoryprofilepage_coupons_orderby_key1').css('display', 'none');
                $('.categoryprofilepage_coupons_orderby_key2').css('display', 'none');
            } else if (categoryprofilepage_coupons == 'Orderby()') {
                $('.categoryprofilepage_coupons_limit').css('display', 'none');
                $('.categoryprofilepage_coupons_orderby_key1').css('display', 'block');
                $('.categoryprofilepage_coupons_orderby_key2').css('display', 'block');
            } else if (categoryprofilepage_coupons == 'Orderby()->limit()') {
                $('.categoryprofilepage_coupons_limit').css('display', 'block');
                $('.categoryprofilepage_coupons_orderby_key1').css('display', 'block');
                $('.categoryprofilepage_coupons_orderby_key2').css('display', 'block');
            }

            var categoryprofilepage_categories = $('.categoryprofilepage_categories').val();
            console.log(categoryprofilepage_categories);
            if (categoryprofilepage_categories == 'limit()' || categoryprofilepage_categories ==
                'inRandomOrder()->limit()') {
                $('.categoryprofilepage_categories_limit').css('display', 'block');
                $('.categoryprofilepage_categories_orderby_key1').css('display', 'none');
                $('.categoryprofilepage_categories_orderby_key2').css('display', 'none');
            } else if (categoryprofilepage_categories == 'inRandomOrder()') {
                $('.categoryprofilepage_categories_limit').css('display', 'none');
                $('.categoryprofilepage_categories_orderby_key1').css('display', 'none');
                $('.categoryprofilepage_categories_orderby_key2').css('display', 'none');
            } else if (categoryprofilepage_categories == 'Orderby()') {
                $('.categoryprofilepage_categories_limit').css('display', 'none');
                $('.categoryprofilepage_categories_orderby_key1').css('display', 'block');
                $('.categoryprofilepage_categories_orderby_key2').css('display', 'block');
            } else if (categoryprofilepage_categories == 'Orderby()->limit()') {
                $('.categoryprofilepage_categories_limit').css('display', 'block');
                $('.categoryprofilepage_categories_orderby_key1').css('display', 'block');
                $('.categoryprofilepage_categories_orderby_key2').css('display', 'block');
            }


            var categoryprofilepage_blogs = $('.categoryprofilepage_blogs').val();
            if (categoryprofilepage_blogs == 'limit()' || categoryprofilepage_blogs == 'inRandomOrder()->limit()') {
                $('.categoryprofilepage_blogs_limit').css('display', 'block');
                $('.categoryprofilepage_blogs_orderby_key1').css('display', 'none');
                $('.categoryprofilepage_blogs_orderby_key2').css('display', 'none');
            } else if (categoryprofilepage_blogs == 'inRandomOrder()') {
                $('.categoryprofilepage_blogs_limit').css('display', 'none');
                $('.categoryprofilepage_blogs_orderby_key1').css('display', 'none');
                $('.categoryprofilepage_blogs_orderby_key2').css('display', 'none');
            } else if (categoryprofilepage_blogs == 'Orderby()') {
                $('.categoryprofilepage_blogs_limit').css('display', 'none');
                $('.categoryprofilepage_blogs_orderby_key1').css('display', 'block');
                $('.categoryprofilepage_blogs_orderby_key2').css('display', 'block');
            } else if (categoryprofilepage_blogs == 'Orderby()->limit()') {
                $('.categoryprofilepage_blogs_limit').css('display', 'block');
                $('.categoryprofilepage_blogs_orderby_key1').css('display', 'block');
                $('.categoryprofilepage_blogs_orderby_key2').css('display', 'block');
            }

            //blog profile settings

            var blogprofilepage_stores = $('.blogprofilepage_stores').val();
            console.log(blogprofilepage_stores);
            if (blogprofilepage_stores == 'limit()' || blogprofilepage_stores == 'inRandomOrder()->limit()') {
                $('.blogprofilepage_stores_limit').css('display', 'block');
                $('.blogprofilepage_stores_orderby_key1').css('display', 'none');
                $('.blogprofilepage_stores_orderby_key2').css('display', 'none');
            } else if (blogprofilepage_stores == 'inRandomOrder()') {
                $('.blogprofilepage_stores_limit').css('display', 'none');
                $('.blogprofilepage_stores_orderby_key1').css('display', 'none');
                $('.blogprofilepage_stores_orderby_key2').css('display', 'none');
            } else if (blogprofilepage_stores == 'Orderby()') {
                $('.blogprofilepage_stores_limit').css('display', 'none');
                $('.blogprofilepage_stores_orderby_key1').css('display', 'block');
                $('.blogprofilepage_stores_orderby_key2').css('display', 'block');
            } else if (blogprofilepage_stores == 'Orderby()->limit()') {
                $('.blogprofilepage_stores_limit').css('display', 'block');
                $('.blogprofilepage_stores_orderby_key1').css('display', 'block');
                $('.blogprofilepage_stores_orderby_key2').css('display', 'block');
            }

            var blogprofilepage_coupons = $('.blogprofilepage_coupons').val();
            if (blogprofilepage_coupons == 'limit()' || blogprofilepage_coupons == 'inRandomOrder()->limit()') {
                $('.blogprofilepage_coupons_limit').css('display', 'block');
                $('.blogprofilepage_coupons_orderby_key1').css('display', 'none');
                $('.blogprofilepage_coupons_orderby_key2').css('display', 'none');
            } else if (blogprofilepage_coupons == 'inRandomOrder()') {
                $('.blogprofilepage_coupons_limit').css('display', 'none');
                $('.blogprofilepage_coupons_orderby_key1').css('display', 'none');
                $('.blogprofilepage_coupons_orderby_key2').css('display', 'none');
            } else if (blogprofilepage_coupons == 'Orderby()') {
                $('.blogprofilepage_coupons_limit').css('display', 'none');
                $('.blogprofilepage_coupons_orderby_key1').css('display', 'block');
                $('.blogprofilepage_coupons_orderby_key2').css('display', 'block');
            } else if (blogprofilepage_coupons == 'Orderby()->limit()') {
                $('.blogprofilepage_coupons_limit').css('display', 'block');
                $('.blogprofilepage_coupons_orderby_key1').css('display', 'block');
                $('.blogprofilepage_coupons_orderby_key2').css('display', 'block');
            }

            var blogprofilepage_categories = $('.blogprofilepage_categories').val();
            console.log(blogprofilepage_categories);
            if (blogprofilepage_categories == 'limit()' || blogprofilepage_categories ==
                'inRandomOrder()->limit()') {
                $('.blogprofilepage_categories_limit').css('display', 'block');
                $('.blogprofilepage_categories_orderby_key1').css('display', 'none');
                $('.blogprofilepage_categories_orderby_key2').css('display', 'none');
            } else if (blogprofilepage_categories == 'inRandomOrder()') {
                $('.blogprofilepage_categories_limit').css('display', 'none');
                $('.blogprofilepage_categories_orderby_key1').css('display', 'none');
                $('.blogprofilepage_categories_orderby_key2').css('display', 'none');
            } else if (blogprofilepage_categories == 'Orderby()') {
                $('.blogprofilepage_categories_limit').css('display', 'none');
                $('.blogprofilepage_categories_orderby_key1').css('display', 'block');
                $('.blogprofilepage_categories_orderby_key2').css('display', 'block');
            } else if (blogprofilepage_categories == 'Orderby()->limit()') {
                $('.blogprofilepage_categories_limit').css('display', 'block');
                $('.blogprofilepage_categories_orderby_key1').css('display', 'block');
                $('.blogprofilepage_categories_orderby_key2').css('display', 'block');
            }

            var blogprofilepage_blogs = $('.blogprofilepage_blogs').val();
            if (blogprofilepage_blogs == 'limit()' || blogprofilepage_blogs == 'inRandomOrder()->limit()') {
                $('.blogprofilepage_blogs_limit').css('display', 'block');
                $('.blogprofilepage_blogs_orderby_key1').css('display', 'none');
                $('.blogprofilepage_blogs_orderby_key2').css('display', 'none');
            } else if (blogprofilepage_blogs == 'inRandomOrder()') {
                $('.blogprofilepage_blogs_limit').css('display', 'none');
                $('.blogprofilepage_blogs_orderby_key1').css('display', 'none');
                $('.blogprofilepage_blogs_orderby_key2').css('display', 'none');
            } else if (blogprofilepage_blogs == 'Orderby()') {
                $('.blogprofilepage_blogs_limit').css('display', 'none');
                $('.blogprofilepage_blogs_orderby_key1').css('display', 'block');
                $('.blogprofilepage_blogs_orderby_key2').css('display', 'block');
            } else if (blogprofilepage_blogs == 'Orderby()->limit()') {
                $('.blogprofilepage_blogs_limit').css('display', 'block');
                $('.blogprofilepage_blogs_orderby_key1').css('display', 'block');
                $('.blogprofilepage_blogs_orderby_key2').css('display', 'block');
            }

            //event profile settings

            var eventprofilepage_stores = $('.eventprofilepage_stores').val();
            console.log(eventprofilepage_stores);
            if (eventprofilepage_stores == 'limit()' || eventprofilepage_stores == 'inRandomOrder()->limit()') {
                $('.eventprofilepage_stores_limit').css('display', 'block');
                $('.eventprofilepage_stores_orderby_key1').css('display', 'none');
                $('.eventprofilepage_stores_orderby_key2').css('display', 'none');
            } else if (eventprofilepage_stores == 'inRandomOrder()') {
                $('.eventprofilepage_stores_limit').css('display', 'none');
                $('.eventprofilepage_storess_orderby_key1').css('display', 'none');
                $('.eventprofilepage_stores_orderby_key2').css('display', 'none');
            } else if (eventprofilepage_stores == 'Orderby()') {
                $('.eventprofilepage_stores_limit').css('display', 'none');
                $('.eventprofilepage_stores_orderby_key1').css('display', 'block');
                $('.eventprofilepage_stores_orderby_key2').css('display', 'block');
            } else if (eventprofilepage_stores == 'Orderby()->limit()') {
                $('.eventprofilepage_stores_limit').css('display', 'block');
                $('.eventprofilepage_stores_orderby_key1').css('display', 'block');
                $('.eventprofilepage_stores_orderby_key2').css('display', 'block');
            }

            var eventprofilepage_coupons = $('.eventprofilepage_coupons').val();
            if (eventprofilepage_coupons == 'limit()' || eventprofilepage_coupons == 'inRandomOrder()->limit()') {
                $('.eventprofilepage_coupons_limit').css('display', 'block');
                $('.eventprofilepage_coupons_orderby_key1').css('display', 'none');
                $('.eventprofilepage_coupons_orderby_key2').css('display', 'none');
            } else if (eventprofilepage_coupons == 'inRandomOrder()') {
                $('.eventprofilepage_coupons_limit').css('display', 'none');
                $('.eventprofilepage_coupons_orderby_key1').css('display', 'none');
                $('.eventprofilepage_coupons_orderby_key2').css('display', 'none');
            } else if (eventprofilepage_coupons == 'Orderby()') {
                $('.eventprofilepage_coupons_limit').css('display', 'none');
                $('.eventprofilepage_coupons_orderby_key1').css('display', 'block');
                $('.eventprofilepage_coupons_orderby_key2').css('display', 'block');
            } else if (eventprofilepage_coupons == 'Orderby()->limit()') {
                $('.eventprofilepage_coupons_limit').css('display', 'block');
                $('.eventprofilepage_coupons_orderby_key1').css('display', 'block');
                $('.eventprofilepage_coupons_orderby_key2').css('display', 'block');
            }

            var eventprofilepage_categories = $('.eventprofilepage_categories').val();
            console.log(eventprofilepage_categories);
            if (eventprofilepage_categories == 'limit()' || eventprofilepage_categories ==
                'inRandomOrder()->limit()') {
                $('.eventprofilepage_categories_limit').css('display', 'block');
                $('.eventprofilepage_categories_orderby_key1').css('display', 'none');
                $('.eventprofilepage_categories_orderby_key2').css('display', 'none');
            } else if (eventprofilepage_categories == 'inRandomOrder()') {
                $('.eventprofilepage_categories_limit').css('display', 'none');
                $('.eventprofilepage_categories_orderby_key1').css('display', 'none');
                $('.eventprofilepage_categories_orderby_key2').css('display', 'none');
            } else if (eventprofilepage_categories == 'Orderby()') {
                $('.eventprofilepage_categories_limit').css('display', 'none');
                $('.eventprofilepage_categories_orderby_key1').css('display', 'block');
                $('.eventprofilepage_categories_orderby_key2').css('display', 'block');
            } else if (eventprofilepage_categories == 'Orderby()->limit()') {
                $('.eventprofilepage_categories_limit').css('display', 'block');
                $('.eventprofilepage_categories_orderby_key1').css('display', 'block');
                $('.eventprofilepage_categories_orderby_key2').css('display', 'block');
            }

            var eventprofilepage_blogs = $('.eventprofilepage_blogs').val();
            if (eventprofilepage_blogs == 'limit()' || eventprofilepage_blogs == 'inRandomOrder()->limit()') {
                $('.eventprofilepage_blogs_limit').css('display', 'block');
                $('.eventprofilepage_blogs_orderby_key1').css('display', 'none');
                $('.eventprofilepage_blogs_orderby_key2').css('display', 'none');
            } else if (eventprofilepage_blogs == 'inRandomOrder()') {
                $('.eventprofilepage_blogs_limit').css('display', 'none');
                $('.eventprofilepage_blogs_orderby_key1').css('display', 'none');
                $('.eventprofilepage_blogs_orderby_key2').css('display', 'none');
            } else if (eventprofilepage_blogs == 'Orderby()') {
                $('.eventprofilepage_blogs_limit').css('display', 'none');
                $('.eventprofilepage_blogs_orderby_key1').css('display', 'block');
                $('.eventprofilepage_blogs_orderby_key2').css('display', 'block');
            } else if (eventprofilepage_blogs == 'Orderby()->limit()') {
                $('.eventprofilepage_blogs_limit').css('display', 'block');
                $('.eventprofilepage_blogs_orderby_key1').css('display', 'block');
                $('.eventprofilepage_blogs_orderby_key2').css('display', 'block');
            }


            //footer settings 

            var footer_stores = $('.footer_stores').val();
            if (footer_stores == 'limit()' || footer_stores == 'inRandomOrder()->limit()') {
                $('.footer_stores_limit').css('display', 'block');
                $('.footer_stores_orderby_key1').css('display', 'none');
                $('.footer_stores_orderby_key2').css('display', 'none');
            } else if (footer_stores == 'inRandomOrder()') {
                $('.footer_stores_limit').css('display', 'none');
                $('.footer_stores_orderby_key1').css('display', 'none');
                $('.footer_stores_orderby_key2').css('display', 'none');
            } else if (footer_stores == 'Orderby()') {
                $('.footer_stores_limit').css('display', 'none');
                $('.footer_stores_orderby_key1').css('display', 'block');
                $('.footer_stores_orderby_key2').css('display', 'block');
            } else if (footer_stores == 'Orderby()->limit()') {
                $('.footer_stores_limit').css('display', 'block');
                $('.footer_stores_orderby_key1').css('display', 'block');
                $('.footer_stores_orderby_key2').css('display', 'block');
            }

            var footer_categories = $('.footer_categories').val();
            console.log(footer_categories);
            if (footer_categories == 'limit()' || footer_categories == 'inRandomOrder()->limit()') {
                $('.footer_categories_limit').css('display', 'block');
                $('.footer_categories_orderby_key1').css('display', 'none');
                $('.footer_categories_orderby_key2').css('display', 'none');
            } else if (footer_categories == 'inRandomOrder()') {
                $('.footer_categories_limit').css('display', 'none');
                $('.footer_categories_orderby_key1').css('display', 'none');
                $('.footer_categories_orderby_key2').css('display', 'none');
            } else if (footer_categories == 'Orderby()') {
                $('.footer_categories_limit').css('display', 'none');
                $('.footer_categories_orderby_key1').css('display', 'block');
                $('.footer_categories_orderby_key2').css('display', 'block');
            } else if (footer_categories == 'Orderby()->limit()') {
                $('.footer_categories_limit').css('display', 'block');
                $('.footer_categories_orderby_key1').css('display', 'block');
                $('.footer_categories_orderby_key2').css('display', 'block');
            }


            var footer_blogs = $('.footer_blogs').val();
            if (footer_blogs == 'limit()' || footer_blogs == 'inRandomOrder()->limit()') {
                $('.footer_blogs_limit').css('display', 'block');
                $('.footer_blogs_orderby_key1').css('display', 'none');
                $('.footer_blogs_orderby_key2').css('display', 'none');
            } else if (footer_blogs == 'inRandomOrder()') {
                $('.footer_blogs_limit').css('display', 'none');
                $('.footer_blogs_orderby_key1').css('display', 'none');
                $('.footer_blogs_orderby_key2').css('display', 'none');
            } else if (footer_blogs == 'Orderby()') {
                $('.footer_blogs_limit').css('display', 'none');
                $('.footer_blogs_orderby_key1').css('display', 'block');
                $('.footer_blogs_orderby_key2').css('display', 'block');
            } else if (footer_blogs == 'Orderby()->limit()') {
                $('.footer_blogs_limit').css('display', 'block');
                $('.footer_blogs_orderby_key1').css('display', 'block');
                $('.footer_blogs_orderby_key2').css('display', 'block');
            }


        });
        //home page stores settings
        $(document).on('change', '.homepage_stores', function() {
            var homepage_stores = $(this).val();
            console.log(homepage_stores);
            if (homepage_stores == 'limit()' || homepage_stores == 'inRandomOrder()->limit()') {
                $('.homepage_stores_limit').css('display', 'block');
                $('.homepage_stores_orderby_key1').css('display', 'none');
                $('.homepage_stores_orderby_key2').css('display', 'none');
            } else if (homepage_stores == 'inRandomOrder()') {
                $('.homepage_stores_limit').css('display', 'none');
                $('.homepage_stores_orderby_key1').css('display', 'none');
                $('.homepage_stores_orderby_key2').css('display', 'none');
            } else if (homepage_stores == 'Orderby()') {
                $('.homepage_stores_limit').css('display', 'none');
                $('.homepage_stores_orderby_key1').css('display', 'block');
                $('.homepage_stores_orderby_key2').css('display', 'block');
            } else if (homepage_stores == 'Orderby()->limit()') {
                $('.homepage_stores_limit').css('display', 'block');
                $('.homepage_stores_orderby_key1').css('display', 'block');
                $('.homepage_stores_orderby_key2').css('display', 'block');
            }
        });
        //home page coupons settings

        $(document).on('change', '.homepage_coupons', function() {
            var homepage_coupons = $(this).val();
            if (homepage_coupons == 'limit()' || homepage_coupons == 'inRandomOrder()->limit()') {
                $('.homepage_coupons_limit').css('display', 'block');
                $('.homepage_coupons_orderby_key1').css('display', 'none');
                $('.homepage_coupons_orderby_key2').css('display', 'none');
            } else if (homepage_coupons == 'inRandomOrder()') {
                $('.homepage_coupons_limit').css('display', 'none');
                $('.homepage_coupons_orderby_key1').css('display', 'none');
                $('.homepage_coupons_orderby_key2').css('display', 'none');
            } else if (homepage_coupons == 'Orderby()') {
                $('.homepage_coupons_limit').css('display', 'none');
                $('.homepage_coupons_orderby_key1').css('display', 'block');
                $('.homepage_coupons_orderby_key2').css('display', 'block');
            } else if (homepage_coupons == 'Orderby()->limit()') {
                $('.homepage_coupons_limit').css('display', 'block');
                $('.homepage_coupons_orderby_key1').css('display', 'block');
                $('.homepage_coupons_orderby_key2').css('display', 'block');
            }
        });
        //home page categories settings

        $(document).on('change', '.homepage_categories', function() {
            var homepage_categories = $(this).val();
            console.log(homepage_categories);
            if (homepage_categories == 'limit()' || homepage_categories == 'inRandomOrder()->limit()') {
                $('.homepage_categories_limit').css('display', 'block');
                $('.homepage_categories_orderby_key1').css('display', 'none');
                $('.homepage_categories_orderby_key2').css('display', 'none');
            } else if (homepage_categories == 'inRandomOrder()') {
                $('.homepage_categories_limit').css('display', 'none');
                $('.homepage_categories_orderby_key1').css('display', 'none');
                $('.homepage_categories_orderby_key2').css('display', 'none');
            } else if (homepage_categories == 'Orderby()') {
                $('.homepage_categories_limit').css('display', 'none');
                $('.homepage_categories_orderby_key1').css('display', 'block');
                $('.homepage_categories_orderby_key2').css('display', 'block');
            } else if (homepage_categories == 'Orderby()->limit()') {
                $('.homepage_categories_limit').css('display', 'block');
                $('.homepage_categories_orderby_key1').css('display', 'block');
                $('.homepage_categories_orderby_key2').css('display', 'block');
            }
        });
        //home page blogs settings

        $(document).on('change', '.homepage_blogs', function() {
            var homepage_blogs = $(this).val();
            if (homepage_blogs == 'limit()' || homepage_blogs == 'inRandomOrder()->limit()') {
                $('.homepage_blogs_limit').css('display', 'block');
                $('.homepage_blogs_orderby_key1').css('display', 'none');
                $('.homepage_blogs_orderby_key2').css('display', 'none');
            } else if (homepage_blogs == 'inRandomOrder()') {
                $('.homepage_blogs_limit').css('display', 'none');
                $('.homepage_blogs_orderby_key1').css('display', 'none');
                $('.homepage_blogs_orderby_key2').css('display', 'none');
            } else if (homepage_blogs == 'Orderby()') {
                $('.homepage_blogs_limit').css('display', 'none');
                $('.homepage_blogs_orderby_key1').css('display', 'block');
                $('.homepage_blogs_orderby_key2').css('display', 'block');
            } else if (homepage_blogs == 'Orderby()->limit()') {
                $('.homepage_blogs_limit').css('display', 'block');
                $('.homepage_blogs_orderby_key1').css('display', 'block');
                $('.homepage_blogs_orderby_key2').css('display', 'block');
            }
        });

        //store page stores settings
        $(document).on('change', '.storepage_stores', function() {
            var storepage_stores = $(this).val();
            console.log(storepage_stores);
            if (storepage_stores == 'paginate()' || storepage_stores == 'limit()' || storepage_stores ==
                'inRandomOrder()->limit()') {
                $('.storepage_stores_limit').css('display', 'block');
                $('.storepage_stores_orderby_key1').css('display', 'none');
                $('.storepage_stores_orderby_key2').css('display', 'none');
            } else if (storepage_stores == 'inRandomOrder()') {
                $('.storepage_stores_limit').css('display', 'none');
                $('.storepage_stores_orderby_key1').css('display', 'none');
                $('.storepage_stores_orderby_key2').css('display', 'none');
            } else if (storepage_stores == 'Orderby()') {
                $('.storepage_stores_limit').css('display', 'none');
                $('.storepage_stores_orderby_key1').css('display', 'block');
                $('.storepage_stores_orderby_key2').css('display', 'block');
            } else if (storepage_stores == 'Orderby()->limit()') {
                $('.storepage_stores_limit').css('display', 'block');
                $('.storepage_stores_orderby_key1').css('display', 'block');
                $('.storepage_stores_orderby_key2').css('display', 'block');
            }
        });
        //store page coupons settings

        $(document).on('change', '.storepage_coupons', function() {
            var storepage_coupons = $(this).val();
            if (storepage_coupons == 'limit()' || storepage_coupons == 'inRandomOrder()->limit()') {
                $('.storepage_coupons_limit').css('display', 'block');
                $('.storepage_coupons_orderby_key1').css('display', 'none');
                $('.storepage_coupons_orderby_key2').css('display', 'none');
            } else if (storepage_coupons == 'inRandomOrder()') {
                $('.storepage_coupons_limit').css('display', 'none');
                $('.storepage_coupons_orderby_key1').css('display', 'none');
                $('.storepage_coupons_orderby_key2').css('display', 'none');
            } else if (storepage_coupons == 'Orderby()') {
                $('.storepage_coupons_limit').css('display', 'none');
                $('.storepage_coupons_orderby_key1').css('display', 'block');
                $('.storepage_coupons_orderby_key2').css('display', 'block');
            } else if (storepage_coupons == 'Orderby()->limit()') {
                $('.storepage_coupons_limit').css('display', 'block');
                $('.storepage_coupons_orderby_key1').css('display', 'block');
                $('.storepage_coupons_orderby_key2').css('display', 'block');
            }
        });
        //store page categories settings

        $(document).on('change', '.storepage_categories', function() {
            var storepage_categories = $(this).val();
            console.log(storepage_categories);
            if (storepage_categories == 'limit()' || storepage_categories == 'inRandomOrder()->limit()') {
                $('.storepage_categories_limit').css('display', 'block');
                $('.storepage_categories_orderby_key1').css('display', 'none');
                $('.storepage_categories_orderby_key2').css('display', 'none');
            } else if (storepage_categories == 'inRandomOrder()') {
                $('.storepage_categories_limit').css('display', 'none');
                $('.storepage_categories_orderby_key1').css('display', 'none');
                $('.storepage_categories_orderby_key2').css('display', 'none');
            } else if (storepage_categories == 'Orderby()') {
                $('.storepage_categories_limit').css('display', 'none');
                $('.storepage_categories_orderby_key1').css('display', 'block');
                $('.storepage_categories_orderby_key2').css('display', 'block');
            } else if (storepage_categories == 'Orderby()->limit()') {
                $('.storepage_categories_limit').css('display', 'block');
                $('.storepage_categories_orderby_key1').css('display', 'block');
                $('.storepage_categories_orderby_key2').css('display', 'block');
            }
        });
        //store page blogs settings

        $(document).on('change', '.storepage_blogs', function() {
            var storepage_blogs = $(this).val();
            if (storepage_blogs == 'limit()' || storepage_blogs == 'inRandomOrder()->limit()') {
                $('.storepage_blogs_limit').css('display', 'block');
                $('.storepage_blogs_orderby_key1').css('display', 'none');
                $('.storepage_blogs_orderby_key2').css('display', 'none');
            } else if (storepage_blogs == 'inRandomOrder()') {
                $('.storepage_blogs_limit').css('display', 'none');
                $('.storepage_blogs_orderby_key1').css('display', 'none');
                $('.storepage_blogs_orderby_key2').css('display', 'none');
            } else if (storepage_blogs == 'Orderby()') {
                $('.storepage_blogs_limit').css('display', 'none');
                $('.storepage_blogs_orderby_key1').css('display', 'block');
                $('.storepage_blogs_orderby_key2').css('display', 'block');
            } else if (storepage_blogs == 'Orderby()->limit()') {
                $('.storepage_blogs_limit').css('display', 'block');
                $('.storepage_blogs_orderby_key1').css('display', 'block');
                $('.storepage_blogs_orderby_key2').css('display', 'block');
            }
        });

        //category page stores settings
        $(document).on('change', '.categorypage_stores', function() {
            var categorypage_stores = $(this).val();
            console.log(categorypage_stores);
            if (categorypage_stores == 'limit()' || categorypage_stores == 'inRandomOrder()->limit()') {
                $('.categorypage_stores_limit').css('display', 'block');
                $('.categorypage_stores_orderby_key1').css('display', 'none');
                $('.categorypage_stores_orderby_key2').css('display', 'none');
            } else if (categorypage_stores == 'inRandomOrder()') {
                $('.categorypage_stores_limit').css('display', 'none');
                $('.categorypage_stores_orderby_key1').css('display', 'none');
                $('.categorypage_stores_orderby_key2').css('display', 'none');
            } else if (categorypage_stores == 'Orderby()') {
                $('.categorypage_stores_limit').css('display', 'none');
                $('.categorypage_stores_orderby_key1').css('display', 'block');
                $('.categorypage_stores_orderby_key2').css('display', 'block');
            } else if (categorypage_stores == 'Orderby()->limit()') {
                $('.categorypage_stores_limit').css('display', 'block');
                $('.categorypage_stores_orderby_key1').css('display', 'block');
                $('.categorypage_stores_orderby_key2').css('display', 'block');
            }
        });
        //category page coupons settings

        $(document).on('change', '.categorypage_coupons', function() {
            var categorypage_coupons = $(this).val();
            if (categorypage_coupons == 'limit()' || categorypage_coupons == 'inRandomOrder()->limit()') {
                $('.categorypage_coupons_limit').css('display', 'block');
                $('.categorypage_coupons_orderby_key1').css('display', 'none');
                $('.categorypage_coupons_orderby_key2').css('display', 'none');
            } else if (categorypage_coupons == 'inRandomOrder()') {
                $('.categorypage_coupons_limit').css('display', 'none');
                $('.categorypage_coupons_orderby_key1').css('display', 'none');
                $('.categorypage_coupons_orderby_key2').css('display', 'none');
            } else if (categorypage_coupons == 'Orderby()') {
                $('.categorypage_coupons_limit').css('display', 'none');
                $('.categorypage_coupons_orderby_key1').css('display', 'block');
                $('.categorypage_coupons_orderby_key2').css('display', 'block');
            } else if (categorypage_coupons == 'Orderby()->limit()') {
                $('.categorypage_coupons_limit').css('display', 'block');
                $('.categorypage_coupons_orderby_key1').css('display', 'block');
                $('.categorypage_coupons_orderby_key2').css('display', 'block');
            }
        });
        //category page categories settings

        $(document).on('change', '.categorypage_categories', function() {
            var categorypage_categories = $(this).val();
            console.log(categorypage_categories);
            if (categorypage_categories == 'paginate()' || categorypage_categories == 'limit()' ||
                categorypage_categories == 'inRandomOrder()->limit()') {
                $('.categorypage_categories_limit').css('display', 'block');
                $('.categorypage_categories_orderby_key1').css('display', 'none');
                $('.categorypage_categories_orderby_key2').css('display', 'none');
            } else if (categorypage_categories == 'inRandomOrder()') {
                $('.categorypage_categories_limit').css('display', 'none');
                $('.categorypage_categories_orderby_key1').css('display', 'none');
                $('.categorypage_categories_orderby_key2').css('display', 'none');
            } else if (categorypage_categories == 'Orderby()') {
                $('.categorypage_categories_limit').css('display', 'none');
                $('.categorypage_categories_orderby_key1').css('display', 'block');
                $('.categorypage_categories_orderby_key2').css('display', 'block');
            } else if (categorypage_categories == 'Orderby()->limit()') {
                $('.categorypage_categories_limit').css('display', 'block');
                $('.categorypage_categories_orderby_key1').css('display', 'block');
                $('.categorypage_categories_orderby_key2').css('display', 'block');
            }
        });
        //category page blogs settings

        $(document).on('change', '.categorypage_blogs', function() {
            var categorypage_blogs = $(this).val();
            if (categorypage_blogs == 'limit()' || categorypage_blogs == 'inRandomOrder()->limit()') {
                $('.categorypage_blogs_limit').css('display', 'block');
                $('.categorypage_blogs_orderby_key1').css('display', 'none');
                $('.categorypage_blogs_orderby_key2').css('display', 'none');
            } else if (categorypage_blogs == 'inRandomOrder()') {
                $('.categorypage_blogs_limit').css('display', 'none');
                $('.categorypage_blogs_orderby_key1').css('display', 'none');
                $('.categorypage_blogs_orderby_key2').css('display', 'none');
            } else if (categorypage_blogs == 'Orderby()') {
                $('.categorypage_blogs_limit').css('display', 'none');
                $('.categorypage_blogs_orderby_key1').css('display', 'block');
                $('.categorypage_blogs_orderby_key2').css('display', 'block');
            } else if (categorypage_blogs == 'Orderby()->limit()') {
                $('.categorypage_blogs_limit').css('display', 'block');
                $('.categorypage_blogs_orderby_key1').css('display', 'block');
                $('.categorypage_blogs_orderby_key2').css('display', 'block');
            }
        });

        //blog page stores settings
        $(document).on('change', '.blogpage_stores', function() {
            var blogpage_stores = $(this).val();
            console.log(blogpage_stores);
            if (blogpage_stores == 'limit()' || blogpage_stores == 'inRandomOrder()->limit()') {
                $('.blogpage_stores_limit').css('display', 'block');
                $('.blogpage_stores_orderby_key1').css('display', 'none');
                $('.blogpage_stores_orderby_key2').css('display', 'none');
            } else if (blogpage_stores == 'inRandomOrder()') {
                $('.blogpage_stores_limit').css('display', 'none');
                $('.blogpage_stores_orderby_key1').css('display', 'none');
                $('.blogpage_stores_orderby_key2').css('display', 'none');
            } else if (blogpage_stores == 'Orderby()') {
                $('.blogpage_stores_limit').css('display', 'none');
                $('.blogpage_stores_orderby_key1').css('display', 'block');
                $('.blogpage_stores_orderby_key2').css('display', 'block');
            } else if (blogpage_stores == 'Orderby()->limit()') {
                $('.blogpage_stores_limit').css('display', 'block');
                $('.blogpage_stores_orderby_key1').css('display', 'block');
                $('.blogpage_stores_orderby_key2').css('display', 'block');
            }
        });
        //blog page coupons settings

        $(document).on('change', '.blogpage_coupons', function() {
            var blogpage_coupons = $(this).val();
            if (blogpage_coupons == 'limit()' || blogpage_coupons == 'inRandomOrder()->limit()') {
                $('.blogpage_coupons_limit').css('display', 'block');
                $('.blogpage_coupons_orderby_key1').css('display', 'none');
                $('.blogpage_coupons_orderby_key2').css('display', 'none');
            } else if (blogpage_coupons == 'inRandomOrder()') {
                $('.blogpage_coupons_limit').css('display', 'none');
                $('.blogpage_coupons_orderby_key1').css('display', 'none');
                $('.blogpage_coupons_orderby_key2').css('display', 'none');
            } else if (blogpage_coupons == 'Orderby()') {
                $('.blogpage_coupons_limit').css('display', 'none');
                $('.blogpage_coupons_orderby_key1').css('display', 'block');
                $('.blogpage_coupons_orderby_key2').css('display', 'block');
            } else if (blogpage_coupons == 'Orderby()->limit()') {
                $('.blogpage_coupons_limit').css('display', 'block');
                $('.blogpage_coupons_orderby_key1').css('display', 'block');
                $('.blogpage_coupons_orderby_key2').css('display', 'block');
            }
        });
        //blog page categories settings

        $(document).on('change', '.blogpage_categories', function() {
            var blogpage_categories = $(this).val();
            console.log(blogpage_categories);
            if (blogpage_categories == 'limit()' || blogpage_categories == 'inRandomOrder()->limit()') {
                $('.blogpage_categories_limit').css('display', 'block');
                $('.blogpage_categories_orderby_key1').css('display', 'none');
                $('.blogpage_categories_orderby_key2').css('display', 'none');
            } else if (blogpage_categories == 'inRandomOrder()') {
                $('.blogpage_categories_limit').css('display', 'none');
                $('.blogpage_categories_orderby_key1').css('display', 'none');
                $('.blogpage_categories_orderby_key2').css('display', 'none');
            } else if (blogpage_categories == 'Orderby()') {
                $('.blogpage_categories_limit').css('display', 'none');
                $('.blogpage_categories_orderby_key1').css('display', 'block');
                $('.blogpage_categories_orderby_key2').css('display', 'block');
            } else if (blogpage_categories == 'Orderby()->limit()') {
                $('.blogpage_categories_limit').css('display', 'block');
                $('.blogpage_categories_orderby_key1').css('display', 'block');
                $('.blogpage_categories_orderby_key2').css('display', 'block');
            }
        });
        //blog page blogs settings

        $(document).on('change', '.blogpage_blogs', function() {
            var blogpage_blogs = $(this).val();
            if (blogpage_blogs == 'paginate()' || blogpage_blogs == 'limit()' || blogpage_blogs ==
                'inRandomOrder()->limit()') {
                $('.blogpage_blogs_limit').css('display', 'block');
                $('.blogpage_blogs_orderby_key1').css('display', 'none');
                $('.blogpage_blogs_orderby_key2').css('display', 'none');
            } else if (blogpage_blogs == 'inRandomOrder()') {
                $('.blogpage_blogs_limit').css('display', 'none');
                $('.blogpage_blogs_orderby_key1').css('display', 'none');
                $('.blogpage_blogs_orderby_key2').css('display', 'none');
            } else if (blogpage_blogs == 'Orderby()') {
                $('.blogpage_blogs_limit').css('display', 'none');
                $('.blogpage_blogs_orderby_key1').css('display', 'block');
                $('.blogpage_blogs_orderby_key2').css('display', 'block');
            } else if (blogpage_blogs == 'Orderby()->limit()') {
                $('.blogpage_blogs_limit').css('display', 'block');
                $('.blogpage_blogs_orderby_key1').css('display', 'block');
                $('.blogpage_blogs_orderby_key2').css('display', 'block');
            }
        });

        //event page stores settings
        $(document).on('change', '.eventpage_stores', function() {
            var eventpage_stores = $(this).val();
            console.log(eventpage_stores);
            if (eventpage_stores == 'limit()' || eventpage_stores == 'inRandomOrder()->limit()') {
                $('.eventpage_stores_limit').css('display', 'block');
                $('.eventpage_stores_orderby_key1').css('display', 'none');
                $('.eventpage_stores_orderby_key2').css('display', 'none');
            } else if (eventpage_stores == 'inRandomOrder()') {
                $('.eventpage_stores_limit').css('display', 'none');
                $('.eventpage_storess_orderby_key1').css('display', 'none');
                $('.eventpage_stores_orderby_key2').css('display', 'none');
            } else if (eventpage_stores == 'Orderby()') {
                $('.eventpage_stores_limit').css('display', 'none');
                $('.eventpage_stores_orderby_key1').css('display', 'block');
                $('.eventpage_stores_orderby_key2').css('display', 'block');
            } else if (eventpage_stores == 'Orderby()->limit()') {
                $('.eventpage_stores_limit').css('display', 'block');
                $('.eventpage_stores_orderby_key1').css('display', 'block');
                $('.eventpage_stores_orderby_key2').css('display', 'block');
            }
        });
        //event page coupons settings

        $(document).on('change', '.eventpage_coupons', function() {
            var eventpage_coupons = $(this).val();
            if (eventpage_coupons == 'limit()' || eventpage_coupons == 'inRandomOrder()->limit()') {
                $('.eventpage_coupons_limit').css('display', 'block');
                $('.eventpage_couponss_orderby_key1').css('display', 'none');
                $('.eventpage_coupons_orderby_key2').css('display', 'none');
            } else if (eventpage_coupons == 'inRandomOrder()') {
                $('.eventpage_coupons_limit').css('display', 'none');
                $('.eventpage_coupons_orderby_key1').css('display', 'none');
                $('.eventpage_coupons_orderby_key2').css('display', 'none');
            } else if (eventpage_coupons == 'Orderby()') {
                $('.eventpage_coupons_limit').css('display', 'none');
                $('.eventpage_coupons_orderby_key1').css('display', 'block');
                $('.eventpage_coupons_orderby_key2').css('display', 'block');
            } else if (eventpage_coupons == 'Orderby()->limit()') {
                $('.eventpage_coupons_limit').css('display', 'block');
                $('.eventpage_coupons_orderby_key1').css('display', 'block');
                $('.eventpage_coupons_orderby_key2').css('display', 'block');
            }
        });
        //event page categories settings

        $(document).on('change', '.eventpage_categories', function() {
            var eventpage_categories = $(this).val();
            console.log(eventpage_categories);
            if (eventpage_categories == 'limit()' || eventpage_categories == 'inRandomOrder()->limit()') {
                $('.eventpage_categories_limit').css('display', 'block');
                $('.eventpage_categories_orderby_key1').css('display', 'none');
                $('.eventpage_categories_orderby_key2').css('display', 'none');
            } else if (eventpage_categories == 'inRandomOrder()') {
                $('.eventpage_categories_limit').css('display', 'none');
                $('.eventpage_categories_orderby_key1').css('display', 'none');
                $('.eventpage_categories_orderby_key2').css('display', 'none');
            } else if (eventpage_categories == 'Orderby()') {
                $('.eventpage_categories_limit').css('display', 'none');
                $('.eventpage_categories_orderby_key1').css('display', 'block');
                $('.eventpage_categories_orderby_key2').css('display', 'block');
            } else if (eventpage_categories == 'Orderby()->limit()') {
                $('.eventpage_categories_limit').css('display', 'block');
                $('.eventpage_categories_orderby_key1').css('display', 'block');
                $('.eventpage_categories_orderby_key2').css('display', 'block');
            }
        });
        //event page blogs settings

        $(document).on('change', '.eventpage_blogs', function() {
            var eventpage_blogs = $(this).val();
            if (eventpage_blogs == 'limit()' || eventpage_blogs == 'inRandomOrder()->limit()') {
                $('.eventpage_blogs_limit').css('display', 'block');
                $('.eventpage_blogs_orderby_key1').css('display', 'none');
                $('.eventpage_blogs_orderby_key2').css('display', 'none');
            } else if (eventpage_blogs == 'inRandomOrder()') {
                $('.eventpage_blogs_limit').css('display', 'none');
                $('.eventpage_blogs_orderby_key1').css('display', 'none');
                $('.eventpage_blogs_orderby_key2').css('display', 'none');
            } else if (eventpage_blogs == 'Orderby()') {
                $('.eventpage_blogs_limit').css('display', 'none');
                $('.eventpage_blogs_orderby_key1').css('display', 'block');
                $('.eventpage_blogs_orderby_key2').css('display', 'block');
            } else if (eventpage_blogs == 'Orderby()->limit()') {
                $('.eventpage_blogs_limit').css('display', 'block');
                $('.eventpage_blogs_orderby_key1').css('display', 'block');
                $('.eventpage_blogs_orderby_key2').css('display', 'block');
            }
        });



        //store profile page stores settings
        $(document).on('change', '.storeprofilepage_stores', function() {
            var storeprofilepage_stores = $(this).val();
            console.log(storeprofilepage_stores);
            if (storeprofilepage_stores == 'limit()' || storeprofilepage_stores == 'inRandomOrder()->limit()') {
                $('.storeprofilepage_stores_limit').css('display', 'block');
                $('.storeprofilepage_stores_orderby_key1').css('display', 'none');
                $('.storeprofilepage_stores_orderby_key2').css('display', 'none');
            } else if (storeprofilepage_stores == 'inRandomOrder()') {
                $('.storeprofilepage_stores_limit').css('display', 'none');
                $('.storeprofilepage_stores_orderby_key1').css('display', 'none');
                $('.storeprofilepage_stores_orderby_key2').css('display', 'none');
            } else if (storeprofilepage_stores == 'Orderby()') {
                $('.storeprofilepage_stores_limit').css('display', 'none');
                $('.storeprofilepage_stores_orderby_key1').css('display', 'block');
                $('.storeprofilepage_stores_orderby_key2').css('display', 'block');
            } else if (storeprofilepage_stores == 'Orderby()->limit()') {
                $('.storeprofilepage_stores_limit').css('display', 'block');
                $('.storeprofilepage_stores_orderby_key1').css('display', 'block');
                $('.storeprofilepage_stores_orderby_key2').css('display', 'block');
            }
        });
        //store profile page coupons settings

        $(document).on('change', '.storeprofilepage_coupons', function() {
            var storeprofilepage_coupons = $(this).val();
            if (storeprofilepage_coupons == 'limit()' || storeprofilepage_coupons == 'inRandomOrder()->limit()') {
                $('.storeprofilepage_coupons_limit').css('display', 'block');
                $('.storeprofilepage_coupons_orderby_key1').css('display', 'none');
                $('.storeprofilepage_coupons_orderby_key2').css('display', 'none');
            } else if (storeprofilepage_coupons == 'inRandomOrder()') {
                $('.storeprofilepage_coupons_limit').css('display', 'none');
                $('.storeprofilepage_coupons_orderby_key1').css('display', 'none');
                $('.storeprofilepage_coupons_orderby_key2').css('display', 'none');
            } else if (storeprofilepage_coupons == 'Orderby()') {
                $('.storeprofilepage_coupons_limit').css('display', 'none');
                $('.storeprofilepage_coupons_orderby_key1').css('display', 'block');
                $('.storeprofilepage_coupons_orderby_key2').css('display', 'block');
            } else if (storeprofilepage_coupons == 'Orderby()->limit()') {
                $('.storeprofilepage_coupons_limit').css('display', 'block');
                $('.storeprofilepage_coupons_orderby_key1').css('display', 'block');
                $('.storeprofilepage_coupons_orderby_key2').css('display', 'block');
            }
        });
        //store profile page categories settings

        $(document).on('change', '.storeprofilepage_categories', function() {
            var storeprofilepage_categories = $(this).val();
            console.log(storeprofilepage_categories);
            if (storeprofilepage_categories == 'limit()' || storeprofilepage_categories ==
                'inRandomOrder()->limit()') {
                $('.storeprofilepage_categories_limit').css('display', 'block');
                $('.storeprofilepage_categories_orderby_key1').css('display', 'none');
                $('.storeprofilepage_categories_orderby_key2').css('display', 'none');
            } else if (storeprofilepage_categories == 'inRandomOrder()') {
                $('.storeprofilepage_categories_limit').css('display', 'none');
                $('.storeprofilepage_categories_orderby_key1').css('display', 'none');
                $('.storeprofilepage_categories_orderby_key2').css('display', 'none');
            } else if (storeprofilepage_categories == 'Orderby()') {
                $('.storeprofilepage_categories_limit').css('display', 'none');
                $('.storeprofilepage_categories_orderby_key1').css('display', 'block');
                $('.storeprofilepage_categories_orderby_key2').css('display', 'block');
            } else if (storeprofilepage_categories == 'Orderby()->limit()') {
                $('.storeprofilepage_categories_limit').css('display', 'block');
                $('.storeprofilepage_categories_orderby_key1').css('display', 'block');
                $('.storeprofilepage_categories_orderby_key2').css('display', 'block');
            }
        });
        //store profile page blogs settings

        $(document).on('change', '.storeprofilepage_blogs', function() {
            var storeprofilepage_blogs = $(this).val();
            if (storeprofilepage_blogs == 'limit()' || storeprofilepage_blogs == 'inRandomOrder()->limit()') {
                $('.storeprofilepage_blogs_limit').css('display', 'block');
                $('.storeprofilepage_blogs_orderby_key1').css('display', 'none');
                $('.storeprofilepage_blogs_orderby_key2').css('display', 'none');
            } else if (storeprofilepage_blogs == 'inRandomOrder()') {
                $('.storeprofilepage_blogs_limit').css('display', 'none');
                $('.storeprofilepage_blogs_orderby_key1').css('display', 'none');
                $('.storeprofilepage_blogs_orderby_key2').css('display', 'none');
            } else if (storeprofilepage_blogs == 'Orderby()') {
                $('.storeprofilepage_blogs_limit').css('display', 'none');
                $('.storeprofilepage_blogs_orderby_key1').css('display', 'block');
                $('.storeprofilepage_blogs_orderby_key2').css('display', 'block');
            } else if (storeprofilepage_blogs == 'Orderby()->limit()') {
                $('.storeprofilepage_blogs_limit').css('display', 'block');
                $('.storeprofilepage_blogs_orderby_key1').css('display', 'block');
                $('.storeprofilepage_blogs_orderby_key2').css('display', 'block');
            }
        });

        //category profile page stores settings
        $(document).on('change', '.categoryprofilepage_stores', function() {
            var categoryprofilepage_stores = $(this).val();
            console.log(categoryprofilepage_stores);
            if (categoryprofilepage_stores == 'limit()' || categoryprofilepage_stores ==
                'inRandomOrder()->limit()') {
                $('.categoryprofilepage_stores_limit').css('display', 'block');
                $('.categoryprofilepage_stores_orderby_key1').css('display', 'none');
                $('.categoryprofilepage_stores_orderby_key2').css('display', 'none');
            } else if (categoryprofilepage_stores == 'inRandomOrder()') {
                $('.categoryprofilepage_stores_limit').css('display', 'none');
                $('.categoryprofilepage_stores_orderby_key1').css('display', 'none');
                $('.categoryprofilepage_stores_orderby_key2').css('display', 'none');
            } else if (categoryprofilepage_stores == 'Orderby()') {
                $('.categoryprofilepage_stores_limit').css('display', 'none');
                $('.categoryprofilepage_stores_orderby_key1').css('display', 'block');
                $('.categoryprofilepage_stores_orderby_key2').css('display', 'block');
            } else if (categoryprofilepage_stores == 'Orderby()->limit()') {
                $('.categoryprofilepage_stores_limit').css('display', 'block');
                $('.categoryprofilepage_stores_orderby_key1').css('display', 'block');
                $('.categoryprofilepage_stores_orderby_key2').css('display', 'block');
            }
        });
        //category profile page coupons settings

        $(document).on('change', '.categoryprofilepage_coupons', function() {
            var categoryprofilepage_coupons = $(this).val();
            if (categoryprofilepage_coupons == 'limit()' || categoryprofilepage_coupons ==
                'inRandomOrder()->limit()') {
                $('.categoryprofilepage_coupons_limit').css('display', 'block');
                $('.categoryprofilepage_coupons_orderby_key1').css('display', 'none');
                $('.categoryprofilepage_coupons_orderby_key2').css('display', 'none');
            } else if (categoryprofilepage_coupons == 'inRandomOrder()') {
                $('.categoryprofilepage_coupons_limit').css('display', 'none');
                $('.categoryprofilepage_coupons_orderby_key1').css('display', 'none');
                $('.categoryprofilepage_coupons_orderby_key2').css('display', 'none');
            } else if (categoryprofilepage_coupons == 'Orderby()') {
                $('.categoryprofilepage_coupons_limit').css('display', 'none');
                $('.categoryprofilepage_coupons_orderby_key1').css('display', 'block');
                $('.categoryprofilepage_coupons_orderby_key2').css('display', 'block');
            } else if (categoryprofilepage_coupons == 'Orderby()->limit()') {
                $('.categoryprofilepage_coupons_limit').css('display', 'block');
                $('.categoryprofilepage_coupons_orderby_key1').css('display', 'block');
                $('.categoryprofilepage_coupons_orderby_key2').css('display', 'block');
            }
        });
        //category profile page categories settings

        $(document).on('change', '.categoryprofilepage_categories', function() {
            var categoryprofilepage_categories = $(this).val();
            console.log(categoryprofilepage_categories);
            if (categoryprofilepage_categories == 'limit()' || categoryprofilepage_categories ==
                'inRandomOrder()->limit()') {
                $('.categoryprofilepage_categories_limit').css('display', 'block');
                $('.categoryprofilepage_categories_orderby_key1').css('display', 'none');
                $('.categoryprofilepage_categories_orderby_key2').css('display', 'none');
            } else if (categoryprofilepage_categories == 'inRandomOrder()') {
                $('.categoryprofilepage_categories_limit').css('display', 'none');
                $('.categoryprofilepage_categories_orderby_key1').css('display', 'none');
                $('.categoryprofilepage_categories_orderby_key2').css('display', 'none');
            } else if (categoryprofilepage_categories == 'Orderby()') {
                $('.categoryprofilepage_categories_limit').css('display', 'none');
                $('.categoryprofilepage_categories_orderby_key1').css('display', 'block');
                $('.categoryprofilepage_categories_orderby_key2').css('display', 'block');
            } else if (categoryprofilepage_categories == 'Orderby()->limit()') {
                $('.categoryprofilepage_categories_limit').css('display', 'block');
                $('.categoryprofilepage_categories_orderby_key1').css('display', 'block');
                $('.categoryprofilepage_categories_orderby_key2').css('display', 'block');
            }
        });
        //category profile page blogs settings

        $(document).on('change', '.categoryprofilepage_blogs', function() {
            var categoryprofilepage_blogs = $(this).val();
            if (categoryprofilepage_blogs == 'limit()' || categoryprofilepage_blogs == 'inRandomOrder()->limit()') {
                $('.categoryprofilepage_blogs_limit').css('display', 'block');
                $('.categoryprofilepage_blogs_orderby_key1').css('display', 'none');
                $('.categoryprofilepage_blogs_orderby_key2').css('display', 'none');
            } else if (categoryprofilepage_blogs == 'inRandomOrder()') {
                $('.categoryprofilepage_blogs_limit').css('display', 'none');
                $('.categoryprofilepage_blogs_orderby_key1').css('display', 'none');
                $('.categoryprofilepage_blogs_orderby_key2').css('display', 'none');
            } else if (categoryprofilepage_blogs == 'Orderby()') {
                $('.categoryprofilepage_blogs_limit').css('display', 'none');
                $('.categoryprofilepage_blogs_orderby_key1').css('display', 'block');
                $('.categoryprofilepage_blogs_orderby_key2').css('display', 'block');
            } else if (categoryprofilepage_blogs == 'Orderby()->limit()') {
                $('.categoryprofilepage_blogs_limit').css('display', 'block');
                $('.categoryprofilepage_blogs_orderby_key1').css('display', 'block');
                $('.categoryprofilepage_blogs_orderby_key2').css('display', 'block');
            }
        });

        //blog profile page stores settings
        $(document).on('change', '.blogprofilepage_stores', function() {
            var blogprofilepage_stores = $(this).val();
            console.log(blogprofilepage_stores);
            if (blogprofilepage_stores == 'limit()' || blogprofilepage_stores == 'inRandomOrder()->limit()') {
                $('.blogprofilepage_stores_limit').css('display', 'block');
                $('.blogprofilepage_stores_orderby_key1').css('display', 'none');
                $('.blogprofilepage_stores_orderby_key2').css('display', 'none');
            } else if (blogprofilepage_stores == 'inRandomOrder()') {
                $('.blogprofilepage_stores_limit').css('display', 'none');
                $('.blogprofilepage_stores_orderby_key1').css('display', 'none');
                $('.blogprofilepage_stores_orderby_key2').css('display', 'none');
            } else if (blogprofilepage_stores == 'Orderby()') {
                $('.blogprofilepage_stores_limit').css('display', 'none');
                $('.blogprofilepage_stores_orderby_key1').css('display', 'block');
                $('.blogprofilepage_stores_orderby_key2').css('display', 'block');
            } else if (blogprofilepage_stores == 'Orderby()->limit()') {
                $('.blogprofilepage_stores_limit').css('display', 'block');
                $('.blogprofilepage_stores_orderby_key1').css('display', 'block');
                $('.blogprofilepage_stores_orderby_key2').css('display', 'block');
            }
        });
        //blog profile page coupons settings

        $(document).on('change', '.blogprofilepage_coupons', function() {
            var blogprofilepage_coupons = $(this).val();
            if (blogprofilepage_coupons == 'limit()' || blogprofilepage_coupons == 'inRandomOrder()->limit()') {
                $('.blogprofilepage_coupons_limit').css('display', 'block');
                $('.blogprofilepage_coupons_orderby_key1').css('display', 'none');
                $('.blogprofilepage_coupons_orderby_key2').css('display', 'none');
            } else if (blogprofilepage_coupons == 'inRandomOrder()') {
                $('.blogprofilepage_coupons_limit').css('display', 'none');
                $('.blogprofilepage_coupons_orderby_key1').css('display', 'none');
                $('.blogprofilepage_coupons_orderby_key2').css('display', 'none');
            } else if (blogprofilepage_coupons == 'Orderby()') {
                $('.blogprofilepage_coupons_limit').css('display', 'none');
                $('.blogprofilepage_coupons_orderby_key1').css('display', 'block');
                $('.blogprofilepage_coupons_orderby_key2').css('display', 'block');
            } else if (blogprofilepage_coupons == 'Orderby()->limit()') {
                $('.blogprofilepage_coupons_limit').css('display', 'block');
                $('.blogprofilepage_coupons_orderby_key1').css('display', 'block');
                $('.blogprofilepage_coupons_orderby_key2').css('display', 'block');
            }
        });
        //blog profile page categories settings

        $(document).on('change', '.blogprofilepage_categories', function() {
            var blogprofilepage_categories = $(this).val();
            console.log(blogprofilepage_categories);
            if (blogprofilepage_categories == 'limit()' || blogprofilepage_categories ==
                'inRandomOrder()->limit()') {
                $('.blogprofilepage_categories_limit').css('display', 'block');
                $('.blogprofilepage_categories_orderby_key1').css('display', 'none');
                $('.blogprofilepage_categories_orderby_key2').css('display', 'none');
            } else if (blogprofilepage_categories == 'inRandomOrder()') {
                $('.blogprofilepage_categories_limit').css('display', 'none');
                $('.blogprofilepage_categories_orderby_key1').css('display', 'none');
                $('.blogprofilepage_categories_orderby_key2').css('display', 'none');
            } else if (blogprofilepage_categories == 'Orderby()') {
                $('.blogprofilepage_categories_limit').css('display', 'none');
                $('.blogprofilepage_categories_orderby_key1').css('display', 'block');
                $('.blogprofilepage_categories_orderby_key2').css('display', 'block');
            } else if (blogprofilepage_categories == 'Orderby()->limit()') {
                $('.blogprofilepage_categories_limit').css('display', 'block');
                $('.blogprofilepage_categories_orderby_key1').css('display', 'block');
                $('.blogprofilepage_categories_orderby_key2').css('display', 'block');
            }
        });
        //blog profile page blogs settings

        $(document).on('change', '.blogprofilepage_blogs', function() {
            var blogprofilepage_blogs = $(this).val();
            if (blogprofilepage_blogs == 'limit()' || blogprofilepage_blogs == 'inRandomOrder()->limit()') {
                $('.blogprofilepage_blogs_limit').css('display', 'block');
                $('.blogprofilepage_blogs_orderby_key1').css('display', 'none');
                $('.blogprofilepage_blogs_orderby_key2').css('display', 'none');
            } else if (blogprofilepage_blogs == 'inRandomOrder()') {
                $('.blogprofilepage_blogs_limit').css('display', 'none');
                $('.blogprofilepage_blogs_orderby_key1').css('display', 'none');
                $('.blogprofilepage_blogs_orderby_key2').css('display', 'none');
            } else if (blogprofilepage_blogs == 'Orderby()') {
                $('.blogprofilepage_blogs_limit').css('display', 'none');
                $('.blogprofilepage_blogs_orderby_key1').css('display', 'block');
                $('.blogprofilepage_blogs_orderby_key2').css('display', 'block');
            } else if (blogprofilepage_blogs == 'Orderby()->limit()') {
                $('.blogprofilepage_blogs_limit').css('display', 'block');
                $('.blogprofilepage_blogs_orderby_key1').css('display', 'block');
                $('.blogprofilepage_blogs_orderby_key2').css('display', 'block');
            }
        });

        //event profile page stores settings
        $(document).on('change', '.eventprofilepage_stores', function() {
            var eventprofilepage_stores = $(this).val();
            console.log(eventprofilepage_stores);
            if (eventprofilepage_stores == 'limit()' || eventprofilepage_stores == 'inRandomOrder()->limit()') {
                $('.eventprofilepage_stores_limit').css('display', 'block');
                $('.eventprofilepage_stores_orderby_key1').css('display', 'none');
                $('.eventprofilepage_stores_orderby_key2').css('display', 'none');
            } else if (eventprofilepage_stores == 'inRandomOrder()') {
                $('.eventprofilepage_stores_limit').css('display', 'none');
                $('.eventprofilepage_storess_orderby_key1').css('display', 'none');
                $('.eventprofilepage_stores_orderby_key2').css('display', 'none');
            } else if (eventprofilepage_stores == 'Orderby()') {
                $('.eventprofilepage_stores_limit').css('display', 'none');
                $('.eventprofilepage_stores_orderby_key1').css('display', 'block');
                $('.eventprofilepage_stores_orderby_key2').css('display', 'block');
            } else if (eventprofilepage_stores == 'Orderby()->limit()') {
                $('.eventprofilepage_stores_limit').css('display', 'block');
                $('.eventprofilepage_stores_orderby_key1').css('display', 'block');
                $('.eventprofilepage_stores_orderby_key2').css('display', 'block');
            }
        });
        //event profile page coupons settings

        $(document).on('change', '.eventprofilepage_coupons', function() {
            var eventprofilepage_coupons = $(this).val();
            if (eventprofilepage_coupons == 'limit()' || eventprofilepage_coupons == 'inRandomOrder()->limit()') {
                $('.eventprofilepage_coupons_limit').css('display', 'block');
                $('.eventprofilepage_coupons_orderby_key1').css('display', 'none');
                $('.eventprofilepage_coupons_orderby_key2').css('display', 'none');
            } else if (eventprofilepage_coupons == 'inRandomOrder()') {
                $('.eventprofilepage_coupons_limit').css('display', 'none');
                $('.eventprofilepage_coupons_orderby_key1').css('display', 'none');
                $('.eventprofilepage_coupons_orderby_key2').css('display', 'none');
            } else if (eventprofilepage_coupons == 'Orderby()') {
                $('.eventprofilepage_coupons_limit').css('display', 'none');
                $('.eventprofilepage_coupons_orderby_key1').css('display', 'block');
                $('.eventprofilepage_coupons_orderby_key2').css('display', 'block');
            } else if (eventprofilepage_coupons == 'Orderby()->limit()') {
                $('.eventprofilepage_coupons_limit').css('display', 'block');
                $('.eventprofilepage_coupons_orderby_key1').css('display', 'block');
                $('.eventprofilepage_coupons_orderby_key2').css('display', 'block');
            }
        });
        //event profile page categories settings

        $(document).on('change', '.eventprofilepage_categories', function() {
            var eventprofilepage_categories = $(this).val();
            console.log(eventprofilepage_categories);
            if (eventprofilepage_categories == 'limit()' || eventprofilepage_categories ==
                'inRandomOrder()->limit()') {
                $('.eventprofilepage_categories_limit').css('display', 'block');
                $('.eventprofilepage_categories_orderby_key1').css('display', 'none');
                $('.eventprofilepage_categories_orderby_key2').css('display', 'none');
            } else if (eventprofilepage_categories == 'inRandomOrder()') {
                $('.eventprofilepage_categories_limit').css('display', 'none');
                $('.eventprofilepage_categories_orderby_key1').css('display', 'none');
                $('.eventprofilepage_categories_orderby_key2').css('display', 'none');
            } else if (eventprofilepage_categories == 'Orderby()') {
                $('.eventprofilepage_categories_limit').css('display', 'none');
                $('.eventprofilepage_categories_orderby_key1').css('display', 'block');
                $('.eventprofilepage_categories_orderby_key2').css('display', 'block');
            } else if (eventprofilepage_categories == 'Orderby()->limit()') {
                $('.eventprofilepage_categories_limit').css('display', 'block');
                $('.eventprofilepage_categories_orderby_key1').css('display', 'block');
                $('.eventprofilepage_categories_orderby_key2').css('display', 'block');
            }
        });
        //event profile page blogs settings

        $(document).on('change', '.eventprofilepage_blogs', function() {
            var eventprofilepage_blogs = $(this).val();
            if (eventprofilepage_blogs == 'limit()' || eventprofilepage_blogs == 'inRandomOrder()->limit()') {
                $('.eventprofilepage_blogs_limit').css('display', 'block');
                $('.eventprofilepage_blogs_orderby_key1').css('display', 'none');
                $('.eventprofilepage_blogs_orderby_key2').css('display', 'none');
            } else if (eventprofilepage_blogs == 'inRandomOrder()') {
                $('.eventprofilepage_blogs_limit').css('display', 'none');
                $('.eventprofilepage_blogs_orderby_key1').css('display', 'none');
                $('.eventprofilepage_blogs_orderby_key2').css('display', 'none');
            } else if (eventprofilepage_blogs == 'Orderby()') {
                $('.eventprofilepage_blogs_limit').css('display', 'none');
                $('.eventprofilepage_blogs_orderby_key1').css('display', 'block');
                $('.eventprofilepage_blogs_orderby_key2').css('display', 'block');
            } else if (eventprofilepage_blogs == 'Orderby()->limit()') {
                $('.eventprofilepage_blogs_limit').css('display', 'block');
                $('.eventprofilepage_blogs_orderby_key1').css('display', 'block');
                $('.eventprofilepage_blogs_orderby_key2').css('display', 'block');
            }
        });

        //footer store settings

        $(document).on('change', '.footer_stores', function() {
            var footer_stores = $(this).val();
            if (footer_stores == 'limit()' || footer_stores == 'inRandomOrder()->limit()') {
                $('.footer_stores_limit').css('display', 'block');
                $('.footer_stores_orderby_key1').css('display', 'none');
                $('.footer_stores_orderby_key2').css('display', 'none');
            } else if (footer_stores == 'inRandomOrder()') {
                $('.footer_stores_limit').css('display', 'none');
                $('.footer_stores_orderby_key1').css('display', 'none');
                $('.footer_stores_orderby_key2').css('display', 'none');
            } else if (footer_stores == 'Orderby()') {
                $('.footer_stores_limit').css('display', 'none');
                $('.footer_stores_orderby_key1').css('display', 'block');
                $('.footer_stores_orderby_key2').css('display', 'block');
            } else if (footer_stores == 'Orderby()->limit()') {
                $('.footer_stores_limit').css('display', 'block');
                $('.footer_stores_orderby_key1').css('display', 'block');
                $('.footer_stores_orderby_key2').css('display', 'block');
            }
        });
        //footer categories settings

        $(document).on('change', '.footer_categories', function() {
            var footer_categories = $(this).val();
            console.log(footer_categories);
            if (footer_categories == 'limit()' || footer_categories == 'inRandomOrder()->limit()') {
                $('.footer_categories_limit').css('display', 'block');
                $('.footer_categories_orderby_key1').css('display', 'none');
                $('.footer_categories_orderby_key2').css('display', 'none');
            } else if (footer_categories == 'inRandomOrder()') {
                $('.footer_categories_limit').css('display', 'none');
                $('.footer_categories_orderby_key1').css('display', 'none');
                $('.footer_categories_orderby_key2').css('display', 'none');
            } else if (footer_categories == 'Orderby()') {
                $('.footer_categories_limit').css('display', 'none');
                $('.footer_categories_orderby_key1').css('display', 'block');
                $('.footer_categories_orderby_key2').css('display', 'block');
            } else if (footer_categories == 'Orderby()->limit()') {
                $('.footer_categories_limit').css('display', 'block');
                $('.footer_categories_orderby_key1').css('display', 'block');
                $('.footer_categories_orderby_key2').css('display', 'block');
            }
        });
        //event profile page blogs settings

        $(document).on('change', '.footer_blogs', function() {
            var footer_blogs = $(this).val();
            if (footer_blogs == 'limit()' || footer_blogs == 'inRandomOrder()->limit()') {
                $('.footer_blogs_limit').css('display', 'block');
                $('.footer_blogs_orderby_key1').css('display', 'none');
                $('.footer_blogs_orderby_key2').css('display', 'none');
            } else if (footer_blogs == 'inRandomOrder()') {
                $('.footer_blogs_limit').css('display', 'none');
                $('.footer_blogs_orderby_key1').css('display', 'none');
                $('.footer_blogs_orderby_key2').css('display', 'none');
            } else if (footer_blogs == 'Orderby()') {
                $('.footer_blogs_limit').css('display', 'none');
                $('.footer_blogs_orderby_key1').css('display', 'block');
                $('.footer_blogs_orderby_key2').css('display', 'block');
            } else if (footer_blogs == 'Orderby()->limit()') {
                $('.footer_blogs_limit').css('display', 'block');
                $('.footer_blogs_orderby_key1').css('display', 'block');
                $('.footer_blogs_orderby_key2').css('display', 'block');
            }
        });
    </script>
@endsection
