
@extends('admin.layouts.app')
@section('custom-styles')
    <!-- Bootstrap Select Css -->
    <link href="{{ asset('admin-assets/css/bootstrap-select.css') }}" rel="stylesheet" />
@endsection
@section('content')

<div class="row clearfix">
  <div class="col-lg-12 col-md-12 col-sm-12">
      <div class="card">
          <div class="header">
              <h2><strong>Social </strong>Media</h2>

          </div>
          <div class="mt-2">
              @include('admin.layouts.partials.messages')
          </div>
          <div class="body">
              @if (count($errors) > 0)
                  <div class="alert alert-danger">
                      <strong>Whoops!</strong> There were some problems with your input.<br><br>
                      <ul>
                          @foreach ($errors->all() as $error)
                              <li>{{ $error }}</li>
                          @endforeach
                      </ul>
                  </div>
              @endif
          <form method="POST" action="{{route('update.social.media')}}" enctype="multipart/form-data">
            @csrf
            
            <input type="hidden" value="{{$socialmedia->id}}" name="id">
            <div class="row">
              <div class="col-12">
                <label class="form-label">Title</label>
                <input type="text" class="form-control" name="title" value="{{$socialmedia->title}}">
              </div>
              <div class="col-12">
                <label class="form-label">Url</label>
                <input type="text" class="form-control" name="url" value="{{$socialmedia->url}}">
              </div>
              <div class="col-12">
                <label class="form-label">Icon</label>
                <select name="icon" class="form-control">
                    <option value="{{$socialmedia->icon}}">{{$socialmedia->icon}}</option>
                  <option value="">--Select Icon--</option>
                   <option value="fab fa-facebook">fab fa-facebook</option>
                  <option value="fab fa-twitter">fab fa-twitter</option>
                  <option value="fab fa-instagram">fab fa-instagram</option>
                  <option value="fab fa-google-plus">fab fa-google-plus</option>
                  <option value="fab fa-pinterest">fab fa-pinterest</option>
                  <option value="fab fa-linkedin">fab fa-linkedin</option>
                  <option value="fab fa-youtube">fab fa-youtube</option>
                </select>
              </div>
            </div>
            <br>
            <div class="col-12">
              <div class="d-grid">
                <button type="submit" class="btn btn-primary">Save</button>
              </div>
            </div>
          </form>
        </div>
      </div>
  </div>
</div>
@endsection
