@extends('admin.layouts.app')

@section('content')
    <div class="row clearfix">
        <div class="col-lg-12">
            <div class="card">
                <div class="header">
                    <h2><strong>All</strong> Pages </h2>
                    <ul class="header-dropdown">
                        <li class="dropdown">
                            <a href="{{ route('pages.create') }}" class="btn btn-primary btn-sm float-right">Add
                                Page</a>
                        </li>
                    </ul>
                </div>
                <div class="mt-2">
                    @include('admin.layouts.partials.messages')
                </div>
                <div class="body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover js-basic-example dataTable">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tfoot>
                                <tr>
                                    <th>Name</th>
                                    <th>Actions</th>
                                </tr>
                            </tfoot>
                            <tbody>
                                @foreach ($pages as $key => $page)
                                    <tr>
                                        <td>{{ $page->title }}</td>
                                        <td>
                                            <a class="btn btn-primary btn-sm"
                                                href="{{ route('pages.edit', $page->id) }}">Edit</a>

                                            {!! Form::open(['method' => 'DELETE', 'route' => ['pages.destroy', $page->id], 'style' => 'display:inline']) !!}
                                            {!! Form::submit('Delete', ['class' => 'btn btn-danger btn-sm']) !!}
                                            {!! Form::close() !!}
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('custom-scripts')
    
@endsection
