@extends('admin.layouts.app')

@section('content')
    <div class="row clearfix">
        <div class="col-lg-12">
            <div class="card">
                <div class="header">
                    <h2><strong>All</strong> Coupons </h2>
                    <ul class="header-dropdown">
                        <li class="dropdown">
                            <a href="{{ route('coupons.create') }}" class="btn btn-primary btn-sm float-right">Add
                                Coupon</a>
                        </li>
                    </ul>
                </div>
                <div class="mt-2">
                    @include('admin.layouts.partials.messages')
                </div>
                <div class="body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover js-basic-example dataTable">
                            <thead>
                                <tr>
                                    <th>Image</th>
                                    <th>Title</th>
                                    <th>Code</th>
                                    <th>Store</th>
                                    <th>Url</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tfoot>
                                <tr>
                                    <th>Image</th>
                                    <th>Title</th>
                                    <th>Code</th>
                                    <th>Store</th>
                                    <th>Url</th>
                                    <th>Actions</th>
                                </tr>
                            </tfoot>
                            <tbody>
                                @foreach ($coupons as $key => $coupon)
                                    <tr>
                                        <td><img src="{{ asset('admin-assets/images/stores') }}/{{ $coupon->store->feature_image }}"
                                                alt="" width="40"></td>
                                        <td>{{ $coupon->title }}</td>
                                        <td>{{ $coupon->code }}</td>
                                        <td>{{ $coupon->store->name }}</td>
                                        <td><a href="{{$coupon->url}}"><i class="zmdi zmdi-link"></i></a></td>
                                        <td>
                                            <a class="btn btn-primary btn-sm"
                                                href="{{ route('coupons.edit', $coupon->id) }}">Edit</a>

                                            {!! Form::open(['method' => 'DELETE', 'route' => ['coupons.destroy', $coupon->id], 'style' => 'display:inline']) !!}
                                            {!! Form::submit('Delete', ['class' => 'btn btn-danger btn-sm']) !!}
                                            {!! Form::close() !!}
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        <div class="d-flex">
                            {!! $coupons->links('pagination::bootstrap-4') !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('custom-scripts')
  
@endsection
