@extends('admin.layouts.app')

@section('content')
    <div class="row clearfix">
        <div class="col-lg-12">
            <div class="card">
                <div class="header">
                    <h2><strong>All</strong> Categories </h2>
                    <ul class="header-dropdown">
                        <li class="dropdown">
                            <a href="{{ route('categories.create') }}" class="btn btn-primary btn-sm float-right">Add
                                Category</a>
                        </li>
                    </ul>
                </div>
                <div class="mt-2">
                    @include('admin.layouts.partials.messages')
                </div>
                <div class="body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover js-basic-example dataTable">
                            <thead>
                                <tr>
                                    <th>Logo</th>
                                    <th>Image</th>
                                    <th>Name</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tfoot>
                                <tr>
                                    <th>Logo</th>
                                    <th>Image</th>
                                    <th>Name</th>
                                    <th>Actions</th>
                                </tr>
                            </tfoot>
                            <tbody>
                                @foreach ($categories as $key => $category)
                                    <tr>
                                        <td><img src="{{asset('admin-assets/images/categories')}}/{{$category->logo_image}}" alt="" width="40"></td>
                                        <td><img src="{{asset('admin-assets/images/categories')}}/{{$category->feature_image}}" alt="" width="40"></td>
                                        <td>{{ $category->name }}</td>
                                        <td>
                                            <a class="btn btn-primary btn-sm" href="{{ route('categories.edit', $category->id) }}">Edit</a>
                                        
                                            {!! Form::open(['method' => 'DELETE','route' => ['categories.destroy', $category->id],'style'=>'display:inline']) !!}
                                            {!! Form::submit('Delete', ['class' => 'btn btn-danger btn-sm']) !!}
                                            {!! Form::close() !!}
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        <div class="d-flex">
                            {!! $categories->links('pagination::bootstrap-4') !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('custom-scripts')
   
@endsection