@extends('admin.layouts.app')

@section('content')
    <div class="row clearfix">
        <div class="col-lg-12">
            <div class="card">
                <div class="header">
                    <h2><strong>All</strong> Blogs </h2>
                    <ul class="header-dropdown">
                        <li class="dropdown">
                            <a href="{{ route('blogs.create') }}" class="btn btn-primary btn-sm float-right">Add
                                Blog</a>
                        </li>
                    </ul>
                </div>
                <div class="mt-2">
                    @include('admin.layouts.partials.messages')
                </div>
                <div class="body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover js-basic-example dataTable">
                            <thead>
                                <tr>
                                    <th>Image</th>
                                    <th>Name</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tfoot>
                                <tr>
                                    <th>Image</th>
                                    <th>Name</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </tfoot>
                            <tbody>
                                @foreach ($blogs as $key => $blog)
                                    <tr>
                                        <td><img src="{{ asset('admin-assets/images/blogs') }}/{{ $blog->feature_image }}"
                                                alt="" width="40"></td>
                                        <td>{{ $blog->title }}</td>
                                        <td>@if($blog->status == 'publish') <span class="badge badge-success">Published</span> @else <span class="badge badge-primary">Draft</span> @endif</td>
                                        <td>
                                            <a class="btn btn-primary btn-sm"
                                                href="{{ route('blogs.edit', $blog->id) }}">Edit</a>

                                            {!! Form::open(['method' => 'DELETE', 'route' => ['blogs.destroy', $blog->id], 'style' => 'display:inline']) !!}
                                            {!! Form::submit('Delete', ['class' => 'btn btn-danger btn-sm']) !!}
                                            {!! Form::close() !!}
                                            
                                            <a class="btn btn-info btn-sm"
                                                href="{{ route('blog.details', $blog->slug) }}">Preview</a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        <div class="d-flex">
                            {!! $blogs->links('pagination::bootstrap-4') !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('custom-scripts')
    <script>
        $(".alert").delay(4000).slideUp(200, function() {
            $(this).alert('close');
        });
    </script>
@endsection
