@extends('admin.layouts.app')
@section('custom-styles')
    <!-- Bootstrap Select Css -->
    <link href="{{ asset('admin-assets/css/bootstrap-select.css') }}" rel="stylesheet" />
@endsection
@section('content')
    <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12">
            <div class="card">
                <div class="header">
                    <h2><strong>Edit </strong> Blog</h2>

                </div>
                <div class="mt-2">
                    @include('admin.layouts.partials.messages')
                </div>
                <div class="body">
                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <strong>Whoops!</strong> There were some problems with your input.<br><br>
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form method="POST" action="{{ route('blogs.update',$blog->id) }}" autocomplete="off"
                        enctype="multipart/form-data">
                        @method('patch')
                        @csrf
                        <label for="title">Title</label>
                        <div class="form-group">
                            <input type="text" id="title" class="form-control" placeholder="Enter Blog Title"
                                name="title" value="{{ $blog->title }}" required>

                        </div>
                        <label class="form-label">Category</label>
                        <div class="form-group">
                            <select class="form-control show-tick" name="category_id" id="category">
                                <option value="{{ $blog->category_id }}">{{ $blog->category->name }}</option>
                                <option value="">--select Category--</option>
                                @foreach ($categories as $key => $category)
                                    <option value="{{ $key }}">{{ $category }}</option>
                                @endforeach
                            </select>
                        </div>
                        <label class="form-label">Sub Category</label>
                        <div class="form-group">
                            <select class="form-control show-tick" name="sub_category_id" id="subcategory">
                                <option value="{{$blog->sub_category_id}}">{{$blog->sub_category->name}}</option>
                                <option value="">--select Sub Category--</option>
                                @foreach ($subcategories as $key => $subcategory)
                                    <option value="{{ $subcategory->id }}">{{ $subcategory->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <label for="blog_description">Blog Description</label>
                        <div class="form-group">
                            <textarea id="ckeditor" name="description" placeholder="Entere Blog Description">{{ $blog->description }}</textarea>

                        </div>
                        <label for="meta_title">Meta Title</label>
                        <div class="form-group">
                            <input type="text" id="meta_title" class="form-control" placeholder="Enter Meta Title"
                                name="meta_title" value="{{ $blog->meta_title }}">

                        </div>
                        <label for="meta_description">Meta Description</label>
                        <div class="form-group">
                            <textarea id="meta_description" class="form-control" name="meta_description" placeholder="Entere Meta Description">{{ $blog->meta_description }}</textarea>

                        </div>
                        <label class="form-label">Type</label>
                        <div class="form-group">
                            <select class="form-control show-tick" name="type">
                                <option value="{{ $blog->type }}">{{ $blog->type }}</option>
                                <option value="">--select Type--</option>

                                <option value="featured">Featured</option>
                                <option value="latest">Latest</option>
                                <option value="popular">Most popular</option>
                            </select>
                        </div>
                        <label for="feature_image">Feature Image</label>
                        <div class="form-group">
                            <input type="file" id="feature_image" class="form-control" name="featured_image">

                        </div>
                        <label class="form-label">Status</label>
                        <div class="form-group">
                            <select class="form-control" name="status">
                                <option value="{{$blog->status}}">{{$blog->status}}</option>
                                <option value="">--select Status--</option>
                                <option value="publish">publish</option>
                                <option value="draft">draft</option>
                            </select>
                        </div>
                        <button type="submit" class="btn btn-raised btn-primary  waves-effect">Save</button>
                        <a href="{{ route('blogs.index') }}" class="btn btn-default">Back</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('custom-scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js" integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://www.wrraptheme.com/templates/alpino/main/assets/plugins/ckeditor/ckeditor.js"></script>
<script src="{{ asset('admin-assets/js/editors.js') }}"></script>
    <script>

        $(document).on('change', '#category', function() {
            //  alert();
            var cateid = this.value;
            console.log(cateid);
            $.ajax({
                type: "GET",
                url: "{{ route('sub-category-api') }}",
                data: {
                    categoryid: cateid
                },
                success: function(result) {
                    var opt = '';
                    for (var i = 0; i < result.subcategory.length; i++) {
                        opt += '<option value="' + result.subcategory[i].id + '">' + result.subcategory[
                            i].name + '</option>';
                    }
                    $('#subcategory').html(opt);
                },
                error: function(error) {
                    toastr.error(error.message);
                }
            });
        });
    </script>
@endsection