import "./chunk-6TJCVOLN.js";

// node_modules/laravel-echo/dist/echo.js
function _typeof(obj) {
  "@babel/helpers - typeof";
  return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof(obj);
}
function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", {
    writable: false
  });
  return Constructor;
}
function _extends() {
  _extends = Object.assign || function(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}
function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      writable: true,
      configurable: true
    }
  });
  Object.defineProperty(subClass, "prototype", {
    writable: false
  });
  if (superClass)
    _setPrototypeOf(subClass, superClass);
}
function _getPrototypeOf(o) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf2(o2) {
    return o2.__proto__ || Object.getPrototypeOf(o2);
  };
  return _getPrototypeOf(o);
}
function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf2(o2, p2) {
    o2.__proto__ = p2;
    return o2;
  };
  return _setPrototypeOf(o, p);
}
function _isNativeReflectConstruct() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e) {
    return false;
  }
}
function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self;
}
function _possibleConstructorReturn(self, call) {
  if (call && (typeof call === "object" || typeof call === "function")) {
    return call;
  } else if (call !== void 0) {
    throw new TypeError("Derived constructors may only return object or undefined");
  }
  return _assertThisInitialized(self);
}
function _createSuper(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn(this, result);
  };
}
var Channel = function() {
  function Channel2() {
    _classCallCheck(this, Channel2);
  }
  _createClass(Channel2, [{
    key: "listenForWhisper",
    value: (
      /**
       * Listen for a whisper event on the channel instance.
       */
      function listenForWhisper(event, callback) {
        return this.listen(".client-" + event, callback);
      }
    )
    /**
     * Listen for an event on the channel instance.
     */
  }, {
    key: "notification",
    value: function notification(callback) {
      return this.listen(".Illuminate\\Notifications\\Events\\BroadcastNotificationCreated", callback);
    }
    /**
     * Stop listening for a whisper event on the channel instance.
     */
  }, {
    key: "stopListeningForWhisper",
    value: function stopListeningForWhisper(event, callback) {
      return this.stopListening(".client-" + event, callback);
    }
  }]);
  return Channel2;
}();
var EventFormatter = function() {
  function EventFormatter2(namespace) {
    _classCallCheck(this, EventFormatter2);
    this.namespace = namespace;
  }
  _createClass(EventFormatter2, [{
    key: "format",
    value: function format(event) {
      if ([".", "\\"].includes(event.charAt(0))) {
        return event.substring(1);
      } else if (this.namespace) {
        event = this.namespace + "." + event;
      }
      return event.replace(/\./g, "\\");
    }
    /**
     * Set the event namespace.
     */
  }, {
    key: "setNamespace",
    value: function setNamespace(value) {
      this.namespace = value;
    }
  }]);
  return EventFormatter2;
}();
var PusherChannel = function(_Channel) {
  _inherits(PusherChannel2, _Channel);
  var _super = _createSuper(PusherChannel2);
  function PusherChannel2(pusher, name, options) {
    var _this;
    _classCallCheck(this, PusherChannel2);
    _this = _super.call(this);
    _this.name = name;
    _this.pusher = pusher;
    _this.options = options;
    _this.eventFormatter = new EventFormatter(_this.options.namespace);
    _this.subscribe();
    return _this;
  }
  _createClass(PusherChannel2, [{
    key: "subscribe",
    value: function subscribe() {
      this.subscription = this.pusher.subscribe(this.name);
    }
    /**
     * Unsubscribe from a Pusher channel.
     */
  }, {
    key: "unsubscribe",
    value: function unsubscribe() {
      this.pusher.unsubscribe(this.name);
    }
    /**
     * Listen for an event on the channel instance.
     */
  }, {
    key: "listen",
    value: function listen(event, callback) {
      this.on(this.eventFormatter.format(event), callback);
      return this;
    }
    /**
     * Listen for all events on the channel instance.
     */
  }, {
    key: "listenToAll",
    value: function listenToAll(callback) {
      var _this2 = this;
      this.subscription.bind_global(function(event, data) {
        if (event.startsWith("pusher:")) {
          return;
        }
        var namespace = _this2.options.namespace.replace(/\./g, "\\");
        var formattedEvent = event.startsWith(namespace) ? event.substring(namespace.length + 1) : "." + event;
        callback(formattedEvent, data);
      });
      return this;
    }
    /**
     * Stop listening for an event on the channel instance.
     */
  }, {
    key: "stopListening",
    value: function stopListening(event, callback) {
      if (callback) {
        this.subscription.unbind(this.eventFormatter.format(event), callback);
      } else {
        this.subscription.unbind(this.eventFormatter.format(event));
      }
      return this;
    }
    /**
     * Stop listening for all events on the channel instance.
     */
  }, {
    key: "stopListeningToAll",
    value: function stopListeningToAll(callback) {
      if (callback) {
        this.subscription.unbind_global(callback);
      } else {
        this.subscription.unbind_global();
      }
      return this;
    }
    /**
     * Register a callback to be called anytime a subscription succeeds.
     */
  }, {
    key: "subscribed",
    value: function subscribed(callback) {
      this.on("pusher:subscription_succeeded", function() {
        callback();
      });
      return this;
    }
    /**
     * Register a callback to be called anytime a subscription error occurs.
     */
  }, {
    key: "error",
    value: function error(callback) {
      this.on("pusher:subscription_error", function(status) {
        callback(status);
      });
      return this;
    }
    /**
     * Bind a channel to an event.
     */
  }, {
    key: "on",
    value: function on(event, callback) {
      this.subscription.bind(event, callback);
      return this;
    }
  }]);
  return PusherChannel2;
}(Channel);
var PusherPrivateChannel = function(_PusherChannel) {
  _inherits(PusherPrivateChannel2, _PusherChannel);
  var _super = _createSuper(PusherPrivateChannel2);
  function PusherPrivateChannel2() {
    _classCallCheck(this, PusherPrivateChannel2);
    return _super.apply(this, arguments);
  }
  _createClass(PusherPrivateChannel2, [{
    key: "whisper",
    value: (
      /**
       * Send a whisper event to other clients in the channel.
       */
      function whisper(eventName, data) {
        this.pusher.channels.channels[this.name].trigger("client-".concat(eventName), data);
        return this;
      }
    )
  }]);
  return PusherPrivateChannel2;
}(PusherChannel);
var PusherEncryptedPrivateChannel = function(_PusherChannel) {
  _inherits(PusherEncryptedPrivateChannel2, _PusherChannel);
  var _super = _createSuper(PusherEncryptedPrivateChannel2);
  function PusherEncryptedPrivateChannel2() {
    _classCallCheck(this, PusherEncryptedPrivateChannel2);
    return _super.apply(this, arguments);
  }
  _createClass(PusherEncryptedPrivateChannel2, [{
    key: "whisper",
    value: (
      /**
       * Send a whisper event to other clients in the channel.
       */
      function whisper(eventName, data) {
        this.pusher.channels.channels[this.name].trigger("client-".concat(eventName), data);
        return this;
      }
    )
  }]);
  return PusherEncryptedPrivateChannel2;
}(PusherChannel);
var PusherPresenceChannel = function(_PusherChannel) {
  _inherits(PusherPresenceChannel2, _PusherChannel);
  var _super = _createSuper(PusherPresenceChannel2);
  function PusherPresenceChannel2() {
    _classCallCheck(this, PusherPresenceChannel2);
    return _super.apply(this, arguments);
  }
  _createClass(PusherPresenceChannel2, [{
    key: "here",
    value: (
      /**
       * Register a callback to be called anytime the member list changes.
       */
      function here(callback) {
        this.on("pusher:subscription_succeeded", function(data) {
          callback(Object.keys(data.members).map(function(k) {
            return data.members[k];
          }));
        });
        return this;
      }
    )
    /**
     * Listen for someone joining the channel.
     */
  }, {
    key: "joining",
    value: function joining(callback) {
      this.on("pusher:member_added", function(member) {
        callback(member.info);
      });
      return this;
    }
    /**
     * Send a whisper event to other clients in the channel.
     */
  }, {
    key: "whisper",
    value: function whisper(eventName, data) {
      this.pusher.channels.channels[this.name].trigger("client-".concat(eventName), data);
      return this;
    }
    /**
     * Listen for someone leaving the channel.
     */
  }, {
    key: "leaving",
    value: function leaving(callback) {
      this.on("pusher:member_removed", function(member) {
        callback(member.info);
      });
      return this;
    }
  }]);
  return PusherPresenceChannel2;
}(PusherChannel);
var SocketIoChannel = function(_Channel) {
  _inherits(SocketIoChannel2, _Channel);
  var _super = _createSuper(SocketIoChannel2);
  function SocketIoChannel2(socket, name, options) {
    var _this;
    _classCallCheck(this, SocketIoChannel2);
    _this = _super.call(this);
    _this.events = {};
    _this.listeners = {};
    _this.name = name;
    _this.socket = socket;
    _this.options = options;
    _this.eventFormatter = new EventFormatter(_this.options.namespace);
    _this.subscribe();
    return _this;
  }
  _createClass(SocketIoChannel2, [{
    key: "subscribe",
    value: function subscribe() {
      this.socket.emit("subscribe", {
        channel: this.name,
        auth: this.options.auth || {}
      });
    }
    /**
     * Unsubscribe from channel and ubind event callbacks.
     */
  }, {
    key: "unsubscribe",
    value: function unsubscribe() {
      this.unbind();
      this.socket.emit("unsubscribe", {
        channel: this.name,
        auth: this.options.auth || {}
      });
    }
    /**
     * Listen for an event on the channel instance.
     */
  }, {
    key: "listen",
    value: function listen(event, callback) {
      this.on(this.eventFormatter.format(event), callback);
      return this;
    }
    /**
     * Stop listening for an event on the channel instance.
     */
  }, {
    key: "stopListening",
    value: function stopListening(event, callback) {
      this.unbindEvent(this.eventFormatter.format(event), callback);
      return this;
    }
    /**
     * Register a callback to be called anytime a subscription succeeds.
     */
  }, {
    key: "subscribed",
    value: function subscribed(callback) {
      this.on("connect", function(socket) {
        callback(socket);
      });
      return this;
    }
    /**
     * Register a callback to be called anytime an error occurs.
     */
  }, {
    key: "error",
    value: function error(callback) {
      return this;
    }
    /**
     * Bind the channel's socket to an event and store the callback.
     */
  }, {
    key: "on",
    value: function on(event, callback) {
      var _this2 = this;
      this.listeners[event] = this.listeners[event] || [];
      if (!this.events[event]) {
        this.events[event] = function(channel, data) {
          if (_this2.name === channel && _this2.listeners[event]) {
            _this2.listeners[event].forEach(function(cb) {
              return cb(data);
            });
          }
        };
        this.socket.on(event, this.events[event]);
      }
      this.listeners[event].push(callback);
      return this;
    }
    /**
     * Unbind the channel's socket from all stored event callbacks.
     */
  }, {
    key: "unbind",
    value: function unbind() {
      var _this3 = this;
      Object.keys(this.events).forEach(function(event) {
        _this3.unbindEvent(event);
      });
    }
    /**
     * Unbind the listeners for the given event.
     */
  }, {
    key: "unbindEvent",
    value: function unbindEvent(event, callback) {
      this.listeners[event] = this.listeners[event] || [];
      if (callback) {
        this.listeners[event] = this.listeners[event].filter(function(cb) {
          return cb !== callback;
        });
      }
      if (!callback || this.listeners[event].length === 0) {
        if (this.events[event]) {
          this.socket.removeListener(event, this.events[event]);
          delete this.events[event];
        }
        delete this.listeners[event];
      }
    }
  }]);
  return SocketIoChannel2;
}(Channel);
var SocketIoPrivateChannel = function(_SocketIoChannel) {
  _inherits(SocketIoPrivateChannel2, _SocketIoChannel);
  var _super = _createSuper(SocketIoPrivateChannel2);
  function SocketIoPrivateChannel2() {
    _classCallCheck(this, SocketIoPrivateChannel2);
    return _super.apply(this, arguments);
  }
  _createClass(SocketIoPrivateChannel2, [{
    key: "whisper",
    value: (
      /**
       * Send a whisper event to other clients in the channel.
       */
      function whisper(eventName, data) {
        this.socket.emit("client event", {
          channel: this.name,
          event: "client-".concat(eventName),
          data
        });
        return this;
      }
    )
  }]);
  return SocketIoPrivateChannel2;
}(SocketIoChannel);
var SocketIoPresenceChannel = function(_SocketIoPrivateChann) {
  _inherits(SocketIoPresenceChannel2, _SocketIoPrivateChann);
  var _super = _createSuper(SocketIoPresenceChannel2);
  function SocketIoPresenceChannel2() {
    _classCallCheck(this, SocketIoPresenceChannel2);
    return _super.apply(this, arguments);
  }
  _createClass(SocketIoPresenceChannel2, [{
    key: "here",
    value: (
      /**
       * Register a callback to be called anytime the member list changes.
       */
      function here(callback) {
        this.on("presence:subscribed", function(members) {
          callback(members.map(function(m) {
            return m.user_info;
          }));
        });
        return this;
      }
    )
    /**
     * Listen for someone joining the channel.
     */
  }, {
    key: "joining",
    value: function joining(callback) {
      this.on("presence:joining", function(member) {
        return callback(member.user_info);
      });
      return this;
    }
    /**
     * Send a whisper event to other clients in the channel.
     */
  }, {
    key: "whisper",
    value: function whisper(eventName, data) {
      this.socket.emit("client event", {
        channel: this.name,
        event: "client-".concat(eventName),
        data
      });
      return this;
    }
    /**
     * Listen for someone leaving the channel.
     */
  }, {
    key: "leaving",
    value: function leaving(callback) {
      this.on("presence:leaving", function(member) {
        return callback(member.user_info);
      });
      return this;
    }
  }]);
  return SocketIoPresenceChannel2;
}(SocketIoPrivateChannel);
var NullChannel = function(_Channel) {
  _inherits(NullChannel2, _Channel);
  var _super = _createSuper(NullChannel2);
  function NullChannel2() {
    _classCallCheck(this, NullChannel2);
    return _super.apply(this, arguments);
  }
  _createClass(NullChannel2, [{
    key: "subscribe",
    value: (
      /**
       * Subscribe to a channel.
       */
      function subscribe() {
      }
    )
    /**
     * Unsubscribe from a channel.
     */
  }, {
    key: "unsubscribe",
    value: function unsubscribe() {
    }
    /**
     * Listen for an event on the channel instance.
     */
  }, {
    key: "listen",
    value: function listen(event, callback) {
      return this;
    }
    /**
     * Listen for all events on the channel instance.
     */
  }, {
    key: "listenToAll",
    value: function listenToAll(callback) {
      return this;
    }
    /**
     * Stop listening for an event on the channel instance.
     */
  }, {
    key: "stopListening",
    value: function stopListening(event, callback) {
      return this;
    }
    /**
     * Register a callback to be called anytime a subscription succeeds.
     */
  }, {
    key: "subscribed",
    value: function subscribed(callback) {
      return this;
    }
    /**
     * Register a callback to be called anytime an error occurs.
     */
  }, {
    key: "error",
    value: function error(callback) {
      return this;
    }
    /**
     * Bind a channel to an event.
     */
  }, {
    key: "on",
    value: function on(event, callback) {
      return this;
    }
  }]);
  return NullChannel2;
}(Channel);
var NullPrivateChannel = function(_NullChannel) {
  _inherits(NullPrivateChannel2, _NullChannel);
  var _super = _createSuper(NullPrivateChannel2);
  function NullPrivateChannel2() {
    _classCallCheck(this, NullPrivateChannel2);
    return _super.apply(this, arguments);
  }
  _createClass(NullPrivateChannel2, [{
    key: "whisper",
    value: (
      /**
       * Send a whisper event to other clients in the channel.
       */
      function whisper(eventName, data) {
        return this;
      }
    )
  }]);
  return NullPrivateChannel2;
}(NullChannel);
var NullPresenceChannel = function(_NullChannel) {
  _inherits(NullPresenceChannel2, _NullChannel);
  var _super = _createSuper(NullPresenceChannel2);
  function NullPresenceChannel2() {
    _classCallCheck(this, NullPresenceChannel2);
    return _super.apply(this, arguments);
  }
  _createClass(NullPresenceChannel2, [{
    key: "here",
    value: (
      /**
       * Register a callback to be called anytime the member list changes.
       */
      function here(callback) {
        return this;
      }
    )
    /**
     * Listen for someone joining the channel.
     */
  }, {
    key: "joining",
    value: function joining(callback) {
      return this;
    }
    /**
     * Send a whisper event to other clients in the channel.
     */
  }, {
    key: "whisper",
    value: function whisper(eventName, data) {
      return this;
    }
    /**
     * Listen for someone leaving the channel.
     */
  }, {
    key: "leaving",
    value: function leaving(callback) {
      return this;
    }
  }]);
  return NullPresenceChannel2;
}(NullChannel);
var Connector = function() {
  function Connector2(options) {
    _classCallCheck(this, Connector2);
    this._defaultOptions = {
      auth: {
        headers: {}
      },
      authEndpoint: "/broadcasting/auth",
      userAuthentication: {
        endpoint: "/broadcasting/user-auth",
        headers: {}
      },
      broadcaster: "pusher",
      csrfToken: null,
      bearerToken: null,
      host: null,
      key: null,
      namespace: "App.Events"
    };
    this.setOptions(options);
    this.connect();
  }
  _createClass(Connector2, [{
    key: "setOptions",
    value: function setOptions(options) {
      this.options = _extends(this._defaultOptions, options);
      var token = this.csrfToken();
      if (token) {
        this.options.auth.headers["X-CSRF-TOKEN"] = token;
        this.options.userAuthentication.headers["X-CSRF-TOKEN"] = token;
      }
      token = this.options.bearerToken;
      if (token) {
        this.options.auth.headers["Authorization"] = "Bearer " + token;
        this.options.userAuthentication.headers["Authorization"] = "Bearer " + token;
      }
      return options;
    }
    /**
     * Extract the CSRF token from the page.
     */
  }, {
    key: "csrfToken",
    value: function csrfToken() {
      var selector;
      if (typeof window !== "undefined" && window["Laravel"] && window["Laravel"].csrfToken) {
        return window["Laravel"].csrfToken;
      } else if (this.options.csrfToken) {
        return this.options.csrfToken;
      } else if (typeof document !== "undefined" && typeof document.querySelector === "function" && (selector = document.querySelector('meta[name="csrf-token"]'))) {
        return selector.getAttribute("content");
      }
      return null;
    }
  }]);
  return Connector2;
}();
var PusherConnector = function(_Connector) {
  _inherits(PusherConnector2, _Connector);
  var _super = _createSuper(PusherConnector2);
  function PusherConnector2() {
    var _this;
    _classCallCheck(this, PusherConnector2);
    _this = _super.apply(this, arguments);
    _this.channels = {};
    return _this;
  }
  _createClass(PusherConnector2, [{
    key: "connect",
    value: function connect() {
      if (typeof this.options.client !== "undefined") {
        this.pusher = this.options.client;
      } else if (this.options.Pusher) {
        this.pusher = new this.options.Pusher(this.options.key, this.options);
      } else {
        this.pusher = new Pusher(this.options.key, this.options);
      }
    }
    /**
     * Sign in the user via Pusher user authentication (https://pusher.com/docs/channels/using_channels/user-authentication/).
     */
  }, {
    key: "signin",
    value: function signin() {
      this.pusher.signin();
    }
    /**
     * Listen for an event on a channel instance.
     */
  }, {
    key: "listen",
    value: function listen(name, event, callback) {
      return this.channel(name).listen(event, callback);
    }
    /**
     * Get a channel instance by name.
     */
  }, {
    key: "channel",
    value: function channel(name) {
      if (!this.channels[name]) {
        this.channels[name] = new PusherChannel(this.pusher, name, this.options);
      }
      return this.channels[name];
    }
    /**
     * Get a private channel instance by name.
     */
  }, {
    key: "privateChannel",
    value: function privateChannel(name) {
      if (!this.channels["private-" + name]) {
        this.channels["private-" + name] = new PusherPrivateChannel(this.pusher, "private-" + name, this.options);
      }
      return this.channels["private-" + name];
    }
    /**
     * Get a private encrypted channel instance by name.
     */
  }, {
    key: "encryptedPrivateChannel",
    value: function encryptedPrivateChannel(name) {
      if (!this.channels["private-encrypted-" + name]) {
        this.channels["private-encrypted-" + name] = new PusherEncryptedPrivateChannel(this.pusher, "private-encrypted-" + name, this.options);
      }
      return this.channels["private-encrypted-" + name];
    }
    /**
     * Get a presence channel instance by name.
     */
  }, {
    key: "presenceChannel",
    value: function presenceChannel(name) {
      if (!this.channels["presence-" + name]) {
        this.channels["presence-" + name] = new PusherPresenceChannel(this.pusher, "presence-" + name, this.options);
      }
      return this.channels["presence-" + name];
    }
    /**
     * Leave the given channel, as well as its private and presence variants.
     */
  }, {
    key: "leave",
    value: function leave(name) {
      var _this2 = this;
      var channels = [name, "private-" + name, "private-encrypted-" + name, "presence-" + name];
      channels.forEach(function(name2, index) {
        _this2.leaveChannel(name2);
      });
    }
    /**
     * Leave the given channel.
     */
  }, {
    key: "leaveChannel",
    value: function leaveChannel(name) {
      if (this.channels[name]) {
        this.channels[name].unsubscribe();
        delete this.channels[name];
      }
    }
    /**
     * Get the socket ID for the connection.
     */
  }, {
    key: "socketId",
    value: function socketId() {
      return this.pusher.connection.socket_id;
    }
    /**
     * Disconnect Pusher connection.
     */
  }, {
    key: "disconnect",
    value: function disconnect() {
      this.pusher.disconnect();
    }
  }]);
  return PusherConnector2;
}(Connector);
var SocketIoConnector = function(_Connector) {
  _inherits(SocketIoConnector2, _Connector);
  var _super = _createSuper(SocketIoConnector2);
  function SocketIoConnector2() {
    var _this;
    _classCallCheck(this, SocketIoConnector2);
    _this = _super.apply(this, arguments);
    _this.channels = {};
    return _this;
  }
  _createClass(SocketIoConnector2, [{
    key: "connect",
    value: function connect() {
      var _this2 = this;
      var io2 = this.getSocketIO();
      this.socket = io2(this.options.host, this.options);
      this.socket.on("reconnect", function() {
        Object.values(_this2.channels).forEach(function(channel) {
          channel.subscribe();
        });
      });
      return this.socket;
    }
    /**
     * Get socket.io module from global scope or options.
     */
  }, {
    key: "getSocketIO",
    value: function getSocketIO() {
      if (typeof this.options.client !== "undefined") {
        return this.options.client;
      }
      if (typeof io !== "undefined") {
        return io;
      }
      throw new Error("Socket.io client not found. Should be globally available or passed via options.client");
    }
    /**
     * Listen for an event on a channel instance.
     */
  }, {
    key: "listen",
    value: function listen(name, event, callback) {
      return this.channel(name).listen(event, callback);
    }
    /**
     * Get a channel instance by name.
     */
  }, {
    key: "channel",
    value: function channel(name) {
      if (!this.channels[name]) {
        this.channels[name] = new SocketIoChannel(this.socket, name, this.options);
      }
      return this.channels[name];
    }
    /**
     * Get a private channel instance by name.
     */
  }, {
    key: "privateChannel",
    value: function privateChannel(name) {
      if (!this.channels["private-" + name]) {
        this.channels["private-" + name] = new SocketIoPrivateChannel(this.socket, "private-" + name, this.options);
      }
      return this.channels["private-" + name];
    }
    /**
     * Get a presence channel instance by name.
     */
  }, {
    key: "presenceChannel",
    value: function presenceChannel(name) {
      if (!this.channels["presence-" + name]) {
        this.channels["presence-" + name] = new SocketIoPresenceChannel(this.socket, "presence-" + name, this.options);
      }
      return this.channels["presence-" + name];
    }
    /**
     * Leave the given channel, as well as its private and presence variants.
     */
  }, {
    key: "leave",
    value: function leave(name) {
      var _this3 = this;
      var channels = [name, "private-" + name, "presence-" + name];
      channels.forEach(function(name2) {
        _this3.leaveChannel(name2);
      });
    }
    /**
     * Leave the given channel.
     */
  }, {
    key: "leaveChannel",
    value: function leaveChannel(name) {
      if (this.channels[name]) {
        this.channels[name].unsubscribe();
        delete this.channels[name];
      }
    }
    /**
     * Get the socket ID for the connection.
     */
  }, {
    key: "socketId",
    value: function socketId() {
      return this.socket.id;
    }
    /**
     * Disconnect Socketio connection.
     */
  }, {
    key: "disconnect",
    value: function disconnect() {
      this.socket.disconnect();
    }
  }]);
  return SocketIoConnector2;
}(Connector);
var NullConnector = function(_Connector) {
  _inherits(NullConnector2, _Connector);
  var _super = _createSuper(NullConnector2);
  function NullConnector2() {
    var _this;
    _classCallCheck(this, NullConnector2);
    _this = _super.apply(this, arguments);
    _this.channels = {};
    return _this;
  }
  _createClass(NullConnector2, [{
    key: "connect",
    value: function connect() {
    }
    /**
     * Listen for an event on a channel instance.
     */
  }, {
    key: "listen",
    value: function listen(name, event, callback) {
      return new NullChannel();
    }
    /**
     * Get a channel instance by name.
     */
  }, {
    key: "channel",
    value: function channel(name) {
      return new NullChannel();
    }
    /**
     * Get a private channel instance by name.
     */
  }, {
    key: "privateChannel",
    value: function privateChannel(name) {
      return new NullPrivateChannel();
    }
    /**
     * Get a private encrypted channel instance by name.
     */
  }, {
    key: "encryptedPrivateChannel",
    value: function encryptedPrivateChannel(name) {
      return new NullPrivateChannel();
    }
    /**
     * Get a presence channel instance by name.
     */
  }, {
    key: "presenceChannel",
    value: function presenceChannel(name) {
      return new NullPresenceChannel();
    }
    /**
     * Leave the given channel, as well as its private and presence variants.
     */
  }, {
    key: "leave",
    value: function leave(name) {
    }
    /**
     * Leave the given channel.
     */
  }, {
    key: "leaveChannel",
    value: function leaveChannel(name) {
    }
    /**
     * Get the socket ID for the connection.
     */
  }, {
    key: "socketId",
    value: function socketId() {
      return "fake-socket-id";
    }
    /**
     * Disconnect the connection.
     */
  }, {
    key: "disconnect",
    value: function disconnect() {
    }
  }]);
  return NullConnector2;
}(Connector);
var Echo = function() {
  function Echo2(options) {
    _classCallCheck(this, Echo2);
    this.options = options;
    this.connect();
    if (!this.options.withoutInterceptors) {
      this.registerInterceptors();
    }
  }
  _createClass(Echo2, [{
    key: "channel",
    value: function channel(_channel) {
      return this.connector.channel(_channel);
    }
    /**
     * Create a new connection.
     */
  }, {
    key: "connect",
    value: function connect() {
      if (this.options.broadcaster == "reverb") {
        this.connector = new PusherConnector(_extends(_extends({}, this.options), {
          cluster: ""
        }));
      } else if (this.options.broadcaster == "pusher") {
        this.connector = new PusherConnector(this.options);
      } else if (this.options.broadcaster == "socket.io") {
        this.connector = new SocketIoConnector(this.options);
      } else if (this.options.broadcaster == "null") {
        this.connector = new NullConnector(this.options);
      } else if (typeof this.options.broadcaster == "function") {
        this.connector = new this.options.broadcaster(this.options);
      } else {
        throw new Error("Broadcaster ".concat(_typeof(this.options.broadcaster), " ").concat(this.options.broadcaster, " is not supported."));
      }
    }
    /**
     * Disconnect from the Echo server.
     */
  }, {
    key: "disconnect",
    value: function disconnect() {
      this.connector.disconnect();
    }
    /**
     * Get a presence channel instance by name.
     */
  }, {
    key: "join",
    value: function join(channel) {
      return this.connector.presenceChannel(channel);
    }
    /**
     * Leave the given channel, as well as its private and presence variants.
     */
  }, {
    key: "leave",
    value: function leave(channel) {
      this.connector.leave(channel);
    }
    /**
     * Leave the given channel.
     */
  }, {
    key: "leaveChannel",
    value: function leaveChannel(channel) {
      this.connector.leaveChannel(channel);
    }
    /**
     * Leave all channels.
     */
  }, {
    key: "leaveAllChannels",
    value: function leaveAllChannels() {
      for (var channel in this.connector.channels) {
        this.leaveChannel(channel);
      }
    }
    /**
     * Listen for an event on a channel instance.
     */
  }, {
    key: "listen",
    value: function listen(channel, event, callback) {
      return this.connector.listen(channel, event, callback);
    }
    /**
     * Get a private channel instance by name.
     */
  }, {
    key: "private",
    value: function _private(channel) {
      return this.connector.privateChannel(channel);
    }
    /**
     * Get a private encrypted channel instance by name.
     */
  }, {
    key: "encryptedPrivate",
    value: function encryptedPrivate(channel) {
      return this.connector.encryptedPrivateChannel(channel);
    }
    /**
     * Get the Socket ID for the connection.
     */
  }, {
    key: "socketId",
    value: function socketId() {
      return this.connector.socketId();
    }
    /**
     * Register 3rd party request interceptiors. These are used to automatically
     * send a connections socket id to a Laravel app with a X-Socket-Id header.
     */
  }, {
    key: "registerInterceptors",
    value: function registerInterceptors() {
      if (typeof Vue === "function" && Vue.http) {
        this.registerVueRequestInterceptor();
      }
      if (typeof axios === "function") {
        this.registerAxiosRequestInterceptor();
      }
      if (typeof jQuery === "function") {
        this.registerjQueryAjaxSetup();
      }
      if ((typeof Turbo === "undefined" ? "undefined" : _typeof(Turbo)) === "object") {
        this.registerTurboRequestInterceptor();
      }
    }
    /**
     * Register a Vue HTTP interceptor to add the X-Socket-ID header.
     */
  }, {
    key: "registerVueRequestInterceptor",
    value: function registerVueRequestInterceptor() {
      var _this = this;
      Vue.http.interceptors.push(function(request, next) {
        if (_this.socketId()) {
          request.headers.set("X-Socket-ID", _this.socketId());
        }
        next();
      });
    }
    /**
     * Register an Axios HTTP interceptor to add the X-Socket-ID header.
     */
  }, {
    key: "registerAxiosRequestInterceptor",
    value: function registerAxiosRequestInterceptor() {
      var _this2 = this;
      axios.interceptors.request.use(function(config) {
        if (_this2.socketId()) {
          config.headers["X-Socket-Id"] = _this2.socketId();
        }
        return config;
      });
    }
    /**
     * Register jQuery AjaxPrefilter to add the X-Socket-ID header.
     */
  }, {
    key: "registerjQueryAjaxSetup",
    value: function registerjQueryAjaxSetup() {
      var _this3 = this;
      if (typeof jQuery.ajax != "undefined") {
        jQuery.ajaxPrefilter(function(options, originalOptions, xhr) {
          if (_this3.socketId()) {
            xhr.setRequestHeader("X-Socket-Id", _this3.socketId());
          }
        });
      }
    }
    /**
     * Register the Turbo Request interceptor to add the X-Socket-ID header.
     */
  }, {
    key: "registerTurboRequestInterceptor",
    value: function registerTurboRequestInterceptor() {
      var _this4 = this;
      document.addEventListener("turbo:before-fetch-request", function(event) {
        event.detail.fetchOptions.headers["X-Socket-Id"] = _this4.socketId();
      });
    }
  }]);
  return Echo2;
}();
export {
  Channel,
  Connector,
  EventFormatter,
  Echo as default
};
//# sourceMappingURL=laravel-echo.js.map
