<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('gold_rates', function (Blueprint $table) {
            $table->id();
            $table->string('currency_code')->nullable();
            $table->string('currency_rate')->nullable();
            $table->string('unit_type')->nullable();
            $table->string('gold_rate')->nullable();
            $table->string('ounce_gold_rate')->nullable();
            $table->string('karat24_rate')->nullable();
            $table->string('karat22_rate')->nullable();
            $table->string('karat21_rate')->nullable();
            $table->string('karat18_rate')->nullable();
            $table->string('gmt_datetime_gold_updated')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('gold_rates');
    }
};
