<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateThemeSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('theme_settings', function (Blueprint $table) {
            $table->id();
            $table->string('header_type')->nullable();
            $table->string('header_single_color')->nullable();
            $table->string('header_gradient_color1')->nullable();
            $table->string('header_gradient_color2')->nullable();
            $table->string('header_gradient_direction')->nullable();
            $table->binary('header_image')->nullable();
            $table->string('footer_type')->nullable();
            $table->string('footer_single_color')->nullable();
            $table->string('footer_gradient_color1')->nullable();
            $table->string('footer_gradient_color2')->nullable();
            $table->string('footer_gradient_direction')->nullable();
            $table->binary('footer_image')->nullable();
            $table->string('login_type')->nullable();
            $table->string('login_single_color')->nullable();
            $table->string('login_gradient_color1')->nullable();
            $table->string('login_gradient_color2')->nullable();
            $table->string('login_gradient_direction')->nullable();
            $table->binary('login_image')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('theme_settings');
    }
}
