<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    use HasFactory;

    protected $table = "categories";

    protected $fillable = [
        'name',
        'slug',
        'feature_image',
        'logo_image'

    ];

    public function stores()
    {
        return $this->hasMany(Store::class);
    }
    public function blogs()
    {
        return $this->hasMany(Blog::class);
    }
    public function subcategories()
    {
        return $this->hasMany(SubCategory::class);
    }
}
