<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class Blog extends Model {        
    use HasFactory;        
     

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function sub_category()
    {
        return $this->belongsTo(SubCategory::class);
    }

    public function comment()
    {
        return $this->hasMany(Comment::class);
    }

    public function wishlist()
    {
        return $this->hasMany(BlogSavedByUser::class);
    }
}
