<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        $page_data = [
            'title' => 'Users',
            'slug'  => 'All User Records'
        ];

        $users = User::orderBy('id', 'DESC')->paginate(10);
        return view('admin.pages.users.index', get_defined_vars())
            ->with('i', ($request->input('page', 1) - 1) * 5);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $page_data = [
            'title' => 'Users',
            'slug'  => 'Add New User'
        ];

        return view('admin.pages.users.create',get_defined_vars());

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        // dd($request->all());
        
        $user = new User;
        $this->validate($request,[
            'name' => 'required',
            'password' => 'required|string|min:8|regex:/^(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[0-9])(?=.*?[#?!@$%^&*-]).{6,}$/',
            'email' => 'required|email|unique:users'
        ]);


        $user->name = $request->name;
        $user->email = $request->email;
        $user->password = sha1($request->password);
        $user->status = 'active';
        if ($user->save()) {

            return redirect()->route('users.index')->withSuccess('User created successfully.');

        } else {
            return back()->withError('Something went wrong!');

        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $page_data = [
            'title' => 'Users',
            'slug'  => 'Edit User'
        ];

        $user = User::find($id);
        return view('admin.pages.users.edit', get_defined_vars());

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        // dd($request->all());
        $user = User::find($id);
        $this->validate($request,[
            'name' => 'required',
            'email' => 'required|email'
        ]);


        $user->name = $request->name;
        $user->email = $request->email;
        $user->status = $request->status;
        if ($user->update()) {

            return redirect()->route('users.index')->withSuccess('User updated successfully.');

        } else {
            return back()->withError('Something went wrong!');

        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $user = User::find($id);
        if ($user->delete()) {

            return back()->with('success', 'User deleted successfully.');

        } else {
            return back()->with('error', 'Something went wrong!');

        }
    }
}
