<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\SubCategory;
use Illuminate\Http\Request;
use App\Models\Category;
use Str;
use Cache;

use Illuminate\Contracts\Cache\Factory;
use Illuminate\Contracts\Cache\Repository;

class SubCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        $page_data = [
            'title' => 'Sub Categories',
            'slug' => 'All Sub Categories'
        ];

        $page = request()->get('page', 1);
        $limit = request()->get('limit', 10);
        $subcategories = Cache::remember('subcategories' . $page, 20, function () use ($limit) {
            return SubCategory::with('category:id,name')->orderby('id','desc')->paginate($limit);
        });

        return view('admin.pages.subcategories.index', get_defined_vars())
            ->with('i', ($page - 1) * 5);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $page_data = [
            'title' => 'Sub Categories',
            'slug' => 'Add New Sub Categories'
        ];
        $categories = Category::pluck('name','id');
        // dd($categories);
        return view('admin.pages.subcategories.create', get_defined_vars());
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $subcategory = new SUbCategory;

        if ($request->hasFile('feature_image')) {

            $featuredfile = $request->file('feature_image');
            $featuredimage = uniqid() . '.' . $featuredfile->guessExtension();
            $image_path = $featuredfile->move(public_path() . '/admin-assets/images/categories/', $featuredimage);
            $subcategory->feature_image = $featuredimage;

        }
        if ($request->hasFile('logo_image')) {

            $logofile = $request->file('logo_image');
            $logoimage = uniqid() . '.' . $logofile->guessExtension();
            $image_path = $logofile->move(public_path() . '/admin-assets/images/categories/', $logoimage);
            $subcategory->logo_image = $logoimage;

        }
        $subcategory->category_id = $request->category_id;
        $subcategory->name = $request->name;
        $subcategory->slug = Str::slug($request->name);

        if ($subcategory->save()) {
            return redirect()->route('subcategories.index')->withSuccess('SubCategory Added Successfully');
        } else {
            return back()->withError('Something went wrong!');
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $page_data = [
            'title' => 'Sub Categories',
            'slug' => 'Edit Sub Categories'
        ];
        $subcategory = SubCategory::with('category:id','name')->where('id', $id)->first();
        $categories = Category::pluck('id','name');
        return view('admin.pages.subcategories.edit', get_defined_vars());
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $subcategory = SubCategory::find($id);

        if ($request->hasFile('feature_image')) {

            $featuredfile = $request->file('feature_image');
            $featuredimage = uniqid() . '.' . $featuredfile->guessExtension();
            $image_path = $featuredfile->move(public_path() . '/admin-assets/images/categories/', $featuredimage);
            $subcategory->feature_image = $featuredimage;

        }
        if ($request->hasFile('logo_image')) {

            $logofile = $request->file('logo_image');
            $logoimage = uniqid() . '.' . $logofile->guessExtension();
            $image_path = $logofile->move(public_path() . '/admin-assets/images/categories/', $logoimage);
            $subcategory->feature_image = $logoimage;

        }
        $subcategory->category_id = $request->category_id;
        $subcategory->name = $request->name;
        $subcategory->slug = Str::slug($request->name);

        if ($subcategory->update()) {
            return redirect()->route('subcategories.index')->withSuccess('SUbCategory updated Successfully');
        } else {
            return back()->withError('Something went wrong!');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $subcategory = SubCategory::find($id);
        if ($subcategory->delete()) {

            return back()->withSuccess('SubCategory deleted Successfully');
        } else {
            return back()->withError('Something went wrong!');
        }
    }
}
