<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Page;
use Str;

class PageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $page_data = [
            'title' => 'Extra Pages',
            'slug' => 'All Pages'
        ];
        $pages= Page::select('id','title')->get();
        // dd($pages);
        return view('admin.pages.extra-pages.index',get_defined_vars());
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $page_data = [
            'title' => 'Extra Pages',
            'slug' => 'Add New Page'
        ];
        return view('admin.pages.extra-pages.create',get_defined_vars());
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $page = new Page();
        $page->title = $request->title;
        $page->slug = Str::slug($request->title);
        $page->details = $request->details;
        $page->meta_title = $request->meta_title;
        $page->meta_description = $request->meta_description;
        if($page->save())
        {
            return redirect()->route('pages.index')->withSuccess('Page Added Successfully!');
        }
        else{
            return back()->withError('Something went wrong!');
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $page_data = [
            'title' => 'Extra Pages',
            'slug' => 'Edit Page'
        ];
        $page = Page::find($id);
        return view('admin.pages.extra-pages.edit',get_defined_vars());
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,$id)
    {
        //
        // dd($request->all());
        $page = Page::find($id);
        $page->title = $request->title;
        $page->slug = Str::slug($request->title);
        $page->details = $request->details;
        $page->meta_title = $request->meta_title;
        $page->meta_description = $request->meta_description;
        if($page->update())
        {
            return redirect()->route('pages.index')->withSuccess('Page updated Successfully!');
        }
        else{
            return back()->withError('Something went wrong!');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $page = Page::find($id);
        if($page->delete())
        {
            return redirect()->route('pages.index')->withSuccess('Page deleted Successfully!');
        }
        else{
            return back()->withError('Something went wrong!');
        }

    }
}
