<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Category;
use Str;
use Cache;

use Illuminate\Contracts\Cache\Factory;
use Illuminate\Contracts\Cache\Repository;

class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        $page_data = [
            'title' => 'Categories',
            'slug' => 'All Categories'
        ];

        $page = request()->get('page', 1);
        $limit = request()->get('limit', 10);
        $categories = Cache::remember('categories' . $page, 20, function () use ($limit) {
            return Category::orderby('id','desc')->paginate($limit);
        });

        return view('admin.pages.categories.index', get_defined_vars())
            ->with('i', ($page - 1) * 5);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $page_data = [
            'title' => 'Categories',
            'slug' => 'Add New Categories'
        ];
        return view('admin.pages.categories.create', get_defined_vars());
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $category = new Category;

        if ($request->hasFile('feature_image')) {

            $featuredfile = $request->file('feature_image');
            $featuredimage = uniqid() . '.' . $featuredfile->guessExtension();
            $image_path = $featuredfile->move(public_path() . '/admin-assets/images/categories/', $featuredimage);
            $category->feature_image = $featuredimage;

        }
        if ($request->hasFile('logo_image')) {

            $logofile = $request->file('logo_image');
            $logoimage = uniqid() . '.' . $logofile->guessExtension();
            $image_path = $logofile->move(public_path() . '/admin-assets/images/categories/', $logoimage);
            $category->logo_image = $logoimage;

        }
        $category->name = $request->name;
        $category->slug = Str::slug($request->name);

        if ($category->save()) {
            return redirect()->route('categories.index')->withSuccess('Category Added Successfully');
        } else {
            return back()->withError('Something went wrong!');
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $page_data = [
            'title' => 'Categories',
            'slug' => 'Edit Categories'
        ];
        $category = Category::where('id', $id)->first();
        return view('admin.pages.categories.edit', get_defined_vars());
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $category = Category::find($id);

        if ($request->hasFile('feature_image')) {

            $featuredfile = $request->file('feature_image');
            $featuredimage = uniqid() . '.' . $featuredfile->guessExtension();
            $image_path = $featuredfile->move(public_path() . '/admin-assets/images/categories/', $featuredimage);
            $category->feature_image = $featuredimage;

        }
        if ($request->hasFile('logo_image')) {

            $logofile = $request->file('logo_image');
            $logoimage = uniqid() . '.' . $logofile->guessExtension();
            $image_path = $logofile->move(public_path() . '/admin-assets/images/categories/', $logoimage);
            $category->logo_image = $logoimage;

        }
        $category->name = $request->name;
        $category->slug = Str::slug($request->name);

        if ($category->update()) {
            return redirect()->route('categories.index')->withSuccess('Category updated Successfully');
        } else {
            return back()->withError('Something went wrong!');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $category = Category::find($id);
        if ($category->delete()) {

            return back()->withSuccess('Category deleted Successfully');
        } else {
            return back()->withError('Something went wrong!');
        }
    }
}
